/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.marker;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.marker.AbstractBaseChartPaintListener;
import org.eclipse.swtchart.extensions.marker.IBaseChartPaintListener;

public class LabelMarker
extends AbstractBaseChartPaintListener
implements IBaseChartPaintListener {
    private Transform transform = null;
    private Map<Integer, String> labels = new HashMap<Integer, String>();
    private int indexSeries = -1;
    private ISeries serie;

    public LabelMarker(BaseChart baseChart) {
        super(baseChart);
    }

    public void setLabels(List<String> labels, int indexSeries, int orientation) {
        HashMap<Integer, String> labelsMap = new HashMap<Integer, String>();
        int index = 0;
        for (String label : labels) {
            labelsMap.put(index++, label);
        }
        this.setLabels(labelsMap, indexSeries, orientation);
    }

    public void setLabels(Map<Integer, String> labels, int indexSeries, int orientation) {
        this.setSeriesIndex(indexSeries);
        this.setLabels(labels, orientation);
    }

    public void setLabels(Map<Integer, String> labels, int orientation) {
        HashMap hashMap = this.labels = labels != null ? labels : new HashMap();
        if (orientation == 512) {
            this.disposeTransform();
            this.transform = new Transform((Device)Display.getDefault());
            this.transform.rotate(-90.0f);
        } else {
            this.transform = null;
        }
    }

    public void setSeriesIndex(int indexSeries) {
        this.indexSeries = indexSeries;
    }

    public void setSeries(ISeries serie) {
        this.serie = serie;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.disposeTransform();
    }

    private void disposeTransform() {
        if (this.transform != null) {
            this.transform.dispose();
        }
    }

    public void clear() {
        this.labels.clear();
    }

    public void paintControl(PaintEvent e) {
        ISeries serie = this.getSeries();
        if (serie == null) {
            return;
        }
        BaseChart baseChart = this.getBaseChart();
        Rectangle rectangle = baseChart.getPlotArea().getClientArea();
        int size = serie.getXSeries().length;
        for (int index : this.labels.keySet()) {
            int y;
            int x;
            if (index >= size) continue;
            String label = this.labels.get(index);
            Point point = serie.getPixelCoordinates(index);
            if (point.x <= 0 || !rectangle.contains(point)) continue;
            Point labelSize = e.gc.textExtent(label);
            GC gc = e.gc;
            if (this.transform != null) {
                gc.setTransform(this.transform);
                x = -labelSize.x - (point.y - labelSize.x - 15);
                y = point.x - labelSize.y / 2;
            } else {
                x = point.x - labelSize.x / 2;
                y = point.y - labelSize.y - 15;
            }
            gc.drawText(label, x, y, true);
            gc.setTransform(null);
        }
    }

    protected ISeries getSeries() {
        if (this.serie != null) {
            return this.serie;
        }
        ISeries[] series = this.getBaseChart().getSeriesSet().getSeries();
        if (this.indexSeries >= 0 && this.indexSeries < series.length) {
            return series[this.indexSeries];
        }
        return null;
    }
}

