/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.export.core;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.export.core.Messages;
import org.eclipse.swtchart.extensions.barcharts.IBarSeriesSettings;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.ISeriesSettings;
import org.eclipse.swtchart.extensions.core.MappingsSupport;
import org.eclipse.swtchart.extensions.core.ResourceSupport;
import org.eclipse.swtchart.extensions.core.SeriesListUI;
import org.eclipse.swtchart.extensions.dialogs.BarSeriesSettingsDialog;
import org.eclipse.swtchart.extensions.dialogs.CircularSeriesSettingsDialog;
import org.eclipse.swtchart.extensions.dialogs.LineSeriesSettingsDialog;
import org.eclipse.swtchart.extensions.dialogs.ScatterSeriesSettingsDialog;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesSettings;
import org.eclipse.swtchart.extensions.piecharts.ICircularSeriesSettings;
import org.eclipse.swtchart.extensions.scattercharts.IScatterSeriesSettings;

public class VectorExportSettingsDialog
extends TitleAreaDialog {
    private AtomicReference<SeriesListUI> listControl = new AtomicReference();
    private IPreferenceStore preferenceStore = ResourceSupport.getPreferenceStore();
    private Map<String, ISeriesSettings> cachedSeriesSettings = new HashMap<String, ISeriesSettings>();
    private Combo comboScaleX;
    private Combo comboScaleY;
    private int indexAxisX;
    private int indexAxisY;
    private BaseChart baseChart = null;

    public VectorExportSettingsDialog(Shell parent, BaseChart baseChart) {
        super(parent);
        ISeries[] seriesArray;
        this.baseChart = baseChart;
        ISeries[] iSeriesArray = seriesArray = baseChart.getSeriesSet().getSeries();
        int n = seriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISeriesSettings seriesSettingsCopy;
            ISeries series = iSeriesArray[n2];
            String id = series.getId();
            ISeriesSettings seriesSettings = baseChart.getSeriesSettings(id);
            if (seriesSettings != null && (seriesSettingsCopy = MappingsSupport.copySettings((ISeriesSettings)seriesSettings)) != null) {
                this.cachedSeriesSettings.put(id, seriesSettingsCopy);
            }
            ++n2;
        }
    }

    public void create() {
        super.create();
        this.setTitle(Messages.getString("EXPORT_AXIS_SELECTION"));
        this.setMessage(Messages.getString("SELECT_X_Y_TO_EXPORT"), 1);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(composite, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        this.createSelectionAxisX(container);
        this.createSelectionAxisY(container);
        this.createSeriesList(container);
        return composite;
    }

    private void createSeriesList(Composite container) {
        final SeriesListUI seriesListUI = new SeriesListUI(container, 68354);
        seriesListUI.setTableSortable(this.preferenceStore.getBoolean("sortLegendTable"));
        Table table = seriesListUI.getTable();
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        table.setLayoutData((Object)gridData);
        seriesListUI.setInput((Object)this.baseChart.getSeriesSet());
        seriesListUI.setBaseChart(this.baseChart);
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                Object object = seriesListUI.getStructuredSelection().getFirstElement();
                if (object instanceof ISeries) {
                    ISeries series = (ISeries)object;
                    ISeriesSettings seriesSettings = VectorExportSettingsDialog.this.baseChart.getSeriesSettings(series.getId());
                    Shell shell = e.display.getActiveShell();
                    BarSeriesSettingsDialog settingsDialog = null;
                    if (seriesSettings instanceof IBarSeriesSettings) {
                        IBarSeriesSettings settings = (IBarSeriesSettings)seriesSettings;
                        settingsDialog = new BarSeriesSettingsDialog(shell, settings);
                    } else if (seriesSettings instanceof ICircularSeriesSettings) {
                        ICircularSeriesSettings settings = (ICircularSeriesSettings)seriesSettings;
                        settingsDialog = new CircularSeriesSettingsDialog(shell, settings);
                    } else if (seriesSettings instanceof ILineSeriesSettings) {
                        ILineSeriesSettings settings = (ILineSeriesSettings)seriesSettings;
                        settingsDialog = new LineSeriesSettingsDialog(shell, settings);
                    } else if (seriesSettings instanceof IScatterSeriesSettings) {
                        IScatterSeriesSettings settings = (IScatterSeriesSettings)seriesSettings;
                        settingsDialog = new ScatterSeriesSettingsDialog(shell, settings);
                    }
                    if (settingsDialog != null && settingsDialog.open() == 0) {
                        VectorExportSettingsDialog.this.applySettings(VectorExportSettingsDialog.this.baseChart, series, seriesSettings, true);
                    }
                }
            }
        });
        this.listControl.set(seriesListUI);
    }

    private void applySettings(BaseChart baseChart, ISeries<?> series, ISeriesSettings seriesSettingsSource, boolean refresh) {
        baseChart.applySeriesSettings(series, seriesSettingsSource, true);
        if (refresh) {
            baseChart.redraw();
            this.listControl.get().refresh();
        }
    }

    private void createSelectionAxisX(Composite container) {
        Label label = new Label(container, 0);
        label.setText(Messages.getString("X_AXIS"));
        String[] axisLabelsX = this.baseChart.getAxisLabels("X_AXIS");
        this.comboScaleX = new Combo(container, 8);
        this.comboScaleX.setItems(axisLabelsX);
        this.comboScaleX.setLayoutData((Object)new GridData(768));
        if (axisLabelsX.length > 0) {
            this.comboScaleX.select(0);
        }
    }

    private void createSelectionAxisY(Composite container) {
        Label label = new Label(container, 0);
        label.setText(Messages.getString("Y_AXIS"));
        String[] axisLabelsY = this.baseChart.getAxisLabels("Y_AXIS");
        this.comboScaleY = new Combo(container, 8);
        this.comboScaleY.setItems(axisLabelsY);
        this.comboScaleY.setLayoutData((Object)new GridData(768));
        if (axisLabelsY.length > 0) {
            this.comboScaleY.select(0);
        }
    }

    protected boolean isResizable() {
        return true;
    }

    private void saveInput() {
        this.indexAxisX = this.comboScaleX.getSelectionIndex();
        this.indexAxisY = this.comboScaleY.getSelectionIndex();
    }

    protected void okPressed() {
        this.saveInput();
        super.okPressed();
    }

    public int getIndexAxisSelectionX() {
        return this.indexAxisX;
    }

    public int getIndexAxisSelectionY() {
        return this.indexAxisY;
    }

    public void reset() {
        ISeries[] seriesArray;
        ISeries[] iSeriesArray = seriesArray = this.baseChart.getSeriesSet().getSeries();
        int n = seriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISeriesSettings seriesSettings;
            ISeries series = iSeriesArray[n2];
            String id = series.getId();
            ISeriesSettings seriesSettingsCache = this.cachedSeriesSettings.get(id);
            if (seriesSettingsCache != null && (seriesSettings = this.baseChart.getSeriesSettings(id)) != null) {
                MappingsSupport.transferSettings((ISeriesSettings)seriesSettingsCache, (ISeriesSettings)seriesSettings);
                this.baseChart.applySeriesSettings(series, seriesSettings, true);
            }
            ++n2;
        }
        this.baseChart.redraw();
    }
}

