/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.export.core;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swtchart.extensions.core.ResourceSupport;

public class BitmapExportSettingsDialog
extends TitleAreaDialog {
    private Rectangle boundsMax;
    private boolean customSize = false;
    private int customWidth = 0;
    private int customHeight = 0;
    private Text textWidth;
    private Text textHeight;
    private IPreferenceStore preferenceStore = ResourceSupport.getPreferenceStore();

    public BitmapExportSettingsDialog(Shell parent) {
        super(parent);
    }

    public void create() {
        super.create();
        this.setTitle("Export Bitmap");
        this.setMessage("Define the bitmap export settings.");
    }

    public boolean isCustomSize() {
        return this.customSize;
    }

    public int getCustomWidth() {
        return this.customWidth;
    }

    public int getCustomHeight() {
        return this.customHeight;
    }

    protected Control createDialogArea(Composite parent) {
        this.boundsMax = Display.getCurrent().getBounds();
        this.customSize = this.preferenceStore != null ? this.preferenceStore.getBoolean("bitmapExportCustomSize") : false;
        this.customWidth = this.preferenceStore != null ? this.preferenceStore.getInt("bitmapExportWidth") : 512;
        this.customHeight = this.preferenceStore != null ? this.preferenceStore.getInt("bitmapExportHeight") : 512;
        Composite container = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(container, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        this.createLabelInfo(composite);
        this.createSectionCustomSize(composite);
        this.textWidth = this.createSectionWidth(composite);
        this.textHeight = this.createSectionHeight(composite);
        this.updateWidgets();
        return container;
    }

    protected void okPressed() {
        if (this.preferenceStore != null) {
            this.preferenceStore.setValue("bitmapExportCustomSize", this.customSize);
            this.preferenceStore.setValue("bitmapExportWidth", this.customWidth);
            this.preferenceStore.setValue("bitmapExportHeight", this.customHeight);
        }
        super.okPressed();
    }

    private void createLabelInfo(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("This display allows max '" + this.boundsMax.width + " x " + this.boundsMax.height + "' px");
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
    }

    private void createSectionCustomSize(Composite parent) {
        final Button button = new Button(parent, 32);
        button.setText("Custom Size");
        button.setToolTipText("Activate this to enable the custom size");
        button.setSelection(this.customSize);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BitmapExportSettingsDialog.this.customSize = button.getSelection();
                BitmapExportSettingsDialog.this.updateWidgets();
            }
        });
    }

    private Text createSectionWidth(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Custom Width");
        final Text text = new Text(parent, 2048);
        text.setText(Integer.toString(this.customWidth));
        text.setToolTipText("Max width: " + this.boundsMax.width);
        text.setEnabled(this.customSize);
        text.setLayoutData((Object)new GridData(768));
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                try {
                    int userWidth = Integer.parseInt(text.getText().trim());
                    userWidth = userWidth < 1 ? 1 : userWidth;
                    BitmapExportSettingsDialog.this.customWidth = userWidth > BitmapExportSettingsDialog.this.boundsMax.width ? BitmapExportSettingsDialog.this.boundsMax.width : userWidth;
                }
                catch (NumberFormatException e1) {
                    e1.printStackTrace();
                }
            }
        });
        return text;
    }

    private Text createSectionHeight(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Custom Height");
        final Text text = new Text(parent, 2048);
        text.setText(Integer.toString(this.customHeight));
        text.setToolTipText("Max height: " + this.boundsMax.height);
        text.setEnabled(this.customSize);
        text.setLayoutData((Object)new GridData(768));
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                try {
                    int userHeight = Integer.parseInt(text.getText().trim());
                    userHeight = userHeight < 1 ? 1 : userHeight;
                    BitmapExportSettingsDialog.this.customHeight = userHeight > BitmapExportSettingsDialog.this.boundsMax.height ? BitmapExportSettingsDialog.this.boundsMax.height : userHeight;
                }
                catch (NumberFormatException e1) {
                    e1.printStackTrace();
                }
            }
        });
        return text;
    }

    private void updateWidgets() {
        boolean enabled = this.customSize;
        this.textWidth.setEnabled(enabled);
        this.textHeight.setEnabled(enabled);
    }
}

