/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.export.extended.menu.vector;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.export.core.AbstractSeriesExportHandler;
import org.eclipse.swtchart.export.core.ExportSettingsDialog;
import org.eclipse.swtchart.export.core.ISeriesExportConverter;
import org.eclipse.swtchart.export.extended.menu.vector.Messages;
import org.eclipse.swtchart.export.extended.svg.SVGFactory;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.ScrollableChart;

public class SVGExportHandler
extends AbstractSeriesExportHandler
implements ISeriesExportConverter {
    private static final String FILE_EXTENSION = "*.svg";
    private static final String NAME = String.valueOf(Messages.getString("SVG")) + "*.svg" + ")";
    private static final String TITLE = Messages.getString("SAVE_AS_SVG");

    public String getName() {
        return NAME;
    }

    public void execute(Shell shell, ScrollableChart scrollableChart) {
        final FileDialog fileDialog = new FileDialog(shell, 8192);
        fileDialog.setOverwrite(true);
        fileDialog.setText(NAME);
        fileDialog.setFilterExtensions(new String[]{FILE_EXTENSION});
        final String fileName = fileDialog.open();
        if (fileName != null) {
            try {
                final BaseChart baseChart = scrollableChart.getBaseChart();
                ExportSettingsDialog exportSettingsDialog = new ExportSettingsDialog(fileDialog.getParent(), baseChart);
                exportSettingsDialog.create();
                if (exportSettingsDialog.open() == 0) {
                    final int indexAxisX = exportSettingsDialog.getIndexAxisSelectionX();
                    final int indexAxisY = exportSettingsDialog.getIndexAxisSelectionY();
                    if (indexAxisX >= 0 && indexAxisY >= 0) {
                        try {
                            ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(fileDialog.getParent());
                            monitorDialog.run(false, false, new IRunnableWithProgress(){

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    block6: {
                                        try {
                                            try {
                                                monitor.beginTask(Messages.getString("EXPORT_TO_SVG"), -1);
                                                boolean useCSS = true;
                                                OutputStreamWriter output = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "UTF-8");
                                                SVGFactory svgFactory = new SVGFactory();
                                                svgFactory.createSvg((Chart)baseChart, indexAxisX, indexAxisY);
                                                if (svgFactory.stream(output, useCSS)) {
                                                    MessageDialog.openInformation((Shell)fileDialog.getParent(), (String)TITLE, (String)MESSAGE_OK);
                                                    break block6;
                                                }
                                                MessageDialog.openInformation((Shell)fileDialog.getParent(), (String)TITLE, (String)MESSAGE_ERROR);
                                            }
                                            catch (Exception e) {
                                                e.printStackTrace();
                                                monitor.done();
                                            }
                                        }
                                        finally {
                                            monitor.done();
                                        }
                                    }
                                }
                            });
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            catch (Exception e) {
                MessageDialog.openInformation((Shell)shell, (String)TITLE, (String)MESSAGE_ERROR);
                e.printStackTrace();
            }
        }
    }
}

