/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.project.core.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.model.core.LtkModels;
import org.eclipse.statet.ltk.model.core.SourceUnitManager;
import org.eclipse.statet.ltk.model.core.build.SourceUnitIssueSupport;
import org.eclipse.statet.ltk.model.core.build.SourceUnitModelContainer;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.element.WorkspaceSourceUnit;
import org.eclipse.statet.ltk.project.core.LtkProject;
import org.eclipse.statet.ltk.project.core.builder.ProjectBuildParticipant;
import org.eclipse.statet.ltk.project.core.builder.ProjectTask;
import org.eclipse.statet.ltk.project.core.builder.ProjectTaskBuilder;

@NonNullByDefault
public abstract class ProjectBuildTask<TProject extends LtkProject, TSourceUnit extends WorkspaceSourceUnit, TParticipant extends ProjectBuildParticipant<TProject, TSourceUnit>>
extends ProjectTask<TProject, TSourceUnit, TParticipant>
implements IResourceVisitor,
IResourceDeltaVisitor {
    private final SourceUnitManager suManager = LtkModels.getSourceUnitManager();
    private final List<TSourceUnit> updatedSourceUnits;
    private final List<VirtualSourceUnit> removedFiles;
    private SubMonitor visitProgress = (SubMonitor)ObjectUtils.nonNullLateInit();

    public ProjectBuildTask(ProjectTaskBuilder<TProject, TSourceUnit, TParticipant> builder) {
        super(builder);
        this.updatedSourceUnits = new ArrayList<TSourceUnit>();
        this.removedFiles = new ArrayList<VirtualSourceUnit>();
    }

    private void dispose(SubMonitor m) {
        m.setWorkRemaining(this.updatedSourceUnits.size());
        for (WorkspaceSourceUnit unit : this.updatedSourceUnits) {
            unit.disconnect((IProgressMonitor)m.newChild(1));
        }
    }

    public void build(int kind, SubMonitor m) throws CoreException {
        try {
            IResourceDelta delta;
            m.beginTask(NLS.bind((String)"Preparing TeX build for ''{0}''", (Object)this.getProject().getName()), 12);
            switch (kind) {
                case 9: 
                case 10: {
                    delta = this.getBuilder().getDelta(this.getProject());
                    m.worked(1);
                    break;
                }
                default: {
                    delta = null;
                }
            }
            if (m.isCanceled()) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            m.setWorkRemaining(11);
            this.visitProgress = m.newChild(2);
            if (delta != null) {
                this.setBuildType(10);
                delta.accept((IResourceDeltaVisitor)this);
            } else {
                this.setBuildType(6);
                this.getProject().accept((IResourceVisitor)this);
            }
            this.visitProgress = (SubMonitor)ObjectUtils.nonNullLateInit();
            if (m.isCanceled()) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            this.processChanges(m.newChild(8, 0));
        }
        finally {
            m.setWorkRemaining(1);
            this.dispose(m.newChild(1));
            this.finish();
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if (resource.getType() == 1) {
            if (this.visitProgress.isCanceled()) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            this.visitProgress.setWorkRemaining(100);
            try {
                switch (delta.getKind()) {
                    case 1: 
                    case 4: {
                        this.visitFileAdded((IFile)resource, delta, this.visitProgress.newChild(1));
                        break;
                    }
                    case 2: {
                        this.visitFileRemove((IFile)resource, delta, this.visitProgress.newChild(1));
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.status.add((IStatus)new Status(4, this.getBuilderDefinition().getBundleId(), String.format("An error occurred when checking file '%1$s'", resource.getProjectRelativePath()), (Throwable)e));
            }
        }
        return true;
    }

    public boolean visit(IResource resource) throws CoreException {
        if (resource.getType() == 1) {
            this.visitProgress.setWorkRemaining(100);
            this.visitFileAdded((IFile)resource, null, this.visitProgress.newChild(1));
        }
        return true;
    }

    private void visitFileAdded(IFile file, @Nullable IResourceDelta delta, SubMonitor m) throws CoreException {
        IContentDescription contentDescription = file.getContentDescription();
        if (contentDescription == null) {
            return;
        }
        IContentType contentType = contentDescription.getContentType();
        if (contentType == null) {
            return;
        }
        ProjectTaskBuilder.BuilderDefinition definition = this.getBuilderDefinition();
        int contentId = definition.checkSourceUnitContent(contentType);
        if (contentId == 0) {
            SourceUnit unit = this.suManager.getSourceUnit(Ltk.PERSISTENCE_CONTEXT, file, contentType, true, (IProgressMonitor)m);
            if (definition.getSourceUnitType().isInstance(unit)) {
                this.updatedSourceUnits.add((WorkspaceSourceUnit)unit);
            } else {
                if (unit != null) {
                    unit.disconnect((IProgressMonitor)m);
                }
                this.clear(file);
            }
        }
    }

    private void visitFileRemove(IFile file, IResourceDelta delta, SubMonitor m) throws CoreException {
    }

    private void processChanges(SubMonitor m) throws CoreException {
        Object participant;
        m.beginTask(String.format("Analyzing %1$s file(s) of '%2$s'", this.getBuilderDefinition().getProjectTypeLabel(), this.getProject().getName()), 20);
        SubMonitor m1 = m.newChild(10);
        int workRemaining = this.removedFiles.size() + this.updatedSourceUnits.size() * 5;
        for (VirtualSourceUnit unit : this.removedFiles) {
            m1.setWorkRemaining(workRemaining--);
            try {
                participant = this.getParticipant(unit.getModelTypeId());
                if (participant != null) {
                    ((ProjectBuildParticipant)participant).handleSourceUnitRemoved(unit.getResource(), m1.newChild(1));
                }
            }
            catch (Exception e) {
                this.status.add((IStatus)new Status(4, this.getBuilderDefinition().getBundleId(), NLS.bind((String)"An error occurred when processing removed file ''{0}''.", (Object)unit.getResource()), (Throwable)e));
            }
            if (!m1.isCanceled()) continue;
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (!this.updatedSourceUnits.isEmpty()) {
            for (WorkspaceSourceUnit sourceUnit : this.updatedSourceUnits) {
                m1.setWorkRemaining(workRemaining);
                workRemaining -= 5;
                try {
                    participant = this.getParticipant(sourceUnit.getModelTypeId());
                    this.reconcileSourceUnit(sourceUnit, m1.newChild(3));
                    if (participant != null && ((ProjectBuildParticipant)participant).isEnabled()) {
                        ((ProjectBuildParticipant)participant).handleSourceUnitUpdated((WorkspaceSourceUnit)sourceUnit, m1.newChild(2));
                    }
                }
                catch (CancellationException e) {
                    throw new CoreException(Status.CANCEL_STATUS);
                }
                catch (Exception e) {
                    this.status.add((IStatus)new Status(4, this.getBuilderDefinition().getBundleId(), NLS.bind((String)"An error occurred when processing file ''{0}''.", (Object)sourceUnit.getResource()), (Throwable)e));
                }
                if (!m1.isCanceled()) continue;
                throw new CoreException(Status.CANCEL_STATUS);
            }
        }
        m1 = m.newChild(10);
        Collection participants = this.getParticipants();
        int workRemaining2 = participants.size();
        for (ProjectBuildParticipant participant2 : participants) {
            m1.setWorkRemaining(workRemaining2--);
            if (!participant2.isEnabled()) continue;
            try {
                participant2.finish(m1.newChild(1));
            }
            catch (Exception e) {
                this.status.add((IStatus)new Status(4, this.getBuilderDefinition().getBundleId(), String.format("An error occurred when processing %1$s file(s).", this.getBuilderDefinition().getProjectTypeLabel()), (Throwable)e));
            }
        }
    }

    protected void clearSourceUnit(SourceUnitModelContainer<?, ?> adapter) {
        try {
            SourceUnitIssueSupport issueSupport = adapter.getIssueSupport();
            if (issueSupport != null) {
                issueSupport.clearIssues((SourceUnit)adapter.getSourceUnit());
            }
        }
        catch (CoreException e) {
            this.status.add((IStatus)new Status(4, this.getBuilderDefinition().getBundleId(), String.format("An error occurred when clearing issue(s) of source unit '%1$s'.", adapter.getSourceUnit()), (Throwable)e));
        }
    }

    protected abstract void reconcileSourceUnit(TSourceUnit var1, SubMonitor var2);

    private static final class VirtualSourceUnit {
        private final IFile file;
        private final String modelTypeId;

        public VirtualSourceUnit(IFile file, String modelTypeId) {
            this.file = file;
            this.modelTypeId = modelTypeId;
        }

        public IFile getResource() {
            return this.file;
        }

        public String getModelTypeId() {
            return this.modelTypeId;
        }

        public int hashCode() {
            return this.file.hashCode();
        }

        public String toString() {
            return this.file.toString();
        }
    }
}

