/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rhelp.core.http.ee8.jetty;

import java.util.concurrent.Executor;
import javax.servlet.ServletContext;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rhelp.core.http.MediaTypeProvider;
import org.eclipse.statet.rhelp.core.http.ee8.ResourceHandler;
import org.eclipse.statet.rhelp.core.http.ee8.ServletMediaTypeProvider;
import org.eclipse.statet.rhelp.core.http.ee8.jetty.JettyResourceHandler;

@NonNullByDefault
public class JettyRHelpUtils {
    private static final String JETTY_EXECUTOR_KEY = "org.eclipse.jetty.server.Executor";
    private static @Nullable Executor executor;

    public static MediaTypeProvider getMediaTypes(ServletContext context) {
        return new ServletMediaTypeProvider(context);
    }

    public static ResourceHandler newResourceHandler(ServletContext context) {
        return new JettyResourceHandler(JettyRHelpUtils.getMediaTypes(context));
    }

    public static synchronized Executor getExecutor() {
        Executor executor = JettyRHelpUtils.executor;
        if (executor == null) {
            JettyRHelpUtils.executor = executor = new QueuedThreadPool(16, 2);
        }
        return executor;
    }

    public static void ensureExecutor(ServletContext context) {
        if (context.getAttribute(JETTY_EXECUTOR_KEY) == null) {
            context.setAttribute(JETTY_EXECUTOR_KEY, (Object)JettyRHelpUtils.getExecutor());
        }
    }

    private JettyRHelpUtils() {
    }
}

