/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.source.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.impl.AbstractAstNode;
import org.eclipse.statet.r.core.source.RTerminal;
import org.eclipse.statet.r.core.source.ast.Expression;
import org.eclipse.statet.r.core.source.ast.NodeType;
import org.eclipse.statet.r.core.source.ast.RAstVisitor;

@NonNullByDefault
public abstract class RAstNode
extends AbstractAstNode
implements AstNode {
    static final RAstNode[] NO_CHILDREN = new RAstNode[0];
    @Nullable RAstNode rParent;

    protected RAstNode(int statusCode, @Nullable RAstNode parent) {
        super(statusCode);
        this.rParent = parent;
    }

    protected RAstNode(@Nullable RAstNode parent) {
        this.rParent = parent;
    }

    protected RAstNode() {
    }

    public abstract NodeType getNodeType();

    public abstract @Nullable RTerminal getOperator(int var1);

    public @Nullable RAstNode getRParent() {
        return this.rParent;
    }

    public @Nullable AstNode getParent() {
        return this.rParent;
    }

    public final RAstNode getRRoot() {
        RAstNode p;
        RAstNode candidate = this;
        while ((p = candidate.rParent) != null) {
            candidate = p;
        }
        return candidate;
    }

    public abstract boolean hasChildren();

    public abstract int getChildCount();

    public abstract RAstNode getChild(int var1);

    public abstract int getChildIndex(AstNode var1);

    public abstract void acceptInR(RAstVisitor var1) throws InvocationTargetException;

    public abstract void acceptInRChildren(RAstVisitor var1) throws InvocationTargetException;

    final void setStatus(int statusCode) {
        this.doSetStatusCode(statusCode);
    }

    final void setStatusThis(int statusCode) {
        this.doSetStatusThis(statusCode);
    }

    final void clearStatusSeverityInChild() {
        this.doClearStatusSeverityInChild();
    }

    final void setStatusSeverityInChild(int statusCode) {
        this.doSetStatusSeverityInChild(statusCode);
    }

    final void setStatusSubsequent() {
        this.doAddStatusFlag(0x800000);
    }

    final void setStartOffset(int offset) {
        this.doSetStartOffset(offset);
    }

    final void setEndOffset(int offset) {
        this.doSetEndOffset(offset);
    }

    final void setStartEndOffset(int startOffset, int endOffset) {
        this.doSetStartEndOffset(startOffset, endOffset);
    }

    final void setStartEndOffset(int offset) {
        this.doSetStartEndOffset(offset);
    }

    int getEqualsIndex(RAstNode element) {
        int index = 0;
        int n = this.getChildCount();
        int i = 0;
        while (i < n) {
            RAstNode child = this.getChild(i);
            if (child == element) {
                return index;
            }
            if (child.equalsSingle(element)) {
                ++index;
            }
            ++i;
        }
        return -1;
    }

    abstract @Nullable Expression getExpr(RAstNode var1);

    abstract @Nullable Expression getLeftExpr();

    abstract @Nullable Expression getRightExpr();

    public final boolean equalsIgnoreAst(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RAstNode) || !this.equalsSingle((RAstNode)((Object)obj))) {
            return false;
        }
        RAstNode me = this;
        RAstNode other = (RAstNode)((Object)obj);
        while (me != other) {
            if (me.rParent == null || other.rParent == null) {
                return me.rParent == null && other.rParent == null;
            }
            if (!me.rParent.equalsSingle(other.rParent) || me.rParent.getEqualsIndex(me) != other.rParent.getEqualsIndex(other)) {
                return false;
            }
            me = me.rParent;
            other = other.rParent;
        }
        return true;
    }

    abstract boolean equalsSingle(RAstNode var1);

    public boolean equalsValue(RAstNode element) {
        if (this.getNodeType() != element.getNodeType()) {
            return false;
        }
        int count = this.getChildCount();
        if (count != element.getChildCount()) {
            return false;
        }
        int i = 0;
        while (i < count) {
            if (!this.getChild(i).equalsValue(element.getChild(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    void appendPathElement(StringBuilder s) {
        s.append('$');
        s.append(this.getNodeType().ordinal());
    }

    public int hashCodeIgnoreAst() {
        StringBuilder path = new StringBuilder();
        if (this.rParent != null) {
            if (this.rParent.rParent != null) {
                path.append(this.rParent.rParent.getNodeType().ordinal());
            }
            path.append('$');
            path.append(this.rParent.getNodeType().ordinal());
        }
        this.appendPathElement(path);
        return path.toString().hashCode();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.getNodeType().label);
        return s.toString();
    }

    abstract int getMissingExprStatus(Expression var1);

    static interface Assoc {
        public static final byte TERM = 1;
        public static final byte CONTAINER = 2;
        public static final byte NOSTD = 3;
        public static final byte LEFTSTD = 4;
        public static final byte RIGHTSTD = 5;
    }
}

