/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.rtool;

import java.util.ArrayList;
import org.eclipse.statet.ecommons.text.TextUtil;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.SystemRunnable;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.nico.core.runtime.SubmitType;
import org.eclipse.statet.nico.ui.NicoUITools;
import org.eclipse.statet.r.console.core.AbstractRDataRunnable;
import org.eclipse.statet.r.console.core.IRDataAdapter;
import org.eclipse.statet.r.console.core.RProcessREnvironment;
import org.eclipse.statet.r.console.core.RWorkspace;
import org.eclipse.statet.r.console.core.util.LoadReferenceRunnable;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.nico.impl.RjsController;
import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RList;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RReference;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.data.impl.RLanguageImpl;
import org.eclipse.statet.rj.data.impl.RList32Impl;
import org.eclipse.statet.rj.data.impl.RReferenceImpl;
import org.eclipse.statet.rj.services.FQRObject;
import org.eclipse.statet.rj.services.FunctionCall;
import org.eclipse.statet.rj.ts.core.RTool;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;

public class RElementInfoTask
extends AbstractRDataRunnable
implements SystemRunnable {
    private final RElementName elementName;
    private int status;
    private RElementInfoData data;

    public RElementInfoTask(RElementName name) {
        super("reditor/hover", "Collecting Element Detail for Hover");
        this.elementName = RElementName.normalize((RElementName)name);
    }

    public boolean preCheck() {
        return this.elementName.getType() == 17;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RElementInfoData load(RTool tool, Control control, IWorkbenchPart workbenchPart) {
        if (!NicoUITools.isToolReady((String)"R", (String)"org.eclipse.statet.r.data", (Tool)tool)) {
            return null;
        }
        try {
            RElementInfoTask rElementInfoTask = this;
            synchronized (rElementInfoTask) {
                Status status = tool.getQueue().addHot((ToolRunnable)this);
                if (status.getSeverity() >= 4) {
                    return null;
                }
                while (this.status == 0) {
                    if (Thread.interrupted()) {
                        this.status = -1;
                    }
                    ((Object)((Object)this)).wait(200L);
                }
            }
        }
        catch (InterruptedException e) {
            this.status = -1;
        }
        if (this.status != 1) {
            tool.getQueue().removeHot((ToolRunnable)this);
            return null;
        }
        RElementInfoData data = this.data;
        if (data != null && data.element != null) {
            data.control = control;
            data.workbenchPart = workbenchPart;
            data.tool = tool;
            return data;
        }
        return null;
    }

    public SubmitType getSubmitType() {
        return SubmitType.OTHER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changed(int event, Tool tool) {
        switch (event) {
            case 289: {
                return false;
            }
            case 288: 
            case 290: 
            case 340: 
            case 344: {
                this.status = -1;
                RElementInfoTask rElementInfoTask = this;
                synchronized (rElementInfoTask) {
                    ((Object)((Object)this)).notifyAll();
                    break;
                }
            }
            case 336: {
                this.status = 1;
                RElementInfoTask rElementInfoTask = this;
                synchronized (rElementInfoTask) {
                    ((Object)((Object)this)).notifyAll();
                    break;
                }
            }
        }
        return true;
    }

    protected void run(IRDataAdapter r, ProgressMonitor m) throws StatusException {
        String cmd;
        RObject robject;
        RReferenceImpl envRef;
        String name;
        block24: {
            if (this.status != 0 || m.isCanceled()) {
                throw new StatusException(Status.CANCEL_STATUS);
            }
            if (!(r instanceof RjsController) || !this.preCheck()) {
                return;
            }
            this.data = new RElementInfoData();
            RProcessREnvironment env = this.getEnv(r, m);
            if (env != null) {
                name = this.elementName.getDisplayName(2);
                envRef = new RReferenceImpl(env.getHandle(), 8, null);
            } else if (this.data.elementName != null && this.data.elementName.getScope() != null && this.data.elementName.getScope().getType() == 33) {
                name = this.elementName.getDisplayName(3);
                envRef = null;
            } else {
                return;
            }
            if (name == null) {
                return;
            }
            if (this.data.element == null || this.data.element.getRObjectType() == 17) {
                try {
                    this.data.element = ((RjsController)r).evalCombinedStruct(name, (RObject)envRef, 0, 1, this.elementName, m);
                    if (this.data.element == null) {
                        return;
                    }
                }
                catch (StatusException e) {
                    if (this.data.element == null) {
                        throw e;
                    }
                    String message = e.getMessage();
                    int idxBegin = message.indexOf(60);
                    int idxEnd = message.lastIndexOf(62);
                    if (idxBegin < 0 || idxEnd <= idxBegin + 1) break block24;
                    this.data.detailTitle = "error";
                    this.data.detailInfo = message.substring(idxBegin + 1, idxEnd);
                }
            }
        }
        if (envRef != null) {
            try {
                FunctionCall fcall = r.createFunctionCall("base::bindingIsActive");
                fcall.addChar("sym", this.elementName.getSegmentName());
                fcall.add("env", (RObject)envRef);
                RObject data = fcall.evalData(m);
                this.data.isActiveBinding = RDataUtils.checkSingleLogiValue((RObject)data);
            }
            catch (StatusException | UnexpectedRDataException fcall) {
                // empty catch block
            }
        }
        if (this.data.element.getRObjectType() != 18 && this.data.element.getRObjectType() != 17 && (robject = ((RjsController)r).evalData(cmd = "class(" + name + ")", (RObject)envRef, null, 0, -1, m)) != null) {
            this.data.elementAttr = new RList32Impl(new RObject[]{robject}, null, new String[]{"class"});
        }
        if (this.data.element.getRObjectType() != 17) {
            String title = "str";
            StringBuilder cmd2 = new StringBuilder("rj:::.statet.captureStr(");
            if (this.data.element.getRObjectType() == 18) {
                cmd2.append("substitute(");
                cmd2.append(name);
                cmd2.append(")");
            } else {
                cmd2.append(name);
            }
            cmd2.append(")");
            RObject robject2 = ((RjsController)r).evalData(cmd2.toString(), (RObject)envRef, null, 0, -1, m);
            try {
                RCharacterStore data = (RCharacterStore)RDataUtils.checkRCharVector((RObject)robject2).getData();
                StringBuilder sb = new StringBuilder((int)data.getLength() * 30);
                String ln = TextUtil.getPlatformLineDelimiter();
                int i = 0;
                while ((long)i < data.getLength()) {
                    if (!data.isNA(i)) {
                        sb.append(data.getChar(i));
                        sb.append(ln);
                    }
                    ++i;
                }
                if (sb.length() > 0) {
                    sb.setLength(sb.length() - ln.length());
                }
                this.data.detailTitle = "str";
                this.data.detailInfo = sb.toString();
            }
            catch (UnexpectedRDataException unexpectedRDataException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private RProcessREnvironment getEnv(IRDataAdapter r, ProgressMonitor m) throws StatusException {
        CombinedRElement altElement;
        RElementName envName = this.elementName.getScope();
        boolean inherits = false;
        if (envName == null) {
            int position = this.getFramePosition(r, m);
            envName = position > 0 ? RElementName.create((int)39, (String)Integer.toString(position)) : RElementName.create((int)37, (String)".GlobalEnv");
            inherits = true;
        }
        if (envName == null || !LoadReferenceRunnable.isAccessAllowed((RElementName)envName, (RWorkspace)r.getWorkspaceData())) {
            return null;
        }
        if (envName.getType() == 33) {
            this.data.elementName = this.elementName;
            return null;
        }
        if (envName.getType() == 34) {
            CombinedRElement element = r.getWorkspaceData().resolve(envName, 2, 0, m);
            CombinedRElement combinedRElement = element;
            if (combinedRElement instanceof RProcessREnvironment) {
                void env;
                RProcessREnvironment rProcessREnvironment = (RProcessREnvironment)combinedRElement;
                RProcessREnvironment cfr_ignored_0 = (RProcessREnvironment)combinedRElement;
                if (env.getNames() != null && env.getNames().contains(this.elementName.getSegmentName())) {
                    this.data.elementName = this.elementName;
                    if (this.elementName.getNextSegment() == null) {
                        this.data.element = env.get(this.elementName.getSegmentName());
                    }
                    return env;
                }
            }
            return null;
        }
        String name = envName.getDisplayName(1);
        if (name == null) {
            return null;
        }
        RElementName mainName = RElementName.cloneSegment((RElementName)this.elementName);
        int depth = this.elementName.getNextSegment() != null ? 0 : 1;
        FQRObject data = r.findData(mainName.getSegmentName(), (RObject)new RLanguageImpl(3, name, null), inherits, "combined", 1, depth, m);
        if (data == null) {
            return null;
        }
        RProcessREnvironment foundEnv = (RProcessREnvironment)data.getEnv();
        if (!(this.updateName(foundEnv.getElementName()) || (altElement = r.getWorkspaceData().resolve((RReference)new RReferenceImpl(foundEnv.getHandle(), 8, null), 0)) instanceof RProcessREnvironment && this.updateName(altElement.getElementName()))) {
            this.data.elementName = this.elementName;
        }
        if (depth == 1) {
            this.data.element = (CombinedRElement)data.getObject();
            return foundEnv;
        }
        RObject object = data.getObject();
        if (!(object instanceof RReference) || ((RReference)object).getReferencedRObjectType() == 18 || ((RReference)object).getReferencedRObjectType() == 17) {
            return null;
        }
        return foundEnv;
    }

    private boolean updateName(RElementName envName) {
        if (envName == null || envName.getSegmentName() == null || envName.getSegmentName().isEmpty()) {
            return false;
        }
        ArrayList<RElementName> segments = new ArrayList<RElementName>();
        segments.add(envName);
        RElementName.addSegments(segments, (RElementName)this.elementName);
        RElementName name = RElementName.create(segments);
        if (name.getScope() == null) {
            return false;
        }
        this.data.elementName = name;
        return true;
    }

    protected int getFramePosition(IRDataAdapter r, ProgressMonitor m) throws StatusException {
        return 0;
    }

    public static class RElementInfoData {
        private Control control;
        public IWorkbenchPart workbenchPart;
        private RTool tool;
        private CombinedRElement element;
        private RElementName elementName;
        private boolean isActiveBinding;
        private RList elementAttr;
        private String detailTitle;
        private String detailInfo;

        private RElementInfoData() {
        }

        public Control getControl() {
            return this.control;
        }

        public IWorkbenchPart getWorkbenchPart() {
            return this.workbenchPart;
        }

        public RTool getTool() {
            return this.tool;
        }

        public CombinedRElement getElement() {
            return this.element;
        }

        public RElementName getElementName() {
            return this.elementName;
        }

        public boolean isElementOfActiveBinding() {
            return this.isActiveBinding;
        }

        public RList getElementAttr() {
            return this.elementAttr;
        }

        public boolean hasDetail() {
            return this.detailTitle != null;
        }

        public String getDetailTitle() {
            return this.detailTitle;
        }

        public String getDetailInfo() {
            return this.detailInfo;
        }
    }
}

