/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors.rpkg;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.statet.dsl.ui.DslUI;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.text.core.util.TextUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.text.core.SearchPattern;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.SourceProposal;
import org.eclipse.statet.r.core.model.RPkgDescrFieldDefinition;
import org.eclipse.statet.r.ui.sourceediting.RPkgDescrAssistInvocationContext;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

@NonNullByDefault
public class RPkgDescrFieldNameCompletionProposal
extends SourceProposal<RPkgDescrAssistInvocationContext> {
    protected final RPkgDescrFieldDefinition fieldDef;

    public RPkgDescrFieldNameCompletionProposal(FieldNameElementProposalParameters parameters) {
        super((SourceProposal.ProposalParameters)parameters);
        this.fieldDef = (RPkgDescrFieldDefinition)ObjectUtils.nonNullAssert((Object)parameters.fieldDef);
    }

    protected String getName() {
        return this.fieldDef.getName();
    }

    protected int computeReplacementLength(int replacementOffset, Point selection, int caretOffset, boolean overwrite) throws BadPartitioningException, BadLocationException {
        int end = Math.max(caretOffset, selection.x + selection.y);
        if (overwrite) {
            RPkgDescrAssistInvocationContext context = (RPkgDescrAssistInvocationContext)this.getInvocationContext();
            IDocument document = context.getDocument();
            ITypedRegion partition = TextUtils.getPartition((IDocument)document, (DocContentSections)context.getEditor().getDocumentContentInfo(), (int)replacementOffset, (boolean)true);
            end = partition.getType() == "RPkgDescr.FieldName" ? partition.getOffset() + partition.getLength() : TextUtils.findCommonWord2End((IDocument)document, (int)replacementOffset, (int)document.getLength());
        }
        return end - replacementOffset;
    }

    public String getSortingString() {
        return this.fieldDef.getName();
    }

    public Image getImage() {
        return DslUI.getUIResources().getImage("org.eclipse.statet.dsl/image/obj/Scalar");
    }

    public boolean isAutoInsertable() {
        return true;
    }

    protected void doApply(char trigger, int stateMask, int caretOffset, int replacementOffset, int replacementLength) throws BadLocationException {
        char next;
        RPkgDescrAssistInvocationContext context = (RPkgDescrAssistInvocationContext)this.getInvocationContext();
        IDocument document = context.getDocument();
        SourceProposal.ApplyData applyData = this.getApplyData();
        StringBuilder replacement = new StringBuilder(this.fieldDef.getName());
        int cursor = replacement.length();
        int replacementEnd = replacementOffset + replacementLength;
        char c = next = replacementEnd < document.getLength() ? document.getChar(replacementEnd) : (char)'\u0000';
        if (next == ':') {
            cursor = replacementEnd + 1 < document.getLength() && document.getChar(replacementEnd + 1) == ' ' ? (cursor += 2) : ++cursor;
        } else {
            replacement.append(':');
            if (next != ' ') {
                replacement.append(' ');
            }
            cursor += 2;
        }
        document.replace(replacementOffset, replacementLength, replacement.toString());
        applyData.setSelection(replacementOffset + cursor);
    }

    public static class FieldNameElementProposalParameters
    extends SourceProposal.ProposalParameters<RPkgDescrAssistInvocationContext> {
        public RPkgDescrFieldDefinition fieldDef;

        public FieldNameElementProposalParameters(RPkgDescrAssistInvocationContext context, int replacementOffset, SearchPattern namePattern, int baseRelevance) {
            super((AssistInvocationContext)context, replacementOffset, namePattern, baseRelevance);
        }

        public FieldNameElementProposalParameters(RPkgDescrAssistInvocationContext context, int replacementOffset, SearchPattern namePattern) {
            super((AssistInvocationContext)context, replacementOffset, namePattern);
        }
    }
}

