/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors.r;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.SearchPattern;
import org.eclipse.statet.ltk.ui.LtkUI;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposalCollector;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistComputer;
import org.eclipse.statet.ltk.ui.sourceediting.assist.SimpleCompletionProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.SourceProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

@NonNullByDefault
public class RoxygenCompletionComputer
implements ContentAssistComputer {
    private static final List<String> TAG_COMMANDS;
    private int searchMatchRules;

    static {
        String[] tags = new String[]{"docType", "export", "exportClass", "exportMethod", "exportPattern", "import", "importFrom", "importClassesFrom", "importMethodsFrom", "name", "aliases", "title", "usage", "references", "note", "include", "slot", "param", "return", "returnType", "seealso", "example", "examples", "author", "concept", "keywords", "method", "prototype", "S3method", "S3class", "listObject", "attributeObject", "environmentObject", "noRd", "useDynLib", "rdname", "template", "section", "description", "details", "family", "inheritParams", "format", "source", "encoding", "describeIn", "field"};
        Object[] commands = new String[tags.length];
        int i = 0;
        while (i < commands.length) {
            commands[i] = String.valueOf('@') + tags[i];
            ++i;
        }
        TAG_COMMANDS = ImCollections.newList((Object[])commands);
    }

    public void onSessionStarted(SourceEditor editor, ContentAssist assist) {
        int matchRules = 4;
        if (assist.getShowSubstringMatches()) {
            matchRules |= 0x10;
        }
        this.searchMatchRules = matchRules;
    }

    public void onSessionEnded() {
    }

    protected int getSearchMatchRules() {
        return this.searchMatchRules;
    }

    public void computeCompletionProposals(AssistInvocationContext context, int mode, AssistProposalCollector proposals, IProgressMonitor monitor) {
        String tagPrefix = this.getTagPrefix(context);
        if (tagPrefix != null) {
            this.doComputeTagProposals(context, tagPrefix, proposals, monitor);
        }
    }

    public void computeInformationProposals(AssistInvocationContext context, AssistProposalCollector proposals, IProgressMonitor monitor) {
    }

    private @Nullable String getTagPrefix(AssistInvocationContext context) {
        try {
            int last;
            IDocument document = context.getSourceViewer().getDocument();
            int start = Math.max(context.getInvocationOffset() - 20, 0);
            String s = document.get(start, context.getInvocationOffset() - start);
            int i = last = s.length() - 1;
            while (i >= 0) {
                char c = s.charAt(i);
                if (c == '@') {
                    return s.substring(i, s.length());
                }
                if (!this.isRoxygenTagChar(c)) {
                    return i == last ? "" : null;
                }
                --i;
            }
            return null;
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    private boolean isRoxygenTagChar(int c) {
        if (c >= 65 && c <= 90 || c >= 97 && c <= 122) {
            return true;
        }
        int type = Character.getType(c);
        return type > 0 && (type < 12 || type > 19);
    }

    private void doComputeTagProposals(AssistInvocationContext context, String prefix, AssistProposalCollector proposals, IProgressMonitor monitor) {
        SourceProposal.ProposalParameters parameters = new SourceProposal.ProposalParameters(context, context.getInvocationOffset() - prefix.length(), new SearchPattern(this.getSearchMatchRules(), prefix));
        List<String> keywords = TAG_COMMANDS;
        for (String keyword : keywords) {
            if (!parameters.matchesNamePattern(keyword)) continue;
            proposals.add((AssistProposal)new TagProposal(parameters, keyword));
        }
    }

    private static class TagProposal
    extends SimpleCompletionProposal {
        public TagProposal(SourceProposal.ProposalParameters<?> parameters, String keyword) {
            super(parameters, keyword);
        }

        protected int computeReplacementLength(int replacementOffset, Point selection, int caretOffset, boolean overwrite) throws BadLocationException {
            int end = Math.max(caretOffset, selection.x + selection.y);
            if (overwrite) {
                IDocument document = this.getInvocationContext().getSourceViewer().getDocument();
                while (end < document.getLength()) {
                    if (!Character.isLetterOrDigit(document.getChar(end))) break;
                    ++end;
                }
            }
            return end - replacementOffset;
        }

        public Image getImage() {
            return LtkUI.getUIResources().getImage("org.eclipse.statet.ltk.ui/images/obj/text-at_tag");
        }

        public boolean isAutoInsertable() {
            return true;
        }

        protected void doApply(char trigger, int stateMask, int caretOffset, int replacementOffset, int replacementLength) throws BadLocationException {
            AssistInvocationContext context = this.getInvocationContext();
            IDocument document = context.getDocument();
            SourceProposal.ApplyData applyData = this.getApplyData();
            String replacement = this.getName();
            int cursor = replacement.length() + 1;
            if (replacementOffset + replacementLength == document.getLength() || document.getChar(replacementOffset + replacementLength) != ' ') {
                replacement = String.valueOf(replacement) + ' ';
            }
            document.replace(replacementOffset, replacementLength, replacement);
            applyData.setSelection(replacementOffset + cursor);
        }
    }
}

