/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.CommonmarkLocator;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Characters;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.HardLineBreak;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Inline;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.InlineParser;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.InlineWithText;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.InlinesSubstitution;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.PotentialStyleDelimiterInfo;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
class PotentialStyleDelimiter
extends InlineWithText {
    private final PotentialStyleDelimiterInfo info;
    private final boolean canOpen;
    private final boolean canClose;

    public PotentialStyleDelimiter(PotentialStyleDelimiterInfo info, Line line, int offset, int length, String text, boolean canOpen, boolean canClose) {
        super(line, offset, length, length, text);
        this.info = info;
        this.canOpen = canOpen;
        this.canClose = canClose;
    }

    @Override
    public void emit(ProcessingContext context, CommonmarkLocator locator, DocumentBuilder builder) {
        builder.characters(this.text);
    }

    @Override
    @Nullable InlinesSubstitution secondPass(List<Inline> inlines) {
        char c;
        if (!this.canClose) {
            return null;
        }
        int indexOfThis = inlines.indexOf(this);
        int openingDelimiterIndex = this.findLastOpeningDelimiter(inlines, indexOfThis, c = this.getText().charAt(0));
        if (openingDelimiterIndex >= 0) {
            PotentialStyleDelimiter openingDelimiter = (PotentialStyleDelimiter)inlines.get(openingDelimiterIndex);
            int delimiterSize = this.info.getSize(openingDelimiter.getLength(), this.getLength());
            if ((this.info.getRequirements(delimiterSize) & 0x10) != 0) {
                int index = openingDelimiterIndex + 1;
                while (index < indexOfThis) {
                    Inline inline = inlines.get(index);
                    if (inline instanceof Characters && ((Characters)inline).getText().indexOf(32) >= 0) {
                        return null;
                    }
                    if (inline instanceof HardLineBreak && ((HardLineBreak)inline).getType() == ' ') {
                        return null;
                    }
                    ++index;
                }
            }
            List<Inline> contents = InlineParser.secondPass(inlines.subList(openingDelimiterIndex + 1, indexOfThis));
            int startOffset = openingDelimiter.getStartOffset();
            int endOffset = this.getEndOffset();
            Inline styleInline = this.info.createStyleInline(delimiterSize, openingDelimiter.getLine(), startOffset, endOffset - startOffset, contents);
            ArrayList<Inline> substitutionInlines = new ArrayList<Inline>();
            if (delimiterSize < openingDelimiter.getLength()) {
                substitutionInlines.add(this.createRemainingOpeningDelimiter(openingDelimiter, delimiterSize));
            }
            substitutionInlines.add(styleInline);
            if (delimiterSize < this.getLength()) {
                substitutionInlines.add(this.createRemainingClosingDelimiter(delimiterSize));
            }
            return new InlinesSubstitution(openingDelimiter, this, substitutionInlines);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private int findLastOpeningDelimiter(List<Inline> inlines, int indexOfThis, char c) {
        int index = indexOfThis - 1;
        while (index >= 0) {
            Inline inline = inlines.get(index);
            Inline inline2 = inline;
            if (inline2 instanceof PotentialStyleDelimiter) {
                void previousDelimiter;
                PotentialStyleDelimiter cfr_ignored_0 = (PotentialStyleDelimiter)inline2;
                PotentialStyleDelimiter cfr_ignored_1 = (PotentialStyleDelimiter)inline2;
                if (previousDelimiter.info == this.info && previousDelimiter.canOpen && (!this.canOpen && !previousDelimiter.canClose || (previousDelimiter.getLength() + this.getLength()) % 3 != 0) || previousDelimiter.getLength() % 3 == 0 && this.getLength() % 3 == 0) {
                    return index;
                }
            }
            --index;
        }
        return -1;
    }

    private Inline createRemainingOpeningDelimiter(PotentialStyleDelimiter openingDelimiter, int delimiterSize) {
        int newLength = openingDelimiter.getLength() - delimiterSize;
        if (this.info.isPotentialSequence(newLength)) {
            return new PotentialStyleDelimiter(this.info, openingDelimiter.getLine(), openingDelimiter.getStartOffset(), newLength, openingDelimiter.getText().substring(0, newLength), openingDelimiter.canOpen, openingDelimiter.canClose);
        }
        return new Characters(openingDelimiter.getLine(), openingDelimiter.getStartOffset(), newLength, newLength, openingDelimiter.getText().substring(0, newLength));
    }

    private Inline createRemainingClosingDelimiter(int delimiterSize) {
        int newLength = this.getLength() - delimiterSize;
        if (this.info.isPotentialSequence(newLength)) {
            return new PotentialStyleDelimiter(this.info, this.getLine(), this.getStartOffset() + delimiterSize, newLength, this.getText().substring(0, newLength), this.canOpen, this.canClose);
        }
        return new Characters(this.getLine(), this.getStartOffset() + delimiterSize, newLength, newLength, this.getText().substring(0, newLength));
    }
}

