/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.ui.sourceediting;

import org.eclipse.jface.text.contentassist.IContextInformationExtension;
import org.eclipse.statet.docmlet.tex.core.commands.TexCommand;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIntList;
import org.eclipse.statet.jcommons.collections.IntArrayList;
import org.eclipse.statet.jcommons.collections.IntList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInformationProposal;
import org.eclipse.swt.graphics.Image;

@NonNullByDefault
public class LtxArgumentListContextInformation
implements AssistInformationProposal,
IContextInformationExtension {
    private final int offset;
    private final TexCommand command;
    private final String information;
    private final ImIntList informationParameterIndexes;

    public LtxArgumentListContextInformation(int offset, TexCommand command) {
        this.offset = offset;
        this.command = command;
        StringBuilder sb = new StringBuilder();
        IntArrayList idxs = new IntArrayList();
        LtxArgumentListContextInformation.appendArgumentList(sb, (IntList)idxs, this.command);
        this.information = sb.toString();
        this.informationParameterIndexes = ImCollections.toIntList((IntList)idxs);
    }

    public int getCallArgsOffset() {
        return this.offset;
    }

    public TexCommand getCommand() {
        return this.command;
    }

    public String getContextDisplayString() {
        return this.getInformationDisplayString();
    }

    public @Nullable Image getImage() {
        return null;
    }

    public int getContextInformationPosition() {
        return Math.max(this.offset, 0);
    }

    public String getInformationDisplayString() {
        return this.information;
    }

    public ImIntList getInformationDisplayStringParameterIndexes() {
        return this.informationParameterIndexes;
    }

    public boolean equals(@Nullable Object obj) {
        return true;
    }

    private static void appendArgumentList(StringBuilder text, IntList idxs, TexCommand command) {
        for (TexCommand.Parameter param : command.getParameters()) {
            idxs.add(text.length());
            if ((param.getType() & 2) != 0) {
                text.append('[');
                if (param.getLabel() != null) {
                    text.append(param.getLabel());
                }
                text.append(']');
                continue;
            }
            text.append('{');
            if (param.getLabel() != null) {
                text.append(param.getLabel());
            }
            text.append('}');
        }
    }
}

