/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.viewers.breadcrumb;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.statet.ecommons.ui.viewers.breadcrumb.BreadcrumbItemDetails;
import org.eclipse.statet.ecommons.ui.viewers.breadcrumb.BreadcrumbItemDropDown;
import org.eclipse.statet.ecommons.ui.viewers.breadcrumb.BreadcrumbViewer;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

@NonNullByDefault
class BreadcrumbItem
extends Item {
    private ITreeContentProvider contentProvider;
    private ILabelProvider labelProvider;
    private ILabelProvider toolTipLabelProvider;
    private final BreadcrumbViewer parent;
    private final Composite container;
    private final BreadcrumbItemDetails detailsBlock;
    private final BreadcrumbItemDropDown expandBlock;
    private boolean isLast;

    public BreadcrumbItem(BreadcrumbViewer viewer, Composite parent) {
        super((Widget)parent, 0);
        this.parent = viewer;
        this.container = new Composite(parent, 0);
        this.container.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginBottom = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        this.container.setLayout((Layout)layout);
        this.container.setData("org.eclipse.e4.ui.css.id", (Object)"BreadcrumbItemComposite");
        this.detailsBlock = new BreadcrumbItemDetails(this, this.container);
        this.expandBlock = new BreadcrumbItemDropDown(this, this.container);
    }

    public Object getElement() {
        return super.getData();
    }

    public BreadcrumbViewer getViewer() {
        return this.parent;
    }

    public void setContentProvider(ITreeContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public void setToolTipLabelProvider(ILabelProvider toolTipLabelProvider) {
        this.toolTipLabelProvider = toolTipLabelProvider;
    }

    public void dispose() {
        this.container.dispose();
        super.dispose();
    }

    void setShowText(boolean enabled) {
        this.detailsBlock.setTextVisible(enabled);
    }

    boolean isShowText() {
        return this.detailsBlock.isTextVisible();
    }

    int getWidth() {
        return this.detailsBlock.getWidth() + this.expandBlock.getWidth() + 2;
    }

    void setSelected(boolean selected) {
        this.detailsBlock.setSelected(selected);
    }

    void setFocus(boolean state) {
        this.detailsBlock.setFocus(state);
    }

    boolean hasFocus() {
        return this.detailsBlock.hasFocus();
    }

    void refresh() {
        String text = this.labelProvider.getText(this.getElement());
        Image image = this.labelProvider.getImage(this.getElement());
        String toolTip = this.toolTipLabelProvider.getText(this.getElement());
        this.detailsBlock.setText(text);
        this.detailsBlock.setImage(image);
        this.detailsBlock.setToolTip(toolTip);
        this.refreshArrow();
    }

    void refreshArrow() {
        this.expandBlock.setEnabled(this.contentProvider.hasChildren(this.getElement()));
    }

    void setIsLastItem(boolean isLast) {
        this.isLast = isLast;
        GridData data = (GridData)this.container.getLayoutData();
        data.grabExcessHorizontalSpace = isLast;
    }

    void setDetailsVisible(boolean visible) {
        this.detailsBlock.setVisible(visible);
    }

    void openDropDownMenu() {
        this.expandBlock.showMenu();
        Shell shell = this.expandBlock.getDropDownShell();
        if (shell != null) {
            shell.setFocus();
        }
    }

    boolean isMenuShown() {
        return this.expandBlock.isMenuShown();
    }

    @Nullable Shell getDropDownShell() {
        return this.expandBlock.getDropDownShell();
    }

    @Nullable ISelectionProvider getDropDownSelectionProvider() {
        return this.expandBlock.getDropDownSelectionProvider();
    }

    public Rectangle getBounds() {
        return this.container.getBounds();
    }

    public void setToolTip(String text) {
        this.detailsBlock.setToolTip(text);
    }

    public void setText(String string) {
        super.setText(string);
        this.detailsBlock.setText(string);
        if (this.isLast) {
            this.container.layout(true, true);
        }
    }

    public void setImage(@Nullable Image image) {
        super.setImage(image);
        this.detailsBlock.setImage(image);
    }
}

