/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.util;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ImageRegistryUtil {
    public static final String T_VIEW = "view_16";
    public static final String T_TOOL = "tool_16";
    public static final String T_TOOLD = "tool_16_d";
    public static final String T_OBJ = "obj_16";
    public static final String T_OVR = "ovr_16";
    public static final String T_WIZBAN = "wizban";
    public static final String T_LOCTOOL = "loctool_16";
    public static final String T_LOCTOOL_D = "loctool_16_d";
    private final AbstractUIPlugin plugin;
    private final URL iconBaseURL;

    public ImageRegistryUtil(AbstractUIPlugin plugin) {
        this.plugin = plugin;
        this.iconBaseURL = plugin.getBundle().getEntry("/icons/");
    }

    public void register(String key, String prefix, String name) {
        ImageDescriptor descriptor;
        try {
            URL url = this.createIconFileURL(String.valueOf(prefix) + '/' + name);
            descriptor = this.createDescriptor(url);
        }
        catch (RuntimeException | MalformedURLException e) {
            this.plugin.getLog().log((IStatus)new Status(4, this.plugin.getBundle().getSymbolicName(), 0, String.format("Error occured while loading an image descriptor (key= %1$s).", key), (Throwable)e));
            descriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        this.plugin.getImageRegistry().put(key, descriptor);
    }

    public void register(String key, String name) {
        ImageDescriptor descriptor;
        try {
            String type;
            int typeStartIdx = key.indexOf("/images/") + 8;
            int typeEndIdx = key.indexOf(47, typeStartIdx);
            String path = switch (type = key.substring(typeStartIdx, typeEndIdx)) {
                case "obj" -> "obj_16/";
                case "tool" -> "tool_16/";
                case "ovr" -> "ovr_16/";
                case "loctool" -> "loctool_16/";
                default -> throw new IllegalArgumentException(key);
            };
            path = name.charAt(0) == '.' ? String.valueOf(path) + key.substring(typeEndIdx + 1) + name : String.valueOf(path) + name;
            URL url = this.createIconFileURL(path);
            descriptor = this.createDescriptor(url);
        }
        catch (RuntimeException | MalformedURLException e) {
            this.plugin.getLog().log((IStatus)new Status(4, this.plugin.getBundle().getSymbolicName(), 0, String.format("Error occured while loading an image descriptor (key= %1$s).", key), (Throwable)e));
            descriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        this.plugin.getImageRegistry().put(key, descriptor);
    }

    protected URL createIconFileURL(String path) throws MalformedURLException {
        if (this.iconBaseURL == null) {
            throw new MalformedURLException();
        }
        return new URL(this.iconBaseURL, path);
    }

    protected ImageDescriptor createDescriptor(URL url) {
        return ImageDescriptor.createFromURL((URL)url);
    }
}

