/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.model.core.impl;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.statet.ecommons.text.IMarkerPositionResolver;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.core.ElementName;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.core.WorkingContext;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.model.core.element.SourceDocumentRunnable;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.ltk.model.core.element.WorkspaceSourceUnit;
import org.eclipse.statet.ltk.model.core.impl.AbstractFilePersistenceSourceUnitFactory;
import org.eclipse.statet.ltk.model.core.impl.BasicWorkingBuffer;
import org.eclipse.statet.ltk.model.core.impl.WorkingBuffer;

@NonNullByDefault
public abstract class GenericResourceSourceUnit
implements WorkspaceSourceUnit {
    private final String id;
    private final ElementName name;
    private final IFile file;
    private WorkingBuffer buffer;
    private int counter = 0;

    public static String createResourceId(IResource file) {
        return AbstractFilePersistenceSourceUnitFactory.createResourceId(file);
    }

    protected static ElementName createResourceName(final IFile file) {
        return new ElementName(){

            @Override
            public int getType() {
                return 17;
            }

            @Override
            public String getDisplayName() {
                return file.getName();
            }

            @Override
            public String getSegmentName() {
                return file.getName();
            }

            @Override
            public @Nullable ElementName getNextSegment() {
                return null;
            }
        };
    }

    public GenericResourceSourceUnit(String id, ElementName name, IFile file) {
        this.id = id;
        this.name = name;
        this.file = (IFile)ObjectUtils.nonNullAssert((Object)file);
    }

    public GenericResourceSourceUnit(String id, IFile file) {
        this(id, GenericResourceSourceUnit.createResourceName(file), file);
    }

    @Override
    public @Nullable SourceUnit getUnderlyingUnit() {
        return null;
    }

    @Override
    public boolean isSynchronized() {
        return true;
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public WorkingContext getWorkingContext() {
        return Ltk.PERSISTENCE_CONTEXT;
    }

    @Override
    public int getElementType() {
        return 528;
    }

    @Override
    public final ElementName getElementName() {
        return this.name;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public final IResource getResource() {
        return this.file;
    }

    @Override
    public @Nullable IMarkerPositionResolver getMarkerPositionResolver() {
        return null;
    }

    @Override
    public boolean checkState(boolean validate, IProgressMonitor monitor) {
        return this.buffer.checkState(validate, monitor);
    }

    @Override
    public AbstractDocument getDocument(@Nullable IProgressMonitor monitor) {
        return this.buffer.getDocument(monitor);
    }

    @Override
    public long getContentStamp(@Nullable IProgressMonitor monitor) {
        return this.buffer.getContentStamp(monitor);
    }

    @Override
    public SourceContent getContent(IProgressMonitor monitor) {
        return this.buffer.getContent(monitor);
    }

    @Override
    public void syncExec(SourceDocumentRunnable runnable) throws InvocationTargetException {
        throw new UnsupportedOperationException();
    }

    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        if (adapterType.equals(IResource.class)) {
            return (T)this.getResource();
        }
        return null;
    }

    @Override
    public @Nullable AstInfo getAstInfo(@Nullable String type, boolean ensureSync, IProgressMonitor monitor) {
        return null;
    }

    @Override
    public @Nullable SourceUnitModelInfo getModelInfo(@Nullable String type, int syncLevel, IProgressMonitor monitor) {
        return null;
    }

    @Override
    public final synchronized void connect(IProgressMonitor monitor) {
        ++this.counter;
        if (this.counter == 1) {
            if (this.buffer == null) {
                this.buffer = new BasicWorkingBuffer(this);
            }
            this.register();
        }
    }

    @Override
    public final synchronized void disconnect(IProgressMonitor monitor) {
        --this.counter;
        if (this.counter == 0) {
            SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            this.buffer.releaseDocument((IProgressMonitor)m.newChild(1));
            this.unregister();
        }
    }

    @Override
    public synchronized boolean isConnected() {
        return this.counter > 0;
    }

    protected void register() {
    }

    protected void unregister() {
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object obj) {
        block2: {
            block3: {
                void other;
                if (this == obj) break block2;
                Object object = obj;
                if (!(object instanceof SourceUnit)) break block3;
                SourceUnit sourceUnit = (SourceUnit)object;
                SourceUnit cfr_ignored_0 = (SourceUnit)object;
                if (this.getElementType() == other.getElementType() && this.getWorkingContext() == other.getWorkingContext() && this.getId().equals(other.getId()) && this.getModelTypeId().equals(other.getModelTypeId())) break block2;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        return String.valueOf(this.getModelTypeId()) + '/' + this.getWorkingContext() + ": " + this.getId();
    }
}

