/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.data.RArray;
import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.statet.rj.data.RComplexStore;
import org.eclipse.statet.rj.data.RDataFrame;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RFactorStore;
import org.eclipse.statet.rj.data.RIntegerStore;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RLanguage;
import org.eclipse.statet.rj.data.RList;
import org.eclipse.statet.rj.data.RLogicalStore;
import org.eclipse.statet.rj.data.RNumericStore;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RRawStore;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.RVector;

@NonNullByDefault
public interface RObjectFactory {
    public static final int F_ONLY_STRUCT = 1;
    public static final int F_WITH_ATTR = 2;
    public static final int F_WITH_DBG = 4;
    public static final int F_LOAD_ENVIRONMENT = 16;
    public static final int F_LOAD_PROMISE = 32;
    public static final int O_LENGTHGRADE_MASK = 7;
    public static final int O_WITH_ATTR = 8;
    public static final int O_CLASS_NAME = 16;
    public static final int O_NO_CHILDREN = 32;
    public static final int O_WITH_NAMES = 64;

    public <TData extends RStore<?>> RVector<TData> createVector(TData var1, String var2);

    default public <TData extends RStore<?>> RVector<TData> createVector(TData data) {
        return this.createVector(data, data.getBaseVectorRClassName());
    }

    public <TData extends RStore<?>> RArray<TData> createArray(TData var1, int[] var2, String var3);

    default public <TData extends RStore<?>> RArray<TData> createArray(TData data, int[] dim) {
        return this.createArray(data, dim, dim.length == 2 ? "matrix" : "array");
    }

    default public <TData extends RStore<?>> RArray<TData> createMatrix(TData data, int rowCount, int colCount) {
        return this.createArray(data, new int[]{rowCount, colCount}, "matrix");
    }

    public RList createList(RObject[] var1, @Nullable String @Nullable [] var2, String var3);

    default public RList createList(RObject[] components, @Nullable String @Nullable [] names) {
        return this.createList(components, names, "list");
    }

    public RDataFrame createDataFrame(@NonNull RStore<?>[] var1, @NonNull String[] var2, @NonNull String @Nullable [] var3, String var4);

    default public RDataFrame createDataFrame(@NonNull RStore<?>[] colDatas, @NonNull String[] colNames, @NonNull String @Nullable [] rowNames) {
        return this.createDataFrame(colDatas, colNames, rowNames, "data.frame");
    }

    default public RDataFrame createDataFrame(@NonNull RStore<?>[] colDatas, @NonNull String[] colNames) {
        return this.createDataFrame(colDatas, colNames, null, "data.frame");
    }

    public RLanguage createName(String var1);

    public RLanguage createExpression(String var1);

    public RLogicalStore createLogiData(boolean[] var1);

    public RLogicalStore createLogiData(long var1);

    public RIntegerStore createIntData(int[] var1);

    public RIntegerStore createIntData(long var1);

    public RNumericStore createNumData(double[] var1);

    public RNumericStore createNumData(long var1);

    public RComplexStore createCplxData(double[] var1, double[] var2);

    public RComplexStore createCplxData(long var1);

    public RCharacterStore createCharData(@Nullable String[] var1);

    default public RCharacterStore createCharData(List<? extends @Nullable String> charValues) {
        return this.createCharData(charValues.toArray(new String[charValues.size()]));
    }

    default public RCharacterStore createCharDataUtf8(byte[] @Nullable [] charValues) {
        int length = charValues.length;
        @Nullable String[] charValuesJava = new String[length];
        int i = 0;
        while (i < length) {
            byte[] charValue = charValues[i];
            if (charValue != null) {
                charValuesJava[i] = new String(charValue, StandardCharsets.UTF_8);
            }
            ++i;
        }
        return this.createCharData(charValuesJava);
    }

    public RCharacterStore createCharData(long var1);

    public RRawStore createRawData(byte[] var1);

    public RRawStore createRawData(long var1);

    public RFactorStore createUnorderedFactorData(int[] var1, @Nullable String[] var2);

    @Deprecated(since="4.8")
    default public RFactorStore createFactorData(int[] codes, @Nullable String[] levels) {
        return this.createUnorderedFactorData(codes, levels);
    }

    public RFactorStore createUnorderedFactorData(long var1, @Nullable String[] var3);

    public RFactorStore createOrderedFactorData(int[] var1, @Nullable String[] var2);

    public RFactorStore createOrderedFactorData(long var1, @Nullable String[] var3);

    default public RVector<RLogicalStore> createLogiVector(boolean[] logiValues) {
        return this.createVector(this.createLogiData(logiValues), "logical");
    }

    default public RVector<RLogicalStore> createLogiVector(long length) {
        return this.createVector(this.createLogiData(length), "logical");
    }

    default public RArray<RLogicalStore> createLogiArray(boolean[] logiValues, int[] dim) {
        return this.createArray(this.createLogiData(logiValues), dim);
    }

    default public RArray<RLogicalStore> createLogiArray(int[] dim) {
        return this.createArray(this.createLogiData(RDataUtils.computeLengthFromDim(dim)), dim);
    }

    default public RArray<RLogicalStore> createLogiMatrix(boolean[] logiValues, int rowCount, int colCount) {
        return this.createMatrix(this.createLogiData(logiValues), rowCount, colCount);
    }

    default public RArray<RLogicalStore> createLogiMatrix(int rowCount, int colCount) {
        return this.createMatrix(this.createLogiData(rowCount * colCount), rowCount, colCount);
    }

    default public RVector<RIntegerStore> createIntVector(int[] intValues) {
        return this.createVector(this.createIntData(intValues), "integer");
    }

    default public RVector<RIntegerStore> createIntVector(long length) {
        return this.createVector(this.createIntData(length), "integer");
    }

    default public RArray<RIntegerStore> createIntArray(int[] intValues, int[] dim) {
        return this.createArray(this.createIntData(intValues), dim);
    }

    default public RArray<RIntegerStore> createIntArray(int[] dim) {
        return this.createArray(this.createIntData(RDataUtils.computeLengthFromDim(dim)), dim);
    }

    default public RArray<RIntegerStore> createIntMatrix(int[] intValues, int rowCount, int colCount) {
        return this.createMatrix(this.createIntData(intValues), rowCount, colCount);
    }

    default public RArray<RIntegerStore> createIntMatrix(int rowCount, int colCount) {
        return this.createMatrix(this.createIntData(rowCount * colCount), rowCount, colCount);
    }

    default public RVector<RNumericStore> createNumVector(double[] numValues) {
        return this.createVector(this.createNumData(numValues), "numeric");
    }

    default public RVector<RNumericStore> createNumVector(long length) {
        return this.createVector(this.createNumData(length), "numeric");
    }

    default public RArray<RNumericStore> createNumArray(double[] numValues, int[] dim) {
        return this.createArray(this.createNumData(numValues), dim);
    }

    default public RArray<RNumericStore> createNumArray(int[] dim) {
        return this.createArray(this.createNumData(RDataUtils.computeLengthFromDim(dim)), dim);
    }

    default public RArray<RNumericStore> createNumMatrix(double[] numValues, int rowCount, int colCount) {
        return this.createMatrix(this.createNumData(numValues), rowCount, colCount);
    }

    default public RArray<RNumericStore> createNumMatrix(int rowCount, int colCount) {
        return this.createMatrix(this.createNumData(rowCount * colCount), rowCount, colCount);
    }

    default public RVector<RComplexStore> createCplxVector(long length) {
        return this.createVector(this.createCplxData(length), "complex");
    }

    default public RVector<RCharacterStore> createCharVector(@Nullable String[] charValues) {
        return this.createVector(this.createCharData(charValues), "character");
    }

    default public RVector<RCharacterStore> createCharVector(List<? extends @Nullable String> charValues) {
        return this.createVector(this.createCharData(charValues), "character");
    }

    default public RVector<RCharacterStore> createCharVector(long length) {
        return this.createVector(this.createCharData(length), "character");
    }

    default public RArray<RCharacterStore> createCharArray(@Nullable String[] charValues, int[] dim) {
        return this.createArray(this.createCharData(charValues), dim);
    }

    default public RArray<RCharacterStore> createCharArray(List<? extends @Nullable String> charValues, int[] dim) {
        return this.createArray(this.createCharData(charValues), dim);
    }

    default public RArray<RCharacterStore> createCharArray(int[] dim) {
        return this.createArray(this.createCharData(RDataUtils.computeLengthFromDim(dim)), dim);
    }

    default public RArray<RCharacterStore> createCharMatrix(@Nullable String[] charValues, int rowCount, int colCount) {
        return this.createMatrix(this.createCharData(charValues), rowCount, colCount);
    }

    default public RArray<RCharacterStore> createCharMatrix(List<? extends @Nullable String> charValues, int rowCount, int colCount) {
        return this.createMatrix(this.createCharData(charValues), rowCount, colCount);
    }

    default public RArray<RCharacterStore> createCharMatrix(int rowCount, int colCount) {
        return this.createMatrix(this.createCharData(rowCount * colCount), rowCount, colCount);
    }

    default public RVector<RRawStore> createRawVector(byte[] rawValues) {
        return this.createVector(this.createRawData(rawValues), "raw");
    }

    default public RVector<RRawStore> createRawVector(long length) {
        return this.createVector(this.createRawData(length), "raw");
    }

    default public RArray<RRawStore> createRawArray(byte[] rawValues, int[] dim) {
        return this.createArray(this.createRawData(rawValues), dim);
    }

    default public RArray<RRawStore> createRawArray(int[] dim) {
        return this.createArray(this.createRawData(RDataUtils.computeLengthFromDim(dim)), dim);
    }

    default public RArray<RRawStore> createRawMatrix(byte[] rawValues, int rowCount, int colCount) {
        return this.createMatrix(this.createRawData(rawValues), rowCount, colCount);
    }

    default public RArray<RRawStore> createRawMatrix(int rowCount, int colCount) {
        return this.createMatrix(this.createRawData(rowCount * colCount), rowCount, colCount);
    }

    default public RVector<RFactorStore> createUnorderedFactorVector(int[] codes, @Nullable String[] levels) {
        return this.createVector(this.createUnorderedFactorData(codes, levels), "factor");
    }

    default public RVector<RFactorStore> createUnorderedFactorVector(long length, @Nullable String[] levels) {
        return this.createVector(this.createUnorderedFactorData(length, levels), "factor");
    }

    default public RVector<RFactorStore> createOrderedFactorVector(int[] codes, @Nullable String[] levels) {
        return this.createVector(this.createOrderedFactorData(codes, levels), "ordered");
    }

    default public RVector<RFactorStore> createOrderedFactorVector(long length, @Nullable String[] levels) {
        return this.createVector(this.createOrderedFactorData(length, levels), "ordered");
    }

    public void writeObject(RObject var1, RJIO var2) throws IOException;

    public RObject readObject(RJIO var1) throws IOException;

    public void writeStore(RStore<?> var1, RJIO var2) throws IOException;

    public RStore<?> readStore(RJIO var1, long var2) throws IOException;

    public void writeAttributeList(RList var1, RJIO var2) throws IOException;

    public RList readAttributeList(RJIO var1) throws IOException;

    public void writeNames(@Nullable RStore<?> var1, RJIO var2) throws IOException;

    public @Nullable RStore<?> readNames(RJIO var1, long var2) throws IOException;
}

