/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.yaml.core.source.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.yaml.core.source.ast.NodeType;
import org.eclipse.statet.yaml.core.source.ast.Scalar;
import org.eclipse.statet.yaml.core.source.ast.YamlAstNode;
import org.eclipse.statet.yaml.core.source.ast.YamlAstVisitor;
import org.eclipse.statet.yaml.core.source.ast.YamlAsts;

@NonNullByDefault
public class MapEntry
extends YamlAstNode {
    int keyIndicatorOffset = Integer.MIN_VALUE;
    YamlAstNode keyChild;
    int valueIndicatorOffset = Integer.MIN_VALUE;
    YamlAstNode valueChild;

    MapEntry(YamlAstNode parent, int startOffset, int endOffset) {
        super(parent, startOffset, endOffset);
    }

    MapEntry(YamlAstNode parent, int startOffset) {
        super(parent, startOffset, startOffset);
    }

    @Override
    void finish(int endOffset) {
        if (this.keyChild == null) {
            this.keyChild = new Scalar.Plain(this, this.keyIndicatorOffset != Integer.MIN_VALUE ? this.keyIndicatorOffset : this.startOffset);
        }
        if (this.valueChild == null) {
            this.valueChild = new Scalar.Plain(this, this.valueIndicatorOffset != Integer.MIN_VALUE ? this.valueIndicatorOffset : this.keyChild.endOffset);
        }
        super.finish(endOffset);
        int min = this.valueChild.endOffset;
        if (this.endOffset < min) {
            this.endOffset = min;
        }
    }

    @Override
    protected boolean hasErrorInChild() {
        return YamlAsts.hasErrors((AstNode)this.keyChild) || YamlAsts.hasErrors((AstNode)this.valueChild);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.MAP_ENTRY;
    }

    public int getKeyIndicatorOffset() {
        return this.keyIndicatorOffset;
    }

    public int getValueIndicatorOffset() {
        return this.valueIndicatorOffset;
    }

    public boolean hasChildren() {
        return true;
    }

    public int getChildCount() {
        return 2;
    }

    public YamlAstNode getKey() {
        return this.keyChild;
    }

    public YamlAstNode getValue() {
        return this.valueChild;
    }

    @Override
    public YamlAstNode getChild(int index) {
        return switch (index) {
            case 0 -> this.keyChild;
            case 1 -> this.valueChild;
            default -> throw new IndexOutOfBoundsException(Integer.toString(index));
        };
    }

    public int getChildIndex(AstNode child) {
        if (child == this.keyChild) {
            return 0;
        }
        if (child == this.valueChild) {
            return 1;
        }
        return -1;
    }

    public void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
        visitor.visit((AstNode)this.keyChild);
        visitor.visit((AstNode)this.valueChild);
    }

    @Override
    public void acceptInYaml(YamlAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    @Override
    public void acceptInYamlChildren(YamlAstVisitor visitor) throws InvocationTargetException {
        this.keyChild.acceptInYaml(visitor);
        this.valueChild.acceptInYaml(visitor);
    }
}

