/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.rmodel;

import com.ibm.icu.text.Collator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.input.StringParserInput;
import org.eclipse.statet.jcommons.text.core.input.TextParserInput;
import org.eclipse.statet.ltk.core.ElementName;
import org.eclipse.statet.ltk.core.util.NameUtils;
import org.eclipse.statet.r.core.RSymbolComparator;
import org.eclipse.statet.r.core.data.RValueFormatter;
import org.eclipse.statet.r.core.source.RLexer;
import org.eclipse.statet.r.core.source.RTerminal;

@NonNullByDefault
public abstract class RElementName
implements ElementName {
    public static final int RESOURCE = 2;
    public static final int MAIN_OTHER = 16;
    public static final int MAIN_DEFAULT = 17;
    public static final int MAIN_CLASS = 21;
    public static final int SUB_NAMEDSLOT = 25;
    public static final int SUB_NAMEDPART = 26;
    public static final int SUB_INDEXED_S = 27;
    public static final int SUB_INDEXED_D = 28;
    public static final int SCOPE_NS = 33;
    public static final int SCOPE_NS_INT = 34;
    public static final int SCOPE_SEARCH_ENV = 37;
    public static final int SCOPE_PACKAGE = 38;
    public static final int SCOPE_SYSFRAME = 39;
    public static final int SCOPE_PROJECT = 41;
    public static final int ANONYMOUS = 48;
    public static final int DISPLAY_FQN = 1;
    public static final int DISPLAY_EXACT = 2;
    private static final Collator NAME_COLLATOR = RSymbolComparator.R_NAMES_COLLATOR;
    public static final Comparator<ElementName> NAMEONLY_COMPARATOR = new Comparator<ElementName>(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compare(ElementName o1, ElementName o2) {
            int diff;
            String n1 = o1.getSegmentName();
            String n2 = o2.getSegmentName();
            if (n1 != null) {
                if (n2 == null) return Integer.MIN_VALUE;
                diff = NAME_COLLATOR.compare(n1, n2);
                if (diff != 0) {
                    return diff;
                }
            } else if (n2 != null) {
                return Integer.MAX_VALUE;
            }
            o1 = o1.getNextSegment();
            o2 = o2.getNextSegment();
            if (o1 != null) {
                if (o2 == null) return -2147483548;
                diff = o1.getType() - o2.getType();
                if (diff == 0) return this.compare(o1, o2);
                return diff;
            }
            if (n2 == null) return 0;
            return 2147483547;
        }
    };
    private static final int PARSE_OP = -1;
    private static final int PARSE_EXIT = -3;

    public static boolean isMainType(int type) {
        return type >= 16 && type < 25;
    }

    public static boolean isRegularMainType(int type) {
        return type > 16 && type < 25;
    }

    public static boolean isScopeType(int type) {
        return (type & 0xF0) == 32;
    }

    public static boolean isNamespaceScopeType(int type) {
        return type >= 33 && type < 37;
    }

    public static boolean isSearchScopeType(int type) {
        return type >= 37 && type < 48;
    }

    public static boolean isPackageFacetScopeType(int type) {
        switch (type) {
            case 33: 
            case 34: 
            case 38: {
                return true;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Deprecated
    public static @Nullable String createDisplayName(RElementName elementName, int options) {
        if (elementName == null) {
            throw new NullPointerException("elementName");
        }
        sb = null;
        if ((options & 1) != 0) {
            scopeName = elementName.getScope();
            if (scopeName == null && RElementName.isScopeType(elementName.getType())) {
                scopeName = elementName;
                elementName = elementName.getNextSegment();
            }
            if (scopeName != null) {
                if (elementName != null && elementName.getType() != 17) {
                    return null;
                }
                sb = new RValueFormatter();
                if (!RElementName.printScopeFQ(scopeName, sb, options, elementName != null)) {
                    return null;
                }
                if (elementName != null) {
                    name = elementName.getSegmentName();
                    if (name != null) {
                        RElementName.appendSymbol(sb, name);
                    }
                    elementName = elementName.getNextSegment();
                }
            }
        }
        if (sb != null) ** GOTO lbl130
        type = elementName.getType();
        switch (type) {
            case 17: 
            case 21: 
            case 25: 
            case 26: {
                firstName = elementName.getSegmentName();
                if (firstName != null) {
                    sb = RElementName.appendSymbol(sb, firstName);
                } else if ((options & 2) == 0) {
                    firstName = "";
                } else {
                    return null;
                }
                elementName = elementName.getNextSegment();
                if (elementName == null) {
                    return sb != null ? sb.getString() : firstName;
                }
                if (sb == null) {
                    sb = new RValueFormatter();
                    sb.append(firstName);
                }
                ** GOTO lbl130
            }
            case 33: {
                if (elementName.getNextSegment() == null) {
                    return RElementName.printScopeUI("namespace:", elementName.getSegmentName(), options);
                }
                RElementName.printScopeFQ(elementName, sb, options, true);
                ** GOTO lbl130
            }
            case 34: {
                if (elementName.getNextSegment() == null) {
                    return RElementName.printScopeUI("namespace-env:", elementName.getSegmentName(), options);
                }
                RElementName.printScopeFQ(elementName, sb, options, true);
                ** GOTO lbl130
            }
            case 37: {
                if (elementName.getNextSegment() == null && (firstName = elementName.getSegmentName()) != null) {
                    return firstName;
                }
                return null;
            }
            case 39: {
                if (elementName.getNextSegment() == null) {
                    return RElementName.printScopeUI("frame:", elementName.getSegmentName(), options);
                }
                return null;
            }
            case 38: {
                if (elementName.getNextSegment() == null) {
                    return RElementName.printScopeUI("package:", elementName.getSegmentName(), options);
                }
                return null;
            }
            case 41: {
                if (elementName.getNextSegment() == null) {
                    return RElementName.printScopeUI("project:", elementName.getSegmentName(), options);
                }
                return null;
            }
            case 28: {
                if (!(elementName instanceof DefaultImpl)) ** GOTO lbl76
                sb = new RValueFormatter();
                sb.append("[[");
                sb.append(elementName.getSegmentName());
                sb.append("]]");
                elementName = elementName.getNextSegment();
                if (true) ** GOTO lbl130
lbl76:
                // 1 sources

                return null;
            }
            case 2: 
            case 16: {
                return elementName.getSegmentName();
            }
            case 48: {
                if ((options & 2) == 0) {
                    return "<anonymous>";
                }
                return null;
            }
            default: {
                return null;
            }
        }
        block18: do {
            switch (elementName.getType()) {
                case 17: 
                case 21: 
                case 26: {
                    if ((options & 2) != 0 && elementName instanceof IndexElementName) {
                        sb.append("[[");
                        sb.appendInt(((IndexElementName)elementName).getIndex());
                        sb.append("L]]");
                    } else {
                        sb.append('$');
                        name = elementName.getSegmentName();
                        if (name != null) {
                            RElementName.appendSymbol(sb, name);
                        }
                    }
                    elementName = elementName.getNextSegment();
                    break;
                }
                case 25: {
                    sb.append('@');
                    name = elementName.getSegmentName();
                    if (name != null) {
                        RElementName.appendSymbol(sb, name);
                    }
                    elementName = elementName.getNextSegment();
                    break;
                }
                case 27: {
                    if ((options & 2) == 0) {
                        sb.append("[\u2026]");
                        break block18;
                    }
                    return null;
                }
                case 28: {
                    if (elementName instanceof DefaultImpl) {
                        sb.append("[[");
                        sb.append(elementName.getSegmentName());
                        sb.append("]]");
                        elementName = elementName.getNextSegment();
                        break;
                    }
                    if ((options & 2) == 0) {
                        sb.append("[[\u2026]]");
                        elementName = elementName.getNextSegment();
                        break;
                    }
                    return null;
                }
                default: {
                    if ((options & 2) == 0) {
                        sb.append(" \u2026");
                        break block18;
                    }
                    return null;
                }
            }
lbl130:
            // 9 sources

        } while (elementName != null);
        return sb.getString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean isValidSymbol(String name) {
        int check;
        int l = name.length();
        if (l == 0) {
            return false;
        }
        char c0 = name.charAt(0);
        if (Character.isLetter(c0)) {
            check = 1;
        } else {
            if (c0 != '.') {
                return false;
            }
            if (l == 1) {
                check = 1;
            } else {
                char c1 = name.charAt(1);
                if (c1 != '.' && c1 != '_' && !Character.isLetter(c1)) {
                    return false;
                }
                check = 2;
            }
        }
        while (check < l) {
            char cn = name.charAt(check);
            if (!(cn >= 'a' && cn <= 'z' || cn == '.' || cn == '_' || Character.isLetterOrDigit(cn))) {
                return false;
            }
            ++check;
        }
        return true;
    }

    private static @Nullable RValueFormatter appendSymbol(@Nullable RValueFormatter sb, String name) {
        if (RElementName.isValidSymbol(name)) {
            if (sb != null) {
                sb.append(name);
            }
            return sb;
        }
        if (sb == null) {
            sb = new RValueFormatter();
        }
        if (name.isEmpty()) {
            sb.append("``");
        } else {
            sb.appendName(name, true);
        }
        return sb;
    }

    private static @Nullable String printScopeUI(String itemPrefix, @Nullable String segmentName, int options) {
        if (segmentName == null) {
            if ((options & 2) == 0) {
                segmentName = "<unknown>";
            } else {
                return null;
            }
        }
        StringBuilder sb = new StringBuilder(itemPrefix.length() + segmentName.length());
        sb.append(itemPrefix);
        sb.append(segmentName);
        return sb.toString();
    }

    private static boolean printScopeFQ(RElementName a, RValueFormatter sb, int options, boolean operator) {
        switch (a.getType()) {
            case 33: {
                String scopeName = a.getSegmentName();
                if (scopeName == null) {
                    return false;
                }
                if (!operator) {
                    return false;
                }
                RElementName.appendSymbol(sb, scopeName);
                sb.append("::");
                return true;
            }
            case 34: {
                String scopeName = a.getSegmentName();
                if (scopeName == null) {
                    return false;
                }
                if (operator) {
                    RElementName.appendSymbol(sb, scopeName);
                    sb.append(":::");
                } else {
                    sb.append("getNamespace(\"");
                    sb.append(scopeName);
                    sb.append("\")");
                }
                return true;
            }
            case 37: {
                String scopeName = a.getSegmentName();
                if (scopeName == null) {
                    return false;
                }
                sb.append("as.environment(\"");
                sb.append(scopeName);
                sb.append("\")");
                if (operator) {
                    sb.append('$');
                }
                return true;
            }
            case 38: {
                String scopeName = a.getSegmentName();
                if (scopeName == null) {
                    return false;
                }
                sb.append("as.environment(\"package:");
                sb.append(scopeName);
                sb.append("\")");
                if (operator) {
                    sb.append('$');
                }
                return true;
            }
            case 39: {
                String scopeName = a.getSegmentName();
                if (scopeName == null) {
                    return false;
                }
                sb.append("sys.frame(");
                sb.append(scopeName);
                sb.append((options & 2) != 0 ? "L)" : ")");
                if (operator) {
                    sb.append('$');
                }
                return true;
            }
            case 41: {
                sb = new RValueFormatter();
                sb.append(".GlobalEnv");
                if (operator) {
                    sb.append('$');
                }
                return true;
            }
        }
        return false;
    }

    private static DefaultImpl checkSegment(RElementName name, @Nullable RElementName next) {
        return name.isDefaultImpl() && name.getNextSegment() == next ? (DefaultImpl)name : name.cloneSegment0(next);
    }

    public static RElementName create(int type, @Nullable String segmentName) {
        return new DefaultImpl(type, segmentName);
    }

    public static RElementName create(int type, @Nullable String segmentName, int idx) {
        if (type != 26 && type != 28) {
            throw new IllegalArgumentException();
        }
        return new DualImpl(type, segmentName, idx);
    }

    public static @Nullable RElementName create(List<RElementName> segments) {
        if (segments.isEmpty()) {
            return null;
        }
        if (segments.size() == 1) {
            return RElementName.checkSegment(segments.get(0), null);
        }
        int first = 0;
        RElementName scopeName = segments.get(0);
        if (RElementName.isScopeType(scopeName.getType())) {
            scopeName = RElementName.checkSegment(scopeName, null);
            first = 1;
        } else {
            scopeName = null;
        }
        DefaultImpl next = null;
        int i = segments.size() - 1;
        while (i > first) {
            next = RElementName.checkSegment(segments.get(i), next);
            --i;
        }
        next = new DefaultImpl(segments.get(first).getType(), scopeName, segments.get(first).getSegmentName(), next);
        return next;
    }

    public static @Nullable RElementName create(@Nullable RElementName name, @Nullable RElementName end, boolean withScope) {
        if (name == null) {
            return null;
        }
        ArrayList<RElementName> segments = new ArrayList<RElementName>();
        if (withScope && name.getScope() != null) {
            segments.add(name.getScope());
        }
        RElementName.addSegments(segments, name, end);
        return RElementName.create(segments);
    }

    public static @Nullable RElementName parseDefault(String code) {
        RLexer lexer = new RLexer(32775);
        lexer.reset((TextParserInput)new StringParserInput(code).init());
        int mode = 17;
        DefaultImpl main = null;
        DefaultImpl last = null;
        block12: while (mode != -3) {
            DefaultImpl tmp = null;
            RTerminal type = lexer.next();
            if (type == null || type == RTerminal.EOF) {
                if (mode < 0) {
                    return main;
                }
                tmp = new DefaultImpl(mode, "");
                mode = -3;
            } else {
                switch (type) {
                    case IF: 
                    case ELSE: 
                    case FOR: 
                    case IN: 
                    case WHILE: 
                    case REPEAT: 
                    case NEXT: 
                    case BREAK: 
                    case FUNCTION: 
                    case FUNCTION_B: 
                    case NULL: 
                    case TRUE: 
                    case FALSE: 
                    case NA: 
                    case NA_INT: 
                    case NA_REAL: 
                    case NA_CPLX: 
                    case NA_CHAR: 
                    case NAN: 
                    case INF: {
                        if (mode != 17 && mode != 26 && mode != 25) {
                            return null;
                        }
                        tmp = new DefaultImpl(mode, type.text);
                        type = lexer.next();
                        if (type != null && type != RTerminal.EOF) {
                            return null;
                        }
                        mode = -3;
                        break;
                    }
                    case SYMBOL: 
                    case SYMBOL_G: {
                        if (mode != 17 && mode != 26 && mode != 25) {
                            return null;
                        }
                        tmp = new DefaultImpl(mode, lexer.getText());
                        mode = -1;
                        break;
                    }
                    case STRING_D: 
                    case STRING_S: 
                    case STRING_R: {
                        if (mode != 17 && mode != 26 && mode != 25) {
                            return null;
                        }
                        tmp = new DefaultImpl(mode, lexer.getText());
                        mode = -1;
                        break;
                    }
                    case NUM_INT: 
                    case NUM_NUM: {
                        if (mode != 27 && mode != 28) {
                            return null;
                        }
                        tmp = new DefaultImpl(mode, lexer.getText());
                        type = lexer.next();
                        if (type != RTerminal.SUB_INDEXED_CLOSE) {
                            return null;
                        }
                        if (mode == 28 && (type = lexer.next()) != RTerminal.SUB_INDEXED_CLOSE) {
                            return null;
                        }
                        mode = -1;
                        break;
                    }
                    case SUB_NAMED_PART: {
                        if (main == null || mode >= 0) {
                            return null;
                        }
                        mode = 26;
                        continue block12;
                    }
                    case SUB_NAMED_SLOT: {
                        if (main == null || mode >= 0) {
                            return null;
                        }
                        mode = 25;
                        continue block12;
                    }
                    case SUB_INDEXED_S_OPEN: {
                        if (main == null || mode >= 0) {
                            return null;
                        }
                        mode = 27;
                        continue block12;
                    }
                    case SUB_INDEXED_D_OPEN: {
                        if (main == null || mode >= 0) {
                            return null;
                        }
                        mode = 28;
                        continue block12;
                    }
                    case NS_GET: {
                        if (main == null || main != last || mode >= 0) {
                            return null;
                        }
                        if (main.getType() != 17) {
                            return null;
                        }
                        main = new DefaultImpl(33, main.getSegmentName());
                        mode = 17;
                        continue block12;
                    }
                    case NS_GET_INT: {
                        if (main == null || main != last || mode >= 0) {
                            return null;
                        }
                        if (main.getType() != 17) {
                            return null;
                        }
                        main = new DefaultImpl(34, main.getSegmentName());
                        mode = 17;
                        continue block12;
                    }
                    default: {
                        return null;
                    }
                }
            }
            if (main == null) {
                main = last = tmp;
                continue;
            }
            if (RElementName.isScopeType(main.getType())) {
                tmp.scope = main;
                main = last = tmp;
                continue;
            }
            last.nextSegment = tmp;
            last = tmp;
        }
        return main;
    }

    public static @Nullable RElementName cloneName(@Nullable RElementName name, boolean withScope) {
        DefaultImpl main;
        RElementName scopeName;
        if (name == null) {
            return null;
        }
        RElementName rElementName = scopeName = withScope ? name.getScope() : null;
        if (scopeName != null) {
            scopeName = new DefaultImpl(scopeName.getType(), scopeName.getSegmentName(), null);
        }
        DefaultImpl last = main = new DefaultImpl(name.getType(), scopeName, name.getSegmentName(), null);
        name = name.getNextSegment();
        while (name != null) {
            DefaultImpl copy = name.cloneSegment0(null);
            last.nextSegment = copy;
            last = copy;
            name = name.getNextSegment();
        }
        return main;
    }

    public static RElementName cloneSegment(RElementName name) {
        return name.cloneSegment0(null);
    }

    public static RElementName addScope(RElementName name, RElementName scope) {
        if (!RElementName.isScopeType(scope.getType())) {
            throw new IllegalArgumentException("scope.type= " + scope.getType());
        }
        return new DefaultImpl(name.getType(), RElementName.checkSegment(scope, null), name.getSegmentName(), name.getNextSegment());
    }

    public static RElementName removeScope(RElementName name) {
        RElementName scope = name.getScope();
        if (scope == null) {
            return name;
        }
        if (!RElementName.isScopeType(scope.getType())) {
            throw new IllegalArgumentException("scope.type= " + scope.getType());
        }
        return new DefaultImpl(name.getType(), scope, name.getSegmentName(), name.getNextSegment());
    }

    public static RElementName normalize(RElementName name) {
        if (name != null && name.getScope() == null && RElementName.isScopeType(name.getType()) && name.getNextSegment() != null) {
            return RElementName.addScope(name.getNextSegment(), name);
        }
        return name;
    }

    public static void addSegments(Collection<? super RElementName> segments, @Nullable RElementName name) {
        while (name != null) {
            segments.add(name);
            name = name.getNextSegment();
        }
    }

    public static void addSegments(Collection<? super RElementName> segments, @Nullable RElementName name, @Nullable RElementName end) {
        while (name != null && name != end) {
            segments.add(name);
            name = name.getNextSegment();
        }
    }

    protected RElementName() {
    }

    public abstract @Nullable RElementName getScope();

    public abstract @Nullable RElementName getNextSegment();

    public RElementName getLastSegment() {
        RElementName lastSegment;
        RElementName nextSegment = this;
        do {
            lastSegment = nextSegment;
        } while ((nextSegment = nextSegment.getNextSegment()) != null);
        return lastSegment;
    }

    public String getDisplayName() {
        return RElementName.createDisplayName(this, 0);
    }

    public @Nullable String getDisplayName(int options) {
        return RElementName.createDisplayName(this, options);
    }

    public int[] correctDisplayNameRegions(int[] regions, int offset) {
        String segmentName = this.getSegmentName();
        if (segmentName != null && !RElementName.isValidSymbol(segmentName)) {
            new RValueFormatter().correctNameRegions(regions, segmentName, true, offset);
        }
        return regions;
    }

    protected boolean isDefaultImpl() {
        return this.getClass() == DefaultImpl.class;
    }

    protected DefaultImpl cloneSegment0(@Nullable RElementName next) {
        return new DefaultImpl(this.getType(), this.getSegmentName(), next);
    }

    public final int hashCode() {
        String name = this.getSegmentName();
        RElementName next = this.getNextSegment();
        if (next != null) {
            return this.getType() * (name != null ? name.hashCode() : 1) * (((Object)next).hashCode() + 7);
        }
        return this.getType() * (name != null ? name.hashCode() : 1);
    }

    public final boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RElementName) {
            RElementName other = (RElementName)obj;
            return this.getType() == other.getType() && NameUtils.areEqual((String)this.getSegmentName(), (String)other.getSegmentName()) && Objects.equals(this.getNextSegment(), other.getNextSegment());
        }
        return false;
    }

    public String toString() {
        return this.getDisplayName();
    }

    private static class DefaultImpl
    extends RElementName
    implements Serializable {
        private static final long serialVersionUID = 315497720879434929L;
        private final int type;
        private final @Nullable String segmentName;
        private @Nullable RElementName scope;
        private @Nullable RElementName nextSegment;

        public DefaultImpl(int type, @Nullable String segmentName) {
            this.type = type;
            this.segmentName = segmentName;
            this.nextSegment = null;
        }

        public DefaultImpl(int type, @Nullable RElementName scope, @Nullable String segmentName, @Nullable RElementName next) {
            this.type = type;
            this.segmentName = segmentName;
            this.scope = scope;
            this.nextSegment = next;
        }

        public DefaultImpl(int type, @Nullable String segmentName, @Nullable RElementName next) {
            this.type = type;
            this.segmentName = segmentName;
            this.nextSegment = next;
        }

        public int getType() {
            return this.type;
        }

        public @Nullable String getSegmentName() {
            return this.segmentName;
        }

        @Override
        public @Nullable RElementName getScope() {
            return this.scope;
        }

        @Override
        public @Nullable RElementName getNextSegment() {
            return this.nextSegment;
        }
    }

    private static class DualImpl
    extends DefaultImpl
    implements IndexElementName {
        private static final long serialVersionUID = 7040207683623992047L;
        private final int idx;

        public DualImpl(int type, @Nullable String segmentName, int idx) {
            super(type, segmentName);
            this.idx = idx;
        }

        public DualImpl(int type, @Nullable String segmentName, int idx, @Nullable RElementName next) {
            super(type, segmentName, next);
            this.idx = idx;
        }

        @Override
        protected boolean isDefaultImpl() {
            return this.getClass() == DualImpl.class;
        }

        @Override
        protected DefaultImpl cloneSegment0(@Nullable RElementName next) {
            return new DualImpl(this.getType(), this.getSegmentName(), this.idx, next);
        }

        @Override
        public int getIndex() {
            return this.idx;
        }
    }

    public static interface IndexElementName
    extends ElementName {
        public int getIndex();
    }
}

