/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.core.source.doc;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.statet.docmlet.wikitext.core.markup.WikitextMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.source.doc.MarkupLanguagePartitioner;
import org.eclipse.statet.ecommons.text.PartitionerDocumentSetupParticipant;

public abstract class MarkupLanguageDocumentSetupParticipant
extends PartitionerDocumentSetupParticipant {
    private final WikitextMarkupLanguage markupLanguage;
    private final int markupLanguageMode;

    public static WikitextMarkupLanguage getMarkupLanguage(IDocument document, String partitioning) {
        MarkupLanguagePartitioner partitioner = (MarkupLanguagePartitioner)((IDocumentExtension3)document).getDocumentPartitioner(partitioning);
        return partitioner.getMarkupLanguage();
    }

    public MarkupLanguageDocumentSetupParticipant(WikitextMarkupLanguage markupLanguage, int markupLanguageMode) {
        if (markupLanguage == null) {
            throw new NullPointerException("markupLanguage");
        }
        this.markupLanguage = markupLanguage;
        this.markupLanguageMode = markupLanguageMode;
    }

    public WikitextMarkupLanguage getMarkupLanguage() {
        return this.markupLanguage;
    }

    protected int getMarkupLanguageMode() {
        return this.markupLanguageMode;
    }

    protected void doSetup(IDocument document) {
        this.doSetup(document, this.getMarkupLanguage());
    }

    protected void doSetup(IDocument document, WikitextMarkupLanguage markupLanguage) {
        IDocumentExtension3 extension3 = (IDocumentExtension3)document;
        MarkupLanguagePartitioner partitioner = (MarkupLanguagePartitioner)extension3.getDocumentPartitioner(this.getPartitioningId());
        if (partitioner == null) {
            partitioner = this.createDocumentPartitioner(markupLanguage);
            partitioner.connect(document, true);
            extension3.setDocumentPartitioner(this.getPartitioningId(), (IDocumentPartitioner)partitioner);
        } else {
            partitioner.setMarkupLanguage(markupLanguage);
            extension3.setDocumentPartitioner(this.getPartitioningId(), (IDocumentPartitioner)partitioner);
        }
    }

    protected IDocumentPartitioner createDocumentPartitioner() {
        throw new UnsupportedOperationException();
    }

    protected abstract MarkupLanguagePartitioner createDocumentPartitioner(WikitextMarkupLanguage var1);
}

