/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.viewport.core;

import org.eclipse.statet.ecommons.waltable.core.command.LayerCommandHandler;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Direction;
import org.eclipse.statet.ecommons.waltable.viewport.core.ScrollPageCommand;
import org.eclipse.statet.ecommons.waltable.viewport.core.ViewportLayer;
import org.eclipse.statet.ecommons.waltable.viewport.core.ViewportLayerDim;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class ScrollPageCommandHandler
implements LayerCommandHandler<ScrollPageCommand> {
    private final ViewportLayer viewportLayer;

    public ScrollPageCommandHandler(ViewportLayer viewportLayer) {
        this.viewportLayer = viewportLayer;
    }

    @Override
    public Class<ScrollPageCommand> getCommandClass() {
        return ScrollPageCommand.class;
    }

    @Override
    public boolean executeCommand(ScrollPageCommand command) {
        Direction direction = command.getDirection();
        ViewportLayerDim viewportDim = this.viewportLayer.getDim(direction.getOrientation());
        if (direction.isBackward()) {
            viewportDim.scrollBackwardByPage();
        } else {
            viewportDim.scrollForwardByPage();
        }
        return true;
    }
}

