/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.selection.core;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.statet.ecommons.waltable.core.command.AbstractDimPositionsCommand;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerDim;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public abstract class AbstractSelectDimPositionsCommand
extends AbstractDimPositionsCommand {
    private final int selectionFlags;
    private long positionToReveal;

    public AbstractSelectDimPositionsCommand(LayerDim layerDim, long position, int selectionFlags) {
        this(layerDim, position, Collections.singletonList(new LRange(position)), position, selectionFlags);
    }

    public AbstractSelectDimPositionsCommand(LayerDim layerDim, long refPosition, Collection<LRange> positions, long positionToReveal, int selectionFlags) {
        super(layerDim, refPosition, positions);
        this.positionToReveal = positionToReveal;
        this.selectionFlags = selectionFlags;
    }

    protected AbstractSelectDimPositionsCommand(AbstractSelectDimPositionsCommand command) {
        super(command);
        this.positionToReveal = command.positionToReveal;
        this.selectionFlags = command.selectionFlags;
    }

    public int getSelectionFlags() {
        return this.selectionFlags;
    }

    public long getPositionToReveal() {
        return this.positionToReveal;
    }

    @Override
    protected boolean convertToTargetLayer(LayerDim dim, long refPosition, LayerDim targetDim) {
        if (super.convertToTargetLayer(dim, refPosition, targetDim)) {
            if (this.positionToReveal != Long.MIN_VALUE) {
                this.positionToReveal = this.positionToReveal == refPosition ? this.getRefPosition() : LayerUtils.convertPosition(dim, refPosition, this.positionToReveal, targetDim);
            }
            return true;
        }
        return false;
    }
}

