/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.core.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.statet.ecommons.waltable.core.config.ConfigAttribute;
import org.eclipse.statet.ecommons.waltable.core.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.config.DefaultDisplayModeOrdering;
import org.eclipse.statet.ecommons.waltable.core.config.DisplayMode;
import org.eclipse.statet.ecommons.waltable.core.config.DisplayModeLookupStrategy;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public class BasicConfigRegistry
implements ConfigRegistry {
    private DisplayModeLookupStrategy displayModeLookupStrategy = new DefaultDisplayModeOrdering();
    private final Map<ConfigAttribute<?>, Map<DisplayMode, Map<String, ?>>> configRegistry = new HashMap();

    @Override
    public DisplayModeLookupStrategy getDisplayModeOrdering() {
        return this.displayModeLookupStrategy;
    }

    public void setDisplayModeOrdering(DisplayModeLookupStrategy displayModeLookupStrategy) {
        this.displayModeLookupStrategy = (DisplayModeLookupStrategy)ObjectUtils.nonNullAssert((Object)displayModeLookupStrategy);
    }

    @Override
    public <T> @Nullable T getAttribute(ConfigAttribute<T> configAttribute, DisplayMode targetDisplayMode, String ... configLabels) {
        return this.getAttribute(configAttribute, targetDisplayMode, (List<String>)ImCollections.newList((Object[])configLabels));
    }

    @Override
    public <T> @Nullable T getAttribute(ConfigAttribute<T> configAttribute, DisplayMode targetDisplayMode, List<String> configLabels) {
        T attributeValue = null;
        Map<DisplayMode, Map<String, ?>> displayModeAttributeMap = this.configRegistry.get(configAttribute);
        if (displayModeAttributeMap != null) {
            for (DisplayMode displayMode : this.displayModeLookupStrategy.getDisplayModeOrdering(targetDisplayMode)) {
                Map<String, ?> configAttributeMap = displayModeAttributeMap.get((Object)displayMode);
                if (configAttributeMap == null) continue;
                for (String configLabel : configLabels) {
                    attributeValue = (T)configAttributeMap.get(configLabel);
                    if (attributeValue == null) continue;
                    return attributeValue;
                }
                attributeValue = (T)configAttributeMap.get(null);
                if (attributeValue == null) continue;
                return attributeValue;
            }
        }
        return attributeValue;
    }

    @Override
    public <T> @Nullable T getSpecificAttribute(ConfigAttribute<T> configAttribute, DisplayMode displayMode, @Nullable String configLabel) {
        Map<String, ?> configAttributeMap;
        T attributeValue = null;
        Map<DisplayMode, Map<String, ?>> displayModeAttributeMap = this.configRegistry.get(configAttribute);
        if (displayModeAttributeMap != null && (configAttributeMap = displayModeAttributeMap.get((Object)displayMode)) != null && (attributeValue = (T)configAttributeMap.get(configLabel)) != null) {
            return attributeValue;
        }
        return attributeValue;
    }

    @Override
    public <T> void registerAttribute(ConfigAttribute<T> configAttribute, T attributeValue) {
        this.registerAttribute(configAttribute, attributeValue, DisplayMode.NORMAL);
    }

    @Override
    public <T> void registerAttribute(ConfigAttribute<T> configAttribute, T attributeValue, DisplayMode displayMode) {
        this.registerAttribute(configAttribute, attributeValue, displayMode, null);
    }

    @Override
    public <T> void registerAttribute(ConfigAttribute<T> configAttribute, T attributeValue, DisplayMode displayMode, String configLabel) {
        Map<String, ?> configAttributeMap;
        Map<DisplayMode, Map<String, ?>> displayModeAttributeMap = this.configRegistry.get(configAttribute);
        if (displayModeAttributeMap == null) {
            displayModeAttributeMap = new HashMap();
            this.configRegistry.put(configAttribute, displayModeAttributeMap);
        }
        if ((configAttributeMap = displayModeAttributeMap.get((Object)displayMode)) == null) {
            configAttributeMap = new HashMap();
            displayModeAttributeMap.put(displayMode, configAttributeMap);
        }
        configAttributeMap.put(configLabel, attributeValue);
    }

    @Override
    public <T> void unregisterAttribute(ConfigAttribute<T> configAttributeType, DisplayMode displayMode, String configLabel) {
        Map<String, ?> configAttributeMap;
        Map<DisplayMode, Map<String, ?>> displayModeAttributeMap = this.configRegistry.get(configAttributeType);
        if (displayModeAttributeMap != null && (configAttributeMap = displayModeAttributeMap.get((Object)displayMode)) != null) {
            configAttributeMap.remove(configLabel);
        }
    }
}

