/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.PasswordCallback;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.rj.RjException;

@NonNullByDefault
public final class ServerLogin
implements Serializable {
    private static final long serialVersionUID = -596748668244272719L;
    private long id;
    private @Nullable Key pubkey;
    private Callback @Nullable [] callbacks;

    public ServerLogin(long id, @Nullable Key pubkey, ImList<Callback> callbacks) {
        this.id = id;
        this.pubkey = pubkey;
        this.callbacks = (Callback[])callbacks.toArray((Object[])new Callback[callbacks.size()]);
    }

    public ServerLogin() {
    }

    public long getId() {
        return this.id;
    }

    public ImList<Callback> getCallbacks() {
        Object[] callbacks = this.callbacks;
        if (callbacks == null) {
            throw new IllegalStateException("no longer valid");
        }
        return ImCollections.newList((Object[])callbacks);
    }

    public ServerLogin createAnswer() throws RjException {
        try {
            Callback[] callbacks = (Callback[])ObjectUtils.nonNullAssert((Object)this.callbacks);
            Object[] answerCallbacks = new Callback[callbacks.length];
            System.arraycopy(callbacks, 0, answerCallbacks, 0, callbacks.length);
            Key pubkey = this.pubkey;
            if (pubkey != null) {
                this.process((Callback[])answerCallbacks, 1, pubkey);
            }
            return new ServerLogin(this.id, null, (ImList<Callback>)ImCollections.newList((Object[])answerCallbacks));
        }
        catch (Exception e) {
            throw new RjException("An error occurred when creating login data.", e);
        }
    }

    public void readAnswer(@Nullable Key privateKey) throws RjException {
        try {
            Callback[] callbacks = (Callback[])ObjectUtils.nonNullAssert((Object)this.callbacks);
            if (privateKey != null) {
                this.process(callbacks, 2, privateKey);
            }
        }
        catch (Exception e) {
            throw new RjException("An error occurred when processing login data.", e);
        }
    }

    private void process(Callback[] callbacks, int mode, Key key) throws Exception {
        Cipher with = Cipher.getInstance("RSA");
        with.init(mode, key);
        Charset charset = StandardCharsets.UTF_8;
        int i = 0;
        while (i < callbacks.length) {
            PasswordCallback c;
            char[] orgPassword;
            if (callbacks[i] instanceof PasswordCallback && (orgPassword = (c = (PasswordCallback)callbacks[i]).getPassword()) != null) {
                char[] encPassword;
                byte[] orgBytes;
                if (mode == 1) {
                    orgBytes = charset.encode(CharBuffer.wrap(orgPassword)).array();
                } else {
                    orgBytes = new byte[orgPassword.length];
                    int j = 0;
                    while (j < orgBytes.length) {
                        orgBytes[j] = (byte)orgPassword[j];
                        ++j;
                    }
                }
                byte[] encBytes = with.doFinal(orgBytes);
                if (mode == 1) {
                    encPassword = new char[encBytes.length];
                    int j = 0;
                    while (j < encPassword.length) {
                        encPassword[j] = (char)encBytes[j];
                        ++j;
                    }
                } else {
                    encPassword = charset.decode(ByteBuffer.wrap(encBytes)).array();
                }
                if (mode == 1) {
                    PasswordCallback copy = new PasswordCallback(c.getPrompt(), c.isEchoOn());
                    copy.setPassword(encPassword);
                    callbacks[i] = copy;
                } else {
                    c.clearPassword();
                    c.setPassword(encPassword);
                }
                Arrays.fill(orgBytes, (byte)0);
                Arrays.fill(orgPassword, '\u0000');
                Arrays.fill(encBytes, (byte)0);
                Arrays.fill(encPassword, '\u0000');
            }
            ++i;
        }
    }

    public void clearData() {
        this.pubkey = null;
        Callback[] callbacks = this.callbacks;
        if (callbacks != null) {
            this.callbacks = null;
            int i = 0;
            while (i < callbacks.length) {
                if (callbacks[i] instanceof PasswordCallback) {
                    ((PasswordCallback)callbacks[i]).clearPassword();
                }
                ++i;
            }
        }
    }
}

