/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.text.rd;

import java.util.EnumMap;
import java.util.Map;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.statet.ecommons.text.core.rules.BufferedDocumentScanner;

public class RdFastPartitionScanner
implements IPartitionTokenScanner {
    private static final char[][] PLATFORM_KEYWORDS = new char[][]{"ifdef".toCharArray(), "ifndef".toCharArray(), "endif".toCharArray()};
    private final BufferedDocumentScanner fScanner = new BufferedDocumentScanner(1000);
    private int fTokenOffset;
    private int fTokenLength;
    private State fState;
    private Last fLast;
    private int fPrefixLength;
    private final Map<State, IToken> fTokens = new EnumMap<State, IToken>(State.class);

    public RdFastPartitionScanner() {
        this.fTokens.put(State.DEFAULT, (IToken)new Token(null));
        this.fTokens.put(State.COMMENT, (IToken)new Token((Object)"Rd.Comment"));
        this.fTokens.put(State.PLATFORM, (IToken)new Token((Object)"__rd_platform"));
    }

    public void setRange(IDocument document, int offset, int length) {
        this.setPartialRange(document, offset, length, null, -1);
    }

    public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
        if (partitionOffset < 0) {
            partitionOffset = offset;
        }
        this.fScanner.setRange(document, offset, length);
        this.fTokenOffset = partitionOffset;
        this.fTokenLength = 0;
        this.fPrefixLength = offset - partitionOffset;
        this.fLast = this.fScanner.getColumn() == 0 ? Last.NEW_LINE : Last.NONE;
        this.fState = offset == partitionOffset ? State.DEFAULT : RdFastPartitionScanner.getState(contentType);
    }

    public IToken nextToken() {
        this.fTokenOffset += this.fTokenLength;
        this.fTokenLength = this.fPrefixLength;
        block12: while (true) {
            int ch = this.fScanner.read();
            switch (ch) {
                case -1: {
                    this.fLast = Last.NONE;
                    this.fPrefixLength = 0;
                    if (this.fTokenLength > 0) {
                        return this.fTokens.get((Object)this.fState);
                    }
                    return Token.EOF;
                }
                case 10: 
                case 13: {
                    switch (this.fState) {
                        case COMMENT: 
                        case PLATFORM: {
                            return this.preFinish(this.fState, State.DEFAULT, Last.NEW_LINE, 1);
                        }
                    }
                    this.consume(Last.NEW_LINE);
                    continue block12;
                }
            }
            if (this.fState == State.DEFAULT) {
                if (this.fLast == Last.BACKSLASH) {
                    this.consume(Last.NONE);
                    continue;
                }
                switch (ch) {
                    case 92: {
                        this.consume(Last.BACKSLASH);
                        continue block12;
                    }
                    case 35: {
                        if (this.fLast == Last.NEW_LINE) {
                            int i = 0;
                            while (i < PLATFORM_KEYWORDS.length) {
                                if (this.searchWord(PLATFORM_KEYWORDS[i])) {
                                    int length = PLATFORM_KEYWORDS[i].length + 1;
                                    if (this.fTokenLength >= length) {
                                        return this.preFinish(this.fState, State.PLATFORM, Last.NONE, length);
                                    }
                                    this.prepareNew(State.PLATFORM, Last.NONE, length);
                                    continue block12;
                                }
                                ++i;
                            }
                        }
                        this.consume(Last.NONE);
                        continue block12;
                    }
                    case 37: {
                        if (this.fTokenLength > 0) {
                            return this.preFinish(this.fState, State.COMMENT, Last.NONE, 1);
                        }
                        this.prepareNew(State.COMMENT, Last.NONE, 1);
                        continue block12;
                    }
                }
                this.consume(Last.NONE);
                continue;
            }
            this.consume(Last.NONE);
        }
    }

    private final void consume(Last last) {
        ++this.fTokenLength;
        this.fLast = last;
    }

    private final boolean searchWord(char[] word) {
        int i = 0;
        while (i < word.length) {
            int ch = this.fScanner.read();
            if (ch != word[i]) {
                while (i >= 0) {
                    this.fScanner.unread();
                    --i;
                }
                return false;
            }
            ++i;
        }
        this.fTokenLength += word.length;
        return true;
    }

    private final IToken preFinish(State state, State newState, Last last, int prefixLength) {
        this.fLast = last;
        this.fState = newState;
        this.fTokenLength -= prefixLength - 1;
        this.fPrefixLength = prefixLength;
        return this.fTokens.get((Object)state);
    }

    private final void prepareNew(State newState, Last last, int prefixLength) {
        this.fLast = last;
        this.fState = newState;
        this.fTokenOffset += this.fTokenLength - (prefixLength - 1);
        this.fTokenLength = prefixLength;
        this.fPrefixLength = 0;
    }

    private static State getState(String contentType) {
        if (contentType == null) {
            return State.DEFAULT;
        }
        if (contentType.equals("Rd.Comment")) {
            return State.COMMENT;
        }
        if (contentType.equals("__rd_platform")) {
            return State.PLATFORM;
        }
        return State.DEFAULT;
    }

    public int getTokenLength() {
        return this.fTokenLength;
    }

    public int getTokenOffset() {
        return this.fTokenOffset;
    }

    private static enum Last {
        NONE,
        BACKSLASH,
        NEW_LINE;

    }

    private static enum State {
        DEFAULT,
        COMMENT,
        PLATFORM;

    }
}

