/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.dataeditor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.statet.internal.r.ui.dataeditor.AbstractRDataProvider;
import org.eclipse.statet.internal.r.ui.dataeditor.ContentDescription;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.r.core.rmodel.RElementName;
import org.eclipse.statet.r.ui.dataeditor.RDataTableColumn;
import org.eclipse.statet.r.ui.dataeditor.RDataTableInput;
import org.eclipse.statet.rj.data.RArray;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.services.util.dataaccess.LazyRStore;
import org.eclipse.statet.rj.services.util.dataaccess.RMatrixDataAdapter;
import org.eclipse.statet.rj.ts.core.RToolService;

public class RMatrixDataProvider
extends AbstractRDataProvider<RArray<?>> {
    public RMatrixDataProvider(RDataTableInput input, RArray<?> struct) throws CoreException {
        super(input, new RMatrixDataAdapter(), struct);
        this.reset();
    }

    @Override
    public boolean getAllColumnsEqual() {
        return true;
    }

    @Override
    protected ContentDescription loadDescription(RElementName name, RArray<?> struct, RToolService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
        long count = this.getColumnCount();
        RDataTableColumn rowHeaderColumn = this.createNamesColumn("rownames(" + this.getInput().getFullName() + ")", this.getAdapter().getRowCount(struct), r, m);
        RDataTableColumn template = this.createColumn(struct.getData(), this.getInput().getFullName(), null, -1L, null, r, m);
        RDataTableColumn[] dataColumns = null;
        if (count <= 2500L) {
            int l = (int)count;
            RObject rObject = r.evalData("colnames(" + this.getInput().getFullName() + ")", m);
            RStore names = rObject != null && rObject.getRObjectType() == 2 && rObject.getLength() == (long)l ? rObject.getData() : null;
            dataColumns = new RDataTableColumn[l];
            int i = 0;
            while (i < l) {
                dataColumns[i] = new RDataTableColumn(i, names != null ? names.getChar(i) : Integer.toString(i + 1), null, null, template.getVarType(), template.getDataStore(), template.getClassNames(), template.getDefaultFormat());
                ++i;
            }
        }
        return new ContentDescription(name, (RObject)struct, r.getTool(), (ImList<RDataTableColumn>)ImCollections.emptyList(), (ImList<RDataTableColumn>)ImCollections.newList((Object)rowHeaderColumn), (ImList<RDataTableColumn>)ImCollections.emptyList(), dataColumns, template.getDefaultFormat());
    }

    @Override
    protected void appendOrderCmd(StringBuilder cmd, AbstractRDataProvider.SortColumn sortColumn) {
        cmd.append("order(");
        cmd.append(this.getInput().getFullName());
        cmd.append("[,");
        cmd.append(sortColumn.getIdx() + 1L);
        cmd.append("],decreasing=");
        cmd.append(sortColumn.decreasing ? "TRUE" : "FALSE");
        cmd.append(')');
    }

    @Override
    protected Object getDataValue(LazyRStore.Fragment<RArray<?>> fragment, long rowIdx, long columnIdx) {
        return ((RArray)fragment.getRObject()).getData().get(RDataUtils.getDataIdx((long)fragment.getRowCount(), (long)fragment.toLocalRowIdx(rowIdx), (long)fragment.toLocalColumnIdx(columnIdx)));
    }

    @Override
    protected Object getColumnName(LazyRStore.Fragment<RArray<?>> fragment, long columnIdx) {
        RStore names = ((RArray)fragment.getRObject()).getNames(1);
        if (names != null) {
            return names.get(columnIdx - fragment.getColumnBeginIdx());
        }
        return Long.toString(columnIdx + 1L);
    }
}

