/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text.ui;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.statet.ecommons.collections.FastList;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class EcoReconciler
implements IReconciler {
    private final DocumentListener fDocumentListener = new DocumentListener();
    private VisibleListener fVisibleListener;
    private ReconcileJob fJob;
    private int fDelay = 500;
    private IDocument fDocument;
    private ITextViewer fViewer;
    private ITextEditor fEditor;
    private IEditorInput fEditorInput;
    private volatile boolean fIsEditorVisible;
    private final FastList<StrategyEntry> fStrategies = new FastList(StrategyEntry.class, 0);

    public EcoReconciler() {
    }

    public EcoReconciler(ITextEditor editor) {
        this.fEditor = editor;
    }

    public void setDelay(int delay) {
        this.fDelay = delay;
    }

    protected IDocument getDocument() {
        return this.fDocument;
    }

    protected IEditorInput getEditorInput() {
        return this.fEditorInput;
    }

    protected ITextViewer getTextViewer() {
        return this.fViewer;
    }

    protected boolean isEditorVisible() {
        return this.fIsEditorVisible;
    }

    public void install(ITextViewer textViewer) {
        Assert.isNotNull((Object)textViewer);
        this.fViewer = textViewer;
        this.fVisibleListener = new VisibleListener();
        StyledText textWidget = this.fViewer.getTextWidget();
        textWidget.addListener(22, (Listener)this.fVisibleListener);
        textWidget.addListener(23, (Listener)this.fVisibleListener);
        this.fIsEditorVisible = textWidget.isVisible();
        this.fViewer.addTextInputListener((ITextInputListener)this.fDocumentListener);
        this.connectDocument();
    }

    public void uninstall() {
        if (this.fViewer != null) {
            this.disconnectDocument();
            this.fViewer.removeTextInputListener((ITextInputListener)this.fDocumentListener);
            this.fViewer = null;
        }
    }

    protected void connectDocument() {
        IDocument document = this.fViewer.getDocument();
        if (document == null || this.fDocument == document) {
            return;
        }
        this.fDocument = document;
        this.fEditorInput = this.fEditor != null ? this.fEditor.getEditorInput() : null;
        this.reconcilerDocumentChanged(this.fDocument);
        this.fJob = new ReconcileJob(this.getInputName());
        this.fDocument.addDocumentListener((IDocumentListener)this.fDocumentListener);
        this.scheduleReconcile();
    }

    protected String getInputName() {
        if (this.fEditorInput != null) {
            return this.fEditorInput.getName();
        }
        return "-";
    }

    protected void reconcilerDocumentChanged(IDocument newDocument) {
    }

    protected void disconnectDocument() {
        if (this.fDocument != null) {
            this.fDocument.removeDocumentListener((IDocumentListener)this.fDocumentListener);
            this.fDocument = null;
            this.fEditorInput = null;
        }
        if (this.fJob != null) {
            this.fJob.cancel();
            this.fJob = null;
        }
    }

    private synchronized void scheduleReconcile() {
        if ((this.fJob.getState() & 3) == 0) {
            this.aboutToBeReconciled();
        }
        this.fJob.cancel();
        this.fJob.schedule(this.fDelay);
    }

    protected void aboutToBeReconciled() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void processReconcile(IProgressMonitor monitor) {
        document = this.getDocument();
        input = this.getEditorInput();
        if (document == null || this.fEditor != null && input == null) {
            return;
        }
        region = new Region(0, document.getLength());
        var9_6 = reconcilingStrategies = this.getReconcilingStrategies();
        var8_7 = reconcilingStrategies.length;
        var7_8 = 0;
        while (var7_8 < var8_7) {
            block9: {
                s = var9_6[var7_8];
                var10_10 = s.strategy;
                synchronized (var10_10) {
                    s.strategy.setDocument(document);
                    if (!this.prepareStrategyReconcile(s)) {
                        break block9;
                    }
                    if (monitor.isCanceled()) {
                        return;
                    }
                    if (s.strategyExtension == null) ** GOTO lbl-1000
                    s.strategyExtension.setProgressMonitor(monitor);
                    if (!s.initialed) {
                        s.strategyExtension.initialReconcile();
                        s.initialed = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        s.strategy.reconcile((IRegion)region);
                    }
                }
            }
            ++var7_8;
        }
    }

    protected boolean prepareStrategyReconcile(StrategyEntry s) {
        return true;
    }

    public void addReconcilingStrategy(IReconcilingStrategy strategy) {
        this.fStrategies.add((Object)new StrategyEntry(strategy));
    }

    protected StrategyEntry[] getReconcilingStrategies() {
        return (StrategyEntry[])this.fStrategies.toArray();
    }

    public IReconcilingStrategy getReconcilingStrategy(String contentType) {
        return null;
    }

    private class DocumentListener
    implements IDocumentListener,
    ITextInputListener {
        private DocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent e) {
        }

        public void documentChanged(DocumentEvent e) {
            EcoReconciler.this.scheduleReconcile();
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            if (EcoReconciler.this.fDocument != null && oldInput == EcoReconciler.this.fDocument && newInput != EcoReconciler.this.fDocument) {
                EcoReconciler.this.disconnectDocument();
            }
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            EcoReconciler.this.connectDocument();
        }
    }

    private class ReconcileJob
    extends Job
    implements ISchedulingRule {
        ReconcileJob(String name) {
            super("Reconciler '" + name + "'");
            this.setPriority(20);
            this.setRule(this);
            this.setSystem(true);
            this.setUser(false);
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (!monitor.isCanceled()) {
                EcoReconciler.this.processReconcile(monitor);
            }
            return Status.OK_STATUS;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }
    }

    protected static class StrategyEntry {
        final IReconcilingStrategy strategy;
        final IReconcilingStrategyExtension strategyExtension;
        boolean initialed;

        StrategyEntry(IReconcilingStrategy strategy) {
            this.strategy = strategy;
            this.strategyExtension = strategy instanceof IReconcilingStrategyExtension ? (IReconcilingStrategyExtension)strategy : null;
            this.initialed = false;
        }

        public int hashCode() {
            return this.strategy.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            if (obj instanceof StrategyEntry) {
                return ((StrategyEntry)obj).strategy == this.strategy;
            }
            return false;
        }
    }

    private class VisibleListener
    implements Listener {
        private VisibleListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 22: {
                    EcoReconciler.this.fIsEditorVisible = true;
                    return;
                }
                case 23: {
                    EcoReconciler.this.fIsEditorVisible = false;
                    return;
                }
            }
        }
    }
}

