/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.core.source.extdoc;

import java.util.List;
import org.eclipse.statet.docmlet.wikitext.core.markup.MarkupConfig;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public abstract class AbstractMarkupConfig<T extends AbstractMarkupConfig<? super T>>
implements MarkupConfig {
    public static final String YAML_METADATA_ENABLED_PROP = "YamlMetadataEnabled";
    private static final String YAML_METADATA_ENABLED_KEY = "yaml_metadata_block";
    public static final String TEX_MATH_DOLLARS_ENABLED_PROP = "TexMathDollarsEnabled";
    private static final String TEX_MATH_DOLLARS_ENABLED_KEY = "tex_math_dollars";
    public static final String TEX_MATH_SBACKSLASH_ENABLED_PROP = "TexMathSBackslashEnabled";
    private static final String TEX_MATH_SBACKSLASH_ENABLED_KEY = "tex_math_single_backslash";
    private boolean isSealed;
    private boolean isYamlMetadataEnabled;
    private boolean isTexMathDollarsEnabled;
    private boolean isTexMathSBackslashEnabled;
    private @Nullable String configString;

    protected AbstractMarkupConfig() {
    }

    public T clone() {
        try {
            AbstractMarkupConfig clone = (AbstractMarkupConfig)super.clone();
            clone.isSealed = false;
            return (T)clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void seal() {
        this.isSealed = true;
    }

    @Override
    public final boolean isSealed() {
        return this.isSealed;
    }

    protected final void checkSeal() {
        if (this.isSealed()) {
            throw new IllegalStateException("object is read only");
        }
    }

    protected void afterChange(String propertyName) {
        this.configString = null;
    }

    public synchronized void setYamlMetadataEnabled(boolean enabled) {
        this.checkSeal();
        if (this.isYamlMetadataEnabled != enabled) {
            this.isYamlMetadataEnabled = enabled;
            this.afterChange(YAML_METADATA_ENABLED_PROP);
        }
    }

    public boolean isYamlMetadataEnabled() {
        return this.isYamlMetadataEnabled;
    }

    public void setTexMathDollarsEnabled(boolean enabled) {
        this.checkSeal();
        if (this.isTexMathDollarsEnabled != enabled) {
            this.isTexMathDollarsEnabled = enabled;
            this.afterChange(TEX_MATH_DOLLARS_ENABLED_PROP);
        }
    }

    public boolean isTexMathDollarsEnabled() {
        return this.isTexMathDollarsEnabled;
    }

    public void setTexMathSBackslashEnabled(boolean enabled) {
        this.checkSeal();
        if (this.isTexMathSBackslashEnabled != enabled) {
            this.isTexMathSBackslashEnabled = enabled;
            this.afterChange(TEX_MATH_SBACKSLASH_ENABLED_PROP);
        }
    }

    public boolean isTexMathSBackslashEnabled() {
        return this.isTexMathSBackslashEnabled;
    }

    @Override
    public String getString() {
        String s = this.configString;
        if (s == null) {
            StringBuilder sb = new StringBuilder(this.getConfigType());
            sb.append(':');
            this.createConfigString(sb);
            this.configString = s = sb.charAt(sb.length() - 1) == ';' ? sb.substring(0, sb.length() - 1) : sb.toString();
        }
        return s;
    }

    protected abstract String getConfigType();

    protected boolean supportsConfigType(String configType) {
        return this.getConfigType().equals(configType);
    }

    protected void createConfigString(StringBuilder sb) {
        if (this.isYamlMetadataEnabled()) {
            sb.append("yaml_metadata_block;");
        }
        if (this.isTexMathDollarsEnabled()) {
            sb.append("tex_math_dollars;");
        }
        if (this.isTexMathSBackslashEnabled()) {
            sb.append("tex_math_single_backslash;");
        }
    }

    protected void load(String configType, List<String> s) {
        this.setYamlMetadataEnabled(s.contains(YAML_METADATA_ENABLED_KEY));
        this.setTexMathDollarsEnabled(s.contains(TEX_MATH_DOLLARS_ENABLED_KEY));
        this.setTexMathSBackslashEnabled(s.contains(TEX_MATH_SBACKSLASH_ENABLED_KEY));
    }

    @Override
    public boolean load(String configString) {
        String configType;
        int i = configString.indexOf(58);
        if (i < 0 || !this.supportsConfigType(configType = configString.substring(0, i))) {
            return false;
        }
        this.load(configType, (List<String>)ImCollections.newList((Object[])configString.substring(i + 1).split(";")));
        return true;
    }

    public void load(T config) {
        this.setYamlMetadataEnabled(((AbstractMarkupConfig)config).isYamlMetadataEnabled());
        this.setTexMathDollarsEnabled(((AbstractMarkupConfig)config).isTexMathDollarsEnabled());
        this.setTexMathSBackslashEnabled(((AbstractMarkupConfig)config).isTexMathSBackslashEnabled());
    }

    public int hashCode() {
        return this.getString().hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AbstractMarkupConfig) {
            AbstractMarkupConfig other = (AbstractMarkupConfig)obj;
            return this.getConfigType() == other.getConfigType() && this.isYamlMetadataEnabled() == other.isYamlMetadataEnabled() && this.isTexMathDollarsEnabled() == other.isTexMathDollarsEnabled() && this.isTexMathSBackslashEnabled() == other.isTexMathSBackslashEnabled();
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + ": " + this.getString();
    }
}

