/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.ITextContentDescriber;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class TextContentDescriber
implements ITextContentDescriber {
    private static final @NonNull QualifiedName[] SUPPORTED_OPTIONS = new QualifiedName[]{IContentDescription.BYTE_ORDER_MARK};

    public @NonNull QualifiedName[] getSupportedOptions() {
        return SUPPORTED_OPTIONS;
    }

    public int describe(Reader contents, @Nullable IContentDescription description) throws IOException {
        return 1;
    }

    public int describe(InputStream contents, @Nullable IContentDescription description) throws IOException {
        if (description == null || !description.isRequested(IContentDescription.BYTE_ORDER_MARK)) {
            return 1;
        }
        byte[] bom = this.getByteOrderMark(contents);
        if (bom != null) {
            description.setProperty(IContentDescription.BYTE_ORDER_MARK, (Object)bom);
        }
        return 1;
    }

    protected final byte @Nullable [] getByteOrderMark(InputStream input) throws IOException {
        int first = input.read();
        byte[] bom = null;
        switch (first) {
            case 239: {
                if (input.read() != 187 || input.read() != 191) break;
                bom = IContentDescription.BOM_UTF_8;
                break;
            }
            case 254: {
                if (input.read() != 255) break;
                bom = IContentDescription.BOM_UTF_16BE;
                break;
            }
            case 255: {
                if (input.read() != 254) break;
                bom = IContentDescription.BOM_UTF_16LE;
                break;
            }
        }
        input.reset();
        if (bom != null) {
            input.skip(bom.length);
        }
        return bom;
    }
}

