/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.yaml.core.source.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.yaml.core.source.ast.YamlAstNode;
import org.eclipse.statet.yaml.core.source.ast.YamlAstVisitor;
import org.eclipse.statet.yaml.core.source.ast.YamlAsts;
import org.eclipse.statet.yaml.core.source.ast.YamlParser;

@NonNullByDefault
abstract class NContainer
extends YamlAstNode {
    ImIdentityList<YamlAstNode> children = ImCollections.newIdentityList();

    NContainer() {
    }

    void add(YamlParser.NContainerBuilder containerBuilder, YamlAstNode child) {
        containerBuilder.children.add(child);
    }

    void finish(int endOffset, YamlParser.NContainerBuilder containerBuilder) {
        int minEnd;
        this.children = ImCollections.toIdentityList(containerBuilder.children);
        super.finish(endOffset);
        if (!this.children.isEmpty() && this.endOffset < (minEnd = ((YamlAstNode)((Object)this.children.get(this.children.size() - 1))).getEndOffset())) {
            this.endOffset = minEnd;
        }
    }

    @Override
    protected boolean hasErrorInChild() {
        for (YamlAstNode child : this.children) {
            if (!YamlAsts.hasErrors((AstNode)child)) continue;
            return true;
        }
        return false;
    }

    public final boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public final int getChildCount() {
        return this.children.size();
    }

    @Override
    public final YamlAstNode getChild(int index) {
        return (YamlAstNode)((Object)this.children.get(index));
    }

    public final int getChildIndex(AstNode child) {
        return this.children.indexOf((Object)child);
    }

    public final void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
        for (YamlAstNode child : this.children) {
            visitor.visit((AstNode)child);
        }
    }

    @Override
    public final void acceptInYamlChildren(YamlAstVisitor visitor) throws InvocationTargetException {
        for (YamlAstNode child : this.children) {
            child.acceptInYaml(visitor);
        }
    }
}

