/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.preferences.core;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.core.PreferenceObjectAccess;
import org.eclipse.statet.ecommons.preferences.core.PreferenceSetService;
import org.eclipse.statet.ecommons.preferences.core.PreferenceUtils;
import org.eclipse.statet.ecommons.preferences.core.util.PreferenceObjectCache;
import org.eclipse.statet.internal.ecommons.preferences.core.ECommonsPreferencesCorePlugin;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.collections.ImSet;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public final class EPreferences {
    private static final DefaultImpl DEFAULT_PREFS = new DefaultImpl((ImList<IScopeContext>)ImCollections.newList((Object)DefaultScope.INSTANCE));
    private static final DefaultImpl INSTANCE_PREFS = new DefaultImpl((ImList<IScopeContext>)ImCollections.newList((Object[])new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE}));

    public static final PreferenceAccess getInstancePrefs() {
        return INSTANCE_PREFS;
    }

    public static final PreferenceAccess getDefaultPrefs() {
        return DEFAULT_PREFS;
    }

    public static final PreferenceAccess getContextPrefs(@Nullable IAdaptable adaptable) {
        PreferenceAccess access;
        if (adaptable != null && (access = (PreferenceAccess)adaptable.getAdapter(PreferenceAccess.class)) != null) {
            return access;
        }
        return INSTANCE_PREFS;
    }

    public static PreferenceAccess createAccess(Map<Preference<?>, Object> preferencesMap) {
        return new MapImpl(preferencesMap);
    }

    public static PreferenceAccess createAccess(List<IScopeContext> contexts) {
        return new DefaultImpl((ImList<IScopeContext>)ImCollections.toList(contexts));
    }

    public static PreferenceSetService getPreferenceSetService() {
        ECommonsPreferencesCorePlugin plugin = ECommonsPreferencesCorePlugin.getInstance();
        if (plugin != null) {
            return plugin.getPreferenceSetService();
        }
        return null;
    }

    private EPreferences() {
    }

    private static final class DefaultImpl
    extends PreferenceObjectCache
    implements PreferenceAccess,
    PreferenceObjectAccess {
        private final ImList<IScopeContext> contexts;

        private DefaultImpl(ImList<IScopeContext> contexts) {
            this.contexts = contexts;
        }

        @Override
        public PreferenceAccess getPrefs() {
            return this;
        }

        @Override
        public ImList<IScopeContext> getPreferenceContexts() {
            return this.contexts;
        }

        @Override
        public <T> T getPreferenceValue(Preference<T> pref) {
            return PreferenceUtils.getPrefValue(this.contexts, pref);
        }

        @Override
        public void addPreferenceNodeListener(String nodeQualifier, IEclipsePreferences.IPreferenceChangeListener listener) {
            int i = 0;
            while (i < this.contexts.size()) {
                IEclipsePreferences node;
                IScopeContext context = (IScopeContext)this.contexts.get(i);
                if (!(context instanceof DefaultScope) && (node = context.getNode(nodeQualifier)) != null) {
                    node.addPreferenceChangeListener(listener);
                }
                ++i;
            }
        }

        @Override
        public void removePreferenceNodeListener(String nodeQualifier, IEclipsePreferences.IPreferenceChangeListener listener) {
            int i = 0;
            while (i < this.contexts.size()) {
                IEclipsePreferences node;
                IScopeContext context = (IScopeContext)this.contexts.get(i);
                if (!(context instanceof DefaultScope) && (node = context.getNode(nodeQualifier)) != null) {
                    node.removePreferenceChangeListener(listener);
                }
                ++i;
            }
        }

        @Override
        public void addPreferenceSetListener(PreferenceSetService.ChangeListener listener, ImSet<String> qualifiers) {
            EPreferences.getPreferenceSetService().addChangeListener(listener, this.getPreferenceContexts(), qualifiers);
        }

        @Override
        public void removePreferenceSetListener(PreferenceSetService.ChangeListener listener) {
            PreferenceSetService service = EPreferences.getPreferenceSetService();
            if (service != null) {
                service.removeChangeListener(listener);
            }
        }
    }

    private static class MapImpl
    implements PreferenceAccess {
        private final Map<Preference<?>, Object> preferencesMap;

        MapImpl(Map<Preference<?>, Object> preferencesMap) {
            this.preferencesMap = preferencesMap;
        }

        @Override
        public ImList<IScopeContext> getPreferenceContexts() {
            return ImCollections.emptyList();
        }

        @Override
        public <T> T getPreferenceValue(Preference<T> pref) {
            return (T)this.preferencesMap.get(pref);
        }

        @Override
        public void addPreferenceNodeListener(String nodeQualifier, IEclipsePreferences.IPreferenceChangeListener listener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removePreferenceNodeListener(String nodeQualifier, IEclipsePreferences.IPreferenceChangeListener listener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addPreferenceSetListener(PreferenceSetService.ChangeListener listener, ImSet<String> qualifiers) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removePreferenceSetListener(PreferenceSetService.ChangeListener listener) {
            throw new UnsupportedOperationException();
        }
    }
}

