/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.tex.core.model.build;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstInfo;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstNode;
import org.eclipse.statet.docmlet.tex.core.model.LtxSourceUnitModelInfo;
import org.eclipse.statet.docmlet.tex.core.model.TexSourceUnit;
import org.eclipse.statet.docmlet.tex.core.project.TexProject;
import org.eclipse.statet.ecommons.preferences.core.EPreferences;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.internal.docmlet.tex.core.builder.TexTaskTagReporter;
import org.eclipse.statet.internal.docmlet.tex.core.model.AstProblemReporter;
import org.eclipse.statet.internal.docmlet.tex.core.model.LtxProblemModelCheck;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.issues.core.IssueRequestor;
import org.eclipse.statet.ltk.issues.core.TaskIssueConfig;

@NonNullByDefault
public class LtxIssueReporter {
    private final AstProblemReporter astVisitor = new AstProblemReporter();
    private final LtxProblemModelCheck modelCheck = new LtxProblemModelCheck();
    private final TexTaskTagReporter taskReporter = new TexTaskTagReporter();
    private @Nullable TaskIssueConfig taskIssueConfig;
    private boolean runProblems;
    private boolean runTasks;

    public void configure(PreferenceAccess prefs, @Nullable TexProject config) {
        this.taskIssueConfig = TaskIssueConfig.getConfig((PreferenceAccess)prefs);
    }

    public void run(TexSourceUnit sourceUnit, LtxSourceUnitModelInfo model, SourceContent content, IssueRequestor requestor, int level) {
        TexAstInfo ast;
        TexAstNode node;
        this.runProblems = requestor.isInterestedInProblems("Ltx");
        this.runTasks = requestor.isInterestedInTasks();
        if (!this.runProblems && !this.runTasks) {
            return;
        }
        TaskIssueConfig taskIssueConfig = this.taskIssueConfig;
        if (taskIssueConfig == null) {
            PreferenceAccess prefs = EPreferences.getContextPrefs((IAdaptable)sourceUnit);
            taskIssueConfig = TaskIssueConfig.getConfig((PreferenceAccess)prefs);
        }
        if (this.runTasks) {
            this.taskReporter.configure(taskIssueConfig);
        }
        TexAstNode texAstNode = node = (ast = model.getAst()).getRoot() instanceof TexAstNode ? (TexAstNode)ast.getRoot() : null;
        if (this.runProblems) {
            if (node != null) {
                this.astVisitor.run(sourceUnit, node, content, requestor);
            }
            this.modelCheck.run(sourceUnit, model, content, requestor);
        }
        if (this.runTasks && node != null) {
            this.taskReporter.run(sourceUnit, node, content, requestor);
        }
    }
}

