/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.commands.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.statet.ecommons.commands.core.HandlerCollection;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public abstract class AbstractHandlerCollection<TRecord extends CommandRecord>
implements HandlerCollection {
    private final Map<String, TRecord> commandRecords = new HashMap<String, TRecord>();
    private boolean isDisposed;

    public TRecord addCommandRecord(String commandId, IHandler2 handler, int flags) {
        if (commandId == null || handler == null) {
            throw new NullPointerException();
        }
        if (this.isDisposed) {
            throw new IllegalStateException();
        }
        TRecord record = this.createCommandRecord(commandId, handler, flags);
        this.commandRecords.put(commandId, record);
        return record;
    }

    protected abstract TRecord createCommandRecord(String var1, IHandler2 var2, int var3);

    protected Collection<TRecord> getCommandRecords() {
        return this.commandRecords.values();
    }

    @Override
    public void add(String commandId, IHandler2 handler, int flags) {
        this.addCommandRecord(commandId, handler, flags);
    }

    @Override
    public void add(String commandId, IHandler2 handler) {
        this.addCommandRecord(commandId, handler, 0);
    }

    @Override
    public @Nullable IHandler2 get(String commandId) {
        CommandRecord record = (CommandRecord)this.commandRecords.get(commandId);
        return record != null ? record.handler : null;
    }

    @Override
    public void update(@Nullable Object evaluationContext) {
        for (CommandRecord record : this.commandRecords.values()) {
            record.handler.setEnabled(evaluationContext);
        }
    }

    @Override
    public void update(@Nullable Object evaluationContext, int flags) {
        for (CommandRecord record : this.commandRecords.values()) {
            if ((record.getFlags() & flags) == 0) continue;
            record.handler.setEnabled(evaluationContext);
        }
    }

    @Override
    public void dispose() {
        for (CommandRecord record : this.commandRecords.values()) {
            record.handler.dispose();
        }
        this.commandRecords.clear();
    }

    public static class CommandRecord {
        final IHandler2 handler;
        private final int flags;

        public CommandRecord(IHandler2 handler, int flags) {
            this.handler = handler;
            this.flags = flags;
        }

        public IHandler2 getHandler() {
            return this.handler;
        }

        public int getFlags() {
            return this.flags;
        }
    }
}

