/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.selection.core;

import java.util.Collection;
import org.eclipse.statet.ecommons.waltable.core.command.AbstractDimPositionsCommand;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRangeList;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerDim;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class SelectDimPositionsCommand
extends AbstractDimPositionsCommand {
    private final int selectionFlags;
    private long orthogonalPosition;
    private long positionToReveal;

    public SelectDimPositionsCommand(LayerDim layerDim, long position, long orthogonalPosition, int selectionFlags) {
        this(layerDim, position, new LRangeList(position), orthogonalPosition, selectionFlags, position);
    }

    public SelectDimPositionsCommand(LayerDim layerDim, long refPosition, Collection<LRange> positions, long orthogonalPosition, int selectionFlags, long positionToReveal) {
        super(layerDim, refPosition, positions);
        this.orthogonalPosition = orthogonalPosition;
        this.selectionFlags = selectionFlags;
        this.positionToReveal = positionToReveal;
    }

    protected SelectDimPositionsCommand(SelectDimPositionsCommand command) {
        super(command);
        this.orthogonalPosition = command.orthogonalPosition;
        this.selectionFlags = command.selectionFlags;
        this.positionToReveal = command.positionToReveal;
    }

    @Override
    public SelectDimPositionsCommand cloneCommand() {
        return new SelectDimPositionsCommand(this);
    }

    @Override
    public boolean convertToTargetLayer(Layer targetLayer) {
        LayerDim layerDim = this.getDim();
        long targetOrthogonalPosition = LayerUtils.convertPosition(layerDim.getLayer().getDim(this.getOrientation().getOrthogonal()), this.orthogonalPosition, this.orthogonalPosition, targetLayer.getDim(this.getOrientation().getOrthogonal()));
        if (targetOrthogonalPosition != Long.MIN_VALUE && super.convertToTargetLayer(targetLayer)) {
            this.orthogonalPosition = targetOrthogonalPosition;
            this.positionToReveal = LayerUtils.convertPosition(layerDim, this.positionToReveal, this.positionToReveal, targetLayer.getDim(this.getOrientation()));
            return true;
        }
        return false;
    }

    public long getOrthogonalPosition() {
        return this.orthogonalPosition;
    }

    public int getSelectionFlags() {
        return this.selectionFlags;
    }

    public long getPositionToReveal() {
        return this.positionToReveal;
    }
}

