/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.templates;

import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.statet.ecommons.preferences.ui.SettingsUpdater;
import org.eclipse.statet.ecommons.templates.TemplateVariableProcessor;
import org.eclipse.statet.ecommons.text.ui.TextViewerJFaceUpdater;
import org.eclipse.statet.ecommons.ui.ISettingsChangedHandler;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.ltk.ui.PreviewSourceViewer;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfigurator;
import org.eclipse.statet.ltk.ui.sourceediting.ViewerSourceEditorAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.text.templates.ContextTypeRegistry;
import org.eclipse.ui.editors.text.EditorsUI;

public class TemplatePreview {
    private final TemplateVariableProcessor templateProcessor = new TemplateVariableProcessor();
    private SourceViewer viewer;
    private TextViewerJFaceUpdater viewerUpdater = null;
    private SourceEditorViewerConfigurator configurator;
    private SourceEditor editor;

    public TemplateVariableProcessor getTemplateVariableProcessor() {
        return this.templateProcessor;
    }

    public SourceViewer createSourceViewer(Composite parent) {
        PreviewSourceViewer viewer = new PreviewSourceViewer(parent, false, EditorsUI.getPreferenceStore());
        Document document = new Document();
        viewer.setDocument((IDocument)document);
        new SettingsUpdater(new ISettingsChangedHandler(){

            public void handleSettingsChanged(Set<String> groupIds, Map<String, Object> options) {
                if (TemplatePreview.this.configurator != null) {
                    TemplatePreview.this.configurator.handleSettingsChanged(groupIds, options);
                }
            }
        }, viewer.getControl());
        this.viewer = viewer;
        return this.viewer;
    }

    public void updateSourceViewerInput(Template template, ContextTypeRegistry contextRegistry, SourceEditorViewerConfigurator patternConfigurator) {
        if (this.viewer == null || !UIAccess.isOkToUse((Control)this.viewer.getControl())) {
            return;
        }
        if (template != null) {
            TemplateContextType type = contextRegistry.getContextType(template.getContextTypeId());
            this.templateProcessor.setContextType(type);
            if (patternConfigurator != null && patternConfigurator != this.configurator) {
                if (this.viewerUpdater != null) {
                    this.viewerUpdater.dispose();
                    this.viewerUpdater = null;
                }
                if (this.configurator != null) {
                    this.configurator.unconfigureTarget();
                    this.configurator = null;
                }
                this.configurator = patternConfigurator;
                this.editor = new ViewerSourceEditorAdapter(this.viewer, this.configurator);
                this.configurator.setTarget(this.editor);
                this.viewerUpdater = new TextViewerJFaceUpdater((ISourceViewer)this.viewer, this.configurator.getSourceViewerConfiguration().getPreferences());
                Document document = new Document(template.getPattern());
                this.configurator.getDocumentSetupParticipant().setup((IDocument)document);
                this.viewer.setDocument((IDocument)document);
            } else {
                this.viewer.getDocument().set(template.getPattern());
            }
        } else {
            this.viewer.getDocument().set("");
        }
    }
}

