/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.mpbv;

import java.net.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.statet.ecommons.collections.IntArrayMap;
import org.eclipse.statet.ecommons.ui.mpbv.PageBookSession;
import org.eclipse.statet.jcommons.collections.ImCollection;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class BrowserSession
implements PageBookSession {
    private boolean bound;
    private String url;
    private String title;
    private @Nullable ImageDescriptor imageDescriptor;
    private @Nullable IntArrayMap<String> staticContent;

    public static final @Nullable BrowserSession findSessionByUrl(ImCollection<BrowserSession> sessions, String url) {
        for (BrowserSession session : sessions) {
            if (!url.equals(session.getUrl())) continue;
            return session;
        }
        return null;
    }

    public static final @Nullable BrowserSession findSessionByUrl(ImCollection<BrowserSession> sessions, URI url) {
        return BrowserSession.findSessionByUrl(sessions, url.toString());
    }

    public static final @Nullable BrowserSession findSessionById(ImCollection<BrowserSession> sessions, Object id) {
        for (BrowserSession session : sessions) {
            if (!id.equals(session.getId())) continue;
            return session;
        }
        return null;
    }

    public BrowserSession(String initialUrl) {
        this.url = initialUrl;
        this.title = "";
        this.imageDescriptor = null;
    }

    public BrowserSession() {
        this("");
    }

    public @Nullable Object getId() {
        return null;
    }

    void bind() {
        if (this.bound) {
            throw new IllegalArgumentException("Session is already bound");
        }
        this.bound = true;
    }

    void unbind() {
        this.bound = false;
    }

    public boolean isBound() {
        return this.bound;
    }

    void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public String getViewUrl() {
        if (this.url.equals("about:blank")) {
            return "";
        }
        return this.url;
    }

    void setTitle(String title) {
        this.title = title;
    }

    String getTitle() {
        return this.title;
    }

    @Override
    public String getLabel() {
        return this.title;
    }

    void setImageDescriptor(@Nullable ImageDescriptor imageDescriptor) {
        this.imageDescriptor = imageDescriptor;
    }

    @Override
    public @Nullable ImageDescriptor getImageDescriptor() {
        return this.imageDescriptor;
    }

    int putStatic(String html) {
        IntArrayMap staticContent = this.staticContent;
        if (staticContent == null) {
            this.staticContent = staticContent = new IntArrayMap();
        }
        int id = staticContent.size();
        staticContent.put(id, (Object)html);
        return id;
    }

    @Nullable String getStatic(int id) {
        IntArrayMap<String> staticContent = this.staticContent;
        if (staticContent == null) {
            return null;
        }
        return (String)staticContent.get(id);
    }
}

