/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.core.model;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.statet.docmlet.tex.core.ast.Comment;
import org.eclipse.statet.docmlet.tex.core.ast.ControlNode;
import org.eclipse.statet.docmlet.tex.core.ast.Dummy;
import org.eclipse.statet.docmlet.tex.core.ast.Embedded;
import org.eclipse.statet.docmlet.tex.core.ast.Environment;
import org.eclipse.statet.docmlet.tex.core.ast.Group;
import org.eclipse.statet.docmlet.tex.core.ast.Label;
import org.eclipse.statet.docmlet.tex.core.ast.Math;
import org.eclipse.statet.docmlet.tex.core.ast.SourceComponent;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstNode;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstVisitor;
import org.eclipse.statet.docmlet.tex.core.ast.Text;
import org.eclipse.statet.docmlet.tex.core.ast.Verbatim;
import org.eclipse.statet.docmlet.tex.core.model.TexSourceUnit;
import org.eclipse.statet.internal.docmlet.tex.core.model.ProblemMessages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.model.core.AttachmentsElement;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.util.AbstractAstProblemReporter;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.core.source.StatusDetail;
import org.eclipse.statet.ltk.issues.core.IssueRequestor;

@NonNullByDefault
public class AstProblemReporter
extends AbstractAstProblemReporter {
    private static final int ENV_LABEL_LIMIT = 20;
    private final Visitor visitor = new Visitor();

    public AstProblemReporter() {
        super("Ltx");
    }

    public void run(TexSourceUnit sourceUnit, TexAstNode node, SourceContent content, IssueRequestor requestor) {
        try {
            try {
                this.init(content, requestor);
                node.acceptInTex(this.visitor);
                this.flush();
            }
            catch (InvocationTargetException invocationTargetException) {
                this.clear();
            }
        }
        finally {
            this.clear();
        }
    }

    protected void handleCommonCodes(TexAstNode node, int code) throws BadLocationException, InvocationTargetException {
        super.handleCommonCodes((AstNode)node, code);
    }

    protected static final @Nullable String limit(@Nullable String label, int limit) {
        if (label != null && label.length() > limit) {
            return String.valueOf(label.substring(0, limit)) + '\u2026';
        }
        return label;
    }

    private class Visitor
    extends TexAstVisitor {
        private Visitor() {
        }

        @Override
        public void visit(SourceComponent node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    AstProblemReporter.this.handleCommonCodes(node, code);
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInTexChildren(this);
        }

        @Override
        public void visit(Group node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    switch (code & 0x700FFF) {
                        case 4195650: {
                            if (node.getParent() instanceof ControlNode) {
                                AstProblemReporter.this.addProblem(2, code, node.getText() == "{" ? ProblemMessages.Ast_ReqArgument_NotClosed_message : ProblemMessages.Ast_OptArgument_NotClosed_Opt_message, node.getStartOffset(), node.getStartOffset() + 1);
                                break;
                            }
                            AstProblemReporter.this.addProblem(2, code, node.getText() == "{" ? ProblemMessages.Ast_CurlyBracket_NotClosed_message : ProblemMessages.Ast_SquareBracket_NotClosed_message, node.getStartOffset(), node.getStartOffset() + 1);
                            break;
                        }
                        default: {
                            AstProblemReporter.this.handleCommonCodes(node, code);
                            break;
                        }
                    }
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInTexChildren(this);
        }

        @Override
        public void visit(Environment node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    switch (code & 0x700FFF) {
                        case 4195602: {
                            ControlNode beginNode = node.getBeginNode();
                            AstProblemReporter.this.addProblem(2, code, AstProblemReporter.this.getMessageBuilder().bind(ProblemMessages.Ast_Env_NotClosed_message, (Object)AstProblemReporter.limit(node.getText(), 20)), beginNode.getStartOffset(), beginNode.getEndOffset());
                            break;
                        }
                        case 4195634: {
                            ControlNode beginNode = node.getBeginNode();
                            String c = node.getText();
                            c = c == "[" ? "\\]" : (c == "(" ? "\\)" : null);
                            if (c != null) {
                                AstProblemReporter.this.addProblem(2, code, AstProblemReporter.this.getMessageBuilder().bind(ProblemMessages.Ast_Math_NotClosed_message, (Object)c), beginNode.getStartOffset(), beginNode.getEndOffset());
                            }
                            break;
                        }
                        default: {
                            AstProblemReporter.this.handleCommonCodes(node, code);
                            break;
                        }
                    }
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInTexChildren(this);
        }

        @Override
        public void visit(ControlNode node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    switch (code & 0x700FFF) {
                        case 4195603: {
                            AstProblemReporter.this.addProblem(2, code, node.getText().equals("begin") ? ProblemMessages.Ast_Env_MissingName_Begin_message : ProblemMessages.Ast_Env_MissingName_End_message, node.getStartOffset(), node.getEndOffset());
                            break;
                        }
                        case 4195601: {
                            AstProblemReporter.this.addProblem(2, code, AstProblemReporter.this.getMessageBuilder().bind(ProblemMessages.Ast_Env_NotOpened_message, (Object)AstProblemReporter.limit(node.getChild(0).getChild(0).getText(), 20)), node.getStartOffset(), node.getEndOffset());
                            break;
                        }
                        case 4195617: {
                            AstProblemReporter.this.addProblem(2, code, ProblemMessages.Ast_Verbatim_MissingSep_message, node.getEndOffset() - 1, node.getEndOffset());
                            break;
                        }
                        default: {
                            AstProblemReporter.this.handleCommonCodes(node, code);
                            break;
                        }
                    }
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInTexChildren(this);
        }

        @Override
        public void visit(Text node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    AstProblemReporter.this.handleCommonCodes(node, code);
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }

        @Override
        public void visit(Label node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    AstProblemReporter.this.handleCommonCodes(node, code);
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }

        @Override
        public void visit(Math node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    switch (code & 0x700FFF) {
                        case 4195634: {
                            AstProblemReporter.this.addProblem(2, code, AstProblemReporter.this.getMessageBuilder().bind(ProblemMessages.Ast_Math_NotClosed_message, (Object)node.getText()), node.getStartOffset(), node.getStartOffset() + node.getText().length());
                            break;
                        }
                        default: {
                            AstProblemReporter.this.handleCommonCodes(node, code);
                            break;
                        }
                    }
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInTexChildren(this);
        }

        @Override
        public void visit(Verbatim node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    switch (code & 0x700FFF) {
                        case 4195618: {
                            AstProblemReporter.this.addProblem(2, code, AstProblemReporter.this.getMessageBuilder().bind(ProblemMessages.Ast_Verbatim_NotClosed_message, (Object)StatusDetail.getStatusDetail((AttachmentsElement)node).getText()), node.getEndOffset() - 1, node.getEndOffset());
                            break;
                        }
                        default: {
                            AstProblemReporter.this.handleCommonCodes(node, code);
                            break;
                        }
                    }
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }

        @Override
        public void visit(Comment node) throws InvocationTargetException {
        }

        @Override
        public void visit(Dummy node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    switch (code & 0x700FFF) {
                        case 4195649: {
                            AstProblemReporter.this.addProblem(2, code, node.getText() == "{" ? ProblemMessages.Ast_CurlyBracket_NotOpened_message : ProblemMessages.Ast_SquareBracket_NotOpened_message, node.getStartOffset(), node.getStartOffset() + 1);
                            break;
                        }
                        default: {
                            AstProblemReporter.this.handleCommonCodes(node, code);
                            break;
                        }
                    }
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
            node.acceptInTexChildren(this);
        }

        @Override
        public void visit(Embedded node) throws InvocationTargetException {
            int code = node.getStatusCode() & 0xFFFFFF;
            if (AstProblemReporter.this.requiredCheck(code)) {
                try {
                    AstProblemReporter.this.handleCommonCodes(node, code);
                }
                catch (BadLocationException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }
    }
}

