/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.ui.actions;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.status.eplatform.EStatusUtils;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolProvider;
import org.eclipse.statet.nico.core.runtime.IRemoteEngineController;
import org.eclipse.statet.nico.core.runtime.ToolController;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.NicoUITools;
import org.eclipse.statet.nico.ui.actions.AbstractToolHandler;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public class DisconnectEngineHandler
extends AbstractToolHandler<ToolProcess> {
    public DisconnectEngineHandler(ToolProvider toolProvider, IServiceLocator serviceLocator) {
        super(null, "org.eclipse.statet.nico/remote", toolProvider, serviceLocator);
        this.init();
    }

    @Override
    protected @Nullable Object execute(ToolProcess tool, ExecutionEvent event) {
        ToolController controller;
        try {
            controller = NicoUITools.accessController(null, (Tool)tool);
        }
        catch (CoreException e) {
            StatusManager.getManager().handle(e.getStatus(), 3);
            return null;
        }
        IServiceLocator serviceLocator = this.getServiceLocator(event.getApplicationContext());
        IProgressService progressService = (IProgressService)ObjectUtils.nonNullAssert((Object)((IProgressService)serviceLocator.getService(IProgressService.class)));
        DisconnectJob job = new DisconnectJob(tool, controller);
        job.schedule();
        progressService.showInDialog(WorkbenchUIUtils.getShell((Object)event.getApplicationContext()), (Job)job);
        return null;
    }

    private static class DisconnectJob
    extends Job {
        private final ToolController controller;

        DisconnectJob(ToolProcess process, ToolController controller) {
            super(NLS.bind((String)"Disconnect {0}", (Object)process.getLabel(0)));
            this.setUser(true);
            this.setPriority(10);
            this.controller = controller;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                ((IRemoteEngineController)this.controller).disconnect(EStatusUtils.convert((IProgressMonitor)monitor));
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            catch (StatusException e) {
                IStatus iStatus = EStatusUtils.convert((org.eclipse.statet.jcommons.status.Status)e.getStatus());
                return iStatus;
            }
            finally {
                monitor.done();
            }
        }
    }
}

