/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.pkgmanager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.core.PreferenceSetService;
import org.eclipse.statet.ecommons.preferences.core.util.PreferenceUtils;
import org.eclipse.statet.ecommons.runtime.core.util.StatusUtils;
import org.eclipse.statet.internal.r.core.RCorePlugin;
import org.eclipse.statet.internal.r.core.pkgmanager.Cache;
import org.eclipse.statet.internal.r.core.pkgmanager.Change;
import org.eclipse.statet.internal.r.core.pkgmanager.DB;
import org.eclipse.statet.internal.r.core.pkgmanager.FullRPkgSet;
import org.eclipse.statet.internal.r.core.pkgmanager.REnvLibGroups;
import org.eclipse.statet.internal.r.core.pkgmanager.RPkgData;
import org.eclipse.statet.internal.r.core.pkgmanager.RPkgInfoAndData;
import org.eclipse.statet.internal.r.core.pkgmanager.RPkgOperator;
import org.eclipse.statet.internal.r.core.pkgmanager.RPkgScanner;
import org.eclipse.statet.internal.r.core.pkgmanager.RPkgSet;
import org.eclipse.statet.internal.r.core.pkgmanager.RRepoListPref;
import org.eclipse.statet.internal.r.core.pkgmanager.RRepoPref;
import org.eclipse.statet.internal.r.core.pkgmanager.RVarRepo;
import org.eclipse.statet.internal.r.core.pkgmanager.RView;
import org.eclipse.statet.internal.r.core.pkgmanager.RViewTasks;
import org.eclipse.statet.internal.r.core.pkgmanager.Util;
import org.eclipse.statet.internal.r.core.renv.REnvConfigurationImpl;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentitySet;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.r.core.pkgmanager.IRPkgData;
import org.eclipse.statet.r.core.pkgmanager.IRPkgInfo;
import org.eclipse.statet.r.core.pkgmanager.IRPkgInfoAndData;
import org.eclipse.statet.r.core.pkgmanager.IRPkgManager;
import org.eclipse.statet.r.core.pkgmanager.IRPkgSet;
import org.eclipse.statet.r.core.pkgmanager.IRView;
import org.eclipse.statet.r.core.pkgmanager.ISelectedRepos;
import org.eclipse.statet.r.core.pkgmanager.RPkgAction;
import org.eclipse.statet.r.core.pkgmanager.RPkgUtils;
import org.eclipse.statet.r.core.pkgmanager.RRepo;
import org.eclipse.statet.r.core.pkgmanager.RRepoMirror;
import org.eclipse.statet.r.core.pkgmanager.SelectedRepos;
import org.eclipse.statet.r.core.renv.IREnvConfiguration;
import org.eclipse.statet.r.core.tool.AbstractStatetRRunnable;
import org.eclipse.statet.r.core.tool.IRConsoleService;
import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.statet.rj.data.RDataFrame;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RLogicalStore;
import org.eclipse.statet.rj.data.RNumericStore;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.RVector;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.data.impl.RCharacter32Store;
import org.eclipse.statet.rj.data.impl.RVectorImpl;
import org.eclipse.statet.rj.renv.core.BasicRPkgCompilation;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.core.REnvConfiguration;
import org.eclipse.statet.rj.renv.core.RLibGroup;
import org.eclipse.statet.rj.renv.core.RLibPaths;
import org.eclipse.statet.rj.renv.core.RNumVersion;
import org.eclipse.statet.rj.renv.core.RPkg;
import org.eclipse.statet.rj.renv.core.RPkgCompilation;
import org.eclipse.statet.rj.renv.core.RPkgType;
import org.eclipse.statet.rj.renv.runtime.RPkgManager;
import org.eclipse.statet.rj.renv.runtime.RuntimeRLibPaths;
import org.eclipse.statet.rj.renv.runtime.RuntimeRLibPathsLoader;
import org.eclipse.statet.rj.server.util.ServerUtils;
import org.eclipse.statet.rj.services.FunctionCall;
import org.eclipse.statet.rj.services.RPlatform;
import org.eclipse.statet.rj.services.RService;
import org.eclipse.statet.rj.ts.core.AbstractRToolRunnable;
import org.eclipse.statet.rj.ts.core.RToolService;
import org.osgi.service.prefs.BackingStoreException;

public class RPkgManagerImpl
implements IRPkgManager.Ext,
PreferenceSetService.ChangeListener {
    private static final int REQUIRE_CRAN = 0x10000000;
    private static final int REQUIRE_BIOC = 0x20000000;
    private static final int REQUIRE_REPOS = Integer.MIN_VALUE;
    private static final int REQUIRE_REPO_PKGS = 0x1000000;
    private static final int REQUIRE_INST_PKGS = 0x8000000;
    private static final ImIdentitySet<String> PREF_QUALIFIERS = ImCollections.newIdentitySet((Object)"org.eclipse.statet.r.core/r.pkgmanager");
    private static final RRepoPref LAST_CRAN_PREF = new RRepoPref("org.eclipse.statet.r.core/r.pkgmanager", "LastCRAN.repo");
    private static final RRepoPref LAST_BIOC_PREF = new RRepoPref("org.eclipse.statet.r.core/r.pkgmanager", "LastBioC.repo");
    private static final int MIRROR_CHECK = 21600000;
    private static final int PKG_CHECK = 10800000;
    private final REnv rEnv;
    private RPlatform rPlatform;
    private final PreferenceAccess prefAccess;
    private final IFileStore rEnvDirectory;
    private boolean firstTime;
    private String bioCVersion;
    private final Preference.NullableStringPref bioCVersionPref;
    private List<RRepo> customRepos;
    private final List<RRepo> addRepos;
    private List<RRepo> rRepos;
    private List<RRepo> allRepos;
    private List<RRepo> selectedReposInR;
    private final RRepoListPref selectedReposPref;
    private List<RRepo> customCRAN;
    private List<RRepoMirror> rCRANMirrors;
    private ImList<RRepo> allCRAN;
    private String selectedCRANInR;
    private final RRepoPref selectedCRANPref;
    private List<RRepo> customBioC;
    private List<RRepoMirror> rBioCMirrors;
    private ImList<RRepo> allBioC;
    private String selectedBioCInR;
    private final RRepoPref selectedBioCPref;
    private long mirrorsStamp;
    private SelectedRepos selectedRepos;
    private RVector<RNumericStore> libs = null;
    private RuntimeRLibPathsLoader rLibGroups;
    private RuntimeRLibPaths rLibPaths;
    private RPkgSet dataset;
    private FullRPkgSet datasetExt;
    private long pkgsStamp;
    final RPkgScanner pkgScanner = new RPkgScanner();
    private int requested;
    private volatile int requireLoad;
    private volatile int requireConfirm;
    private final CopyOnWriteIdentityListSet<IRPkgManager.Listener> listeners = new CopyOnWriteIdentityListSet();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private List<RView> rViews;
    private RNumVersion rViewsVersion;
    private Tool rProcess;
    private int rTask;
    private Change rTaskEvent;
    private final DB db;
    private final Cache cache;

    public RPkgManagerImpl(IREnvConfiguration config) {
        this.rEnv = config.getREnv();
        this.rEnvDirectory = EFS.getLocalFileSystem().getStore(REnvConfigurationImpl.getStateLocation(this.rEnv));
        String qualifier = config.getPrefNodeQualifier();
        this.selectedReposPref = new RRepoListPref(qualifier, "RPkg.Repos.repos");
        this.selectedCRANPref = new RRepoPref(qualifier, "RPkg.CRANMirror.repo");
        this.bioCVersionPref = new Preference.NullableStringPref(qualifier, "RPkg.BioCVersion.ver");
        this.selectedBioCPref = new RRepoPref(qualifier, "RPkg.BioCMirror.repo");
        this.prefAccess = PreferenceUtils.getInstancePrefs();
        this.addRepos = new ArrayList<RRepo>();
        if (config.getType() == "user-local") {
            String rjVersion = "" + ServerUtils.RJ_VERSION[0] + '.' + ServerUtils.RJ_VERSION[1];
            this.addRepos.add(new RRepo("special-rj", "RJ", "http://download.walware.de/rj-" + rjVersion, null));
        }
        this.selectedRepos = new SelectedRepos((List)this.prefAccess.getPreferenceValue((Preference)this.selectedReposPref), (RRepo)this.prefAccess.getPreferenceValue((Preference)this.selectedCRANPref), (String)this.prefAccess.getPreferenceValue((Preference)this.bioCVersionPref), (RRepo)this.prefAccess.getPreferenceValue((Preference)this.selectedBioCPref));
        this.db = DB.create(this.rEnv, this.rEnvDirectory);
        this.cache = new Cache(this.rEnvDirectory);
        this.resetPkgs(config);
        this.firstTime = true;
        this.mirrorsStamp = this.pkgsStamp = System.currentTimeMillis();
        this.requireLoad |= 0xB0000000;
        this.requireLoad |= 0x9000000;
        this.prefAccess.addPreferenceSetListener((PreferenceSetService.ChangeListener)this, PREF_QUALIFIERS);
        this.getWriteLock().lock();
        try {
            this.loadPrefs(true);
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    private void resetPkgs(REnvConfiguration rEnvConfig) {
        this.datasetExt = null;
        this.dataset = this.db != null && rEnvConfig != null ? new RPkgSet(this.rEnv, (RLibPaths)rEnvConfig, (RPkgCompilation<IRPkgInfo>)this.db.loadInstalled((List<? extends RLibGroup>)rEnvConfig.getRLibGroups())) : null;
    }

    public REnv getREnv() {
        return this.rEnv;
    }

    Cache getCache() {
        return this.cache;
    }

    @Override
    public RPlatform getRPlatform() {
        return this.rPlatform;
    }

    @Override
    public Lock getReadLock() {
        return this.lock.readLock();
    }

    @Override
    public Lock getWriteLock() {
        return this.lock.writeLock();
    }

    public void preferenceChanged(PreferenceSetService.ChangeEvent event) {
        if (event.contains("org.eclipse.statet.r.core/r.pkgmanager") && (event.contains(CUSTOM_REPO_PREF) || event.contains(CUSTOM_CRAN_MIRROR_PREF) || event.contains(CUSTOM_BIOC_MIRROR_PREF))) {
            this.loadPrefs(true);
        }
    }

    public void dispose() {
        this.prefAccess.removePreferenceSetListener((PreferenceSetService.ChangeListener)this);
    }

    public void check(int flags, RService r, ProgressMonitor m) throws StatusException {
        this.checkInit(flags, r, m);
        this.check(r, m);
    }

    protected int checkRequest(int request) {
        request = RPkgManager.expandFlags((int)request);
        request = this.checkAutoRefresh(request);
        return request;
    }

    private int checkAutoRefresh(int request) {
        long stamp = System.currentTimeMillis();
        if ((request & 0x10) != 0 && Math.abs(this.mirrorsStamp - stamp) > 21600000L) {
            request |= 0x4000;
        }
        if ((request & 0x20) != 0 && Math.abs(this.pkgsStamp - stamp) > 10800000L) {
            request |= 0x8000;
        }
        return request;
    }

    public int request(int request) {
        Status status;
        request = this.checkRequest(request);
        this.getWriteLock().lock();
        try {
            this.requested |= request;
        }
        finally {
            this.getWriteLock().unlock();
        }
        IRPkgSet dataset = this.getDataset();
        if (dataset != null && (dataset.getProviding() & request) == request) {
            return 0;
        }
        if ((request & 0x4020) == 32 && dataset != null && (dataset.getProviding() & 0x10) != 0 && (status = this.getReposStatus(null)).getSeverity() > 1) {
            return 1;
        }
        return 2;
    }

    private void checkInit(int flags, RService r, ProgressMonitor m) throws StatusException {
        if ((flags & 0x100000) == 0x100000 || this.rPlatform == null) {
            this.checkRVersion(r.getPlatform());
            REnvConfiguration rEnvConfig = (REnvConfiguration)this.rEnv.get(REnvConfiguration.class);
            if (rEnvConfig != null && rEnvConfig.isRemote()) {
                this.rLibGroups = REnvLibGroups.loadFromR(r, m);
            }
        }
    }

    private void check(RService r, ProgressMonitor m) throws StatusException {
        if (!this.beginRTaskSilent((RToolService)r, m)) {
            return;
        }
        try {
            try {
                this.checkInstalled(false, null, r, m);
                if (this.rTaskEvent != null) {
                    this.fireUpdate(this.rTaskEvent);
                }
            }
            catch (Exception e) {
                throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.r.core", "An error occurred when checking for new and updated R packages.", (Throwable)e));
            }
        }
        finally {
            this.rTaskEvent = null;
            this.endRTask();
        }
    }

    private void checkRVersion(RPlatform rPlatform) {
        if (this.rPlatform != null && !this.rPlatform.getRVersion().equals((Object)rPlatform.getRVersion())) {
            this.getWriteLock().lock();
            try {
                this.requireLoad |= 0xB0000000;
                this.requireLoad |= 0x9000000;
            }
            finally {
                this.getWriteLock().unlock();
            }
        }
        this.rPlatform = rPlatform;
    }

    private void updateRequireLoad() {
        this.getWriteLock().lock();
        try {
            int requested = this.checkAutoRefresh(this.requested);
            if ((requested & 0x200000) != 0) {
                this.selectedRepos = new SelectedRepos(Collections.emptyList(), null, null, null);
                this.savePrefs(this.selectedRepos);
                this.requireLoad |= 0xB0000000;
                Change change = new Change(this.rEnv);
                change.repos = 1;
                this.checkRepos(change);
                this.requireLoad |= 0x9000000;
                REnvConfiguration rEnvConfig = (REnvConfiguration)this.rEnv.get(REnvConfiguration.class);
                this.resetPkgs(rEnvConfig);
                this.firstTime = true;
            } else {
                if ((requested & 0x400) != 0) {
                    this.requireLoad = 0x8000000;
                }
                if ((requested & 0x4000) != 0) {
                    this.requireLoad |= 0x30000000;
                }
                if ((requested & 0x8000) != 0) {
                    this.requireLoad |= 0x1000000;
                }
            }
            this.requested &= 0x31;
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    @Override
    public Status getReposStatus(ISelectedRepos repos) {
        SelectedRepos current = this.selectedRepos;
        int confirm = this.requireConfirm;
        return this.getReposStatus(repos != null ? repos : current, current, confirm);
    }

    private Status getReposStatus(ISelectedRepos repos, ISelectedRepos current, int confirm) {
        if (repos.getRepos().isEmpty()) {
            return RPkgManagerImpl.createStatus(4, "No repository is selected. Select the repositories where to install R packages from.");
        }
        boolean requireCRAN = RVarRepo.requireCRANMirror(repos.getRepos());
        if (requireCRAN && repos.getCRANMirror() == null) {
            return RPkgManagerImpl.createStatus(4, "No CRAN mirror is selected. Selected a mirror for CRAN.");
        }
        boolean requireBioC = RVarRepo.requireBioCMirror(repos.getRepos());
        if (requireBioC && repos.getBioCMirror() == null) {
            return RPkgManagerImpl.createStatus(4, "No BioC mirror is selected. Selected a mirror for Bioconductor.");
        }
        if (requireCRAN && (confirm & 0x10000000) != 0 || requireBioC && (confirm & 0x20000000) != 0 || repos != current && !repos.equals(current)) {
            return RPkgManagerImpl.createStatus(1, "Check the repository settings and confirm with 'Apply' to show the available R packages.");
        }
        return Status.OK_STATUS;
    }

    private static Status createStatus(int severity, String message) {
        return Status.newStatus((int)severity, (String)"org.eclipse.statet.r.core", (String)message);
    }

    public void update(RService r, ProgressMonitor m) throws StatusException {
        this.beginRTask((RToolService)r, m);
        try {
            this.checkInit(0, r, m);
            this.rTaskEvent = new Change(this.rEnv);
            ISelectedRepos settings = this.runLoadRepos(r, m);
            if (settings != null) {
                this.runApplyRepo(settings, r, m);
            }
            this.runLoadPkgs(settings, r, m);
            this.fireUpdate(this.rTaskEvent);
        }
        finally {
            this.rTaskEvent = null;
            this.endRTask();
        }
    }

    private void checkMirrors(Change event) {
        if ((this.requireLoad & 0x30000000) != 0) {
            return;
        }
        SelectedRepos selected = this.selectedRepos;
        this.allCRAN = ImCollections.concatList(this.customCRAN, this.rCRANMirrors);
        RRepo selectedCRAN = selected.getCRANMirror();
        if (selected.getCRANMirror() != null) {
            selectedCRAN = Util.findRepo(this.allCRAN, selectedCRAN);
        } else if (this.firstTime && this.selectedCRANInR != null) {
            selectedCRAN = Util.getRepoByURL(this.allCRAN, this.selectedCRANInR);
        }
        if (selectedCRAN == null) {
            this.requireConfirm |= 0x10000000;
            selectedCRAN = (RRepo)this.prefAccess.getPreferenceValue((Preference)LAST_CRAN_PREF);
            if (selectedCRAN != null) {
                selectedCRAN = Util.findRepo(this.allCRAN, selectedCRAN);
            }
            if (!(this.customCRAN.isEmpty() || selectedCRAN != null && selectedCRAN.getId().startsWith("custom-"))) {
                selectedCRAN = this.customCRAN.get(0);
            }
            if (this.firstTime && selectedCRAN == null && !this.rCRANMirrors.isEmpty()) {
                selectedCRAN = this.getRegionMirror(this.rCRANMirrors);
            }
        }
        RRepo selectedBioC = selected.getBioCMirror();
        this.allBioC = ImCollections.concatList(this.customBioC, this.rBioCMirrors);
        if (selectedBioC != null) {
            selectedBioC = Util.findRepo(this.allBioC, selectedBioC);
        } else if (this.firstTime && this.selectedBioCInR != null) {
            selectedBioC = RPkgUtils.getRepoByURL(this.allBioC, this.selectedBioCInR);
        }
        if (selectedBioC == null) {
            this.requireConfirm |= 0x20000000;
            selectedBioC = (RRepo)this.prefAccess.getPreferenceValue((Preference)LAST_BIOC_PREF);
            if (!(this.customBioC.isEmpty() || selectedBioC != null && selectedBioC.getId().startsWith("custom-"))) {
                selectedBioC = this.customBioC.get(0);
            }
            if (this.firstTime && selectedBioC == null && !this.rBioCMirrors.isEmpty() && (selectedBioC = this.getRegionMirror(this.rBioCMirrors)) == null) {
                selectedBioC = this.rBioCMirrors.get(0);
            }
        }
        selected = new SelectedRepos((List<RRepo>)selected.getRepos(), selectedCRAN, this.bioCVersion, selectedBioC);
        if ((this.requireLoad & Integer.MIN_VALUE) == 0) {
            for (RRepo repo : this.allRepos) {
                if (!(repo instanceof RVarRepo)) continue;
                ((RVarRepo)repo).updateURL(selected);
            }
        }
        this.selectedRepos = selected;
        event.pkgs = 1;
    }

    private void checkRepos(Change event) {
        if ((this.requireLoad & 0xB0000000) != 0) {
            return;
        }
        SelectedRepos selected = this.selectedRepos;
        this.allRepos = new ArrayList<RRepo>(this.customRepos.size() + this.addRepos.size() + this.rRepos.size());
        this.allRepos.addAll(this.customRepos);
        this.allRepos.addAll(this.addRepos);
        for (RRepo repo : this.allRepos) {
            if (!(repo instanceof RVarRepo)) continue;
            ((RVarRepo)repo).updateURL(selected);
        }
        for (RRepo repo : this.rRepos) {
            if (!(repo instanceof RVarRepo)) continue;
            ((RVarRepo)repo).updateURL(selected);
        }
        for (RRepo repo : this.rRepos) {
            if (!repo.getId().isEmpty()) {
                if (RPkgUtils.getRepoById(this.allRepos, repo.getId()) != null) continue;
                this.allRepos.add(repo);
                continue;
            }
            if (Util.getRepoByURL(this.allRepos, repo) != null) continue;
            this.allRepos.add(RVarRepo.create("r-" + repo.getURL(), repo.getName(), repo.getURL(), null));
        }
        List<RRepo> selectedRepos = selected.getRepos();
        List<RRepo> previous = this.firstTime && selectedRepos.isEmpty() ? this.selectedReposInR : selectedRepos;
        ArrayList<RRepo> repos = new ArrayList<RRepo>(previous.size());
        for (RRepo repo : previous) {
            if ((repo = Util.findRepo(this.allRepos, repo)) == null) continue;
            repos.add(repo);
        }
        this.selectedRepos = selected = new SelectedRepos(repos, selected.getCRANMirror(), selected.getBioCVersion(), selected.getBioCMirror());
        this.requireLoad |= 0x1000000;
        event.repos = 1;
    }

    private void loadPrefs(boolean custom) {
        Change event = new Change(this.rEnv);
        PreferenceAccess prefs = PreferenceUtils.getInstancePrefs();
        this.getWriteLock().lock();
        try {
            if (custom) {
                this.customRepos = (List)prefs.getPreferenceValue(CUSTOM_REPO_PREF);
                this.customCRAN = (List)prefs.getPreferenceValue(CUSTOM_CRAN_MIRROR_PREF);
                this.customBioC = (List)prefs.getPreferenceValue(CUSTOM_BIOC_MIRROR_PREF);
                this.checkRepos(event);
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
        this.fireUpdate(event);
    }

    @Override
    public void addListener(IRPkgManager.Listener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeListener(IRPkgManager.Listener listener) {
        this.listeners.remove((Object)listener);
    }

    private void fireUpdate(IRPkgManager.Event event) {
        for (IRPkgManager.Listener listener : this.listeners) {
            listener.handleChange(event);
        }
    }

    @Override
    public List<RRepo> getAvailableRepos() {
        return this.allRepos;
    }

    @Override
    public ISelectedRepos getSelectedRepos() {
        return this.selectedRepos;
    }

    @Override
    public void setSelectedRepos(ISelectedRepos repos) {
        RRepo repo2;
        Collection<RRepo> selected = repos.getRepos();
        ArrayList<RRepo> selectedRepos = new ArrayList<RRepo>(selected.size());
        for (RRepo repo2 : this.allRepos) {
            if (!selected.contains(repo2)) continue;
            selectedRepos.add(repo2);
        }
        repo2 = repos.getCRANMirror();
        RRepo selectedCRAN = repo2 != null ? Util.findRepo(this.allCRAN, repo2) : null;
        this.requireConfirm &= 0xEFFFFFFF;
        RRepo repo3 = repos.getBioCMirror();
        RRepo selectedBioC = repo3 != null ? Util.findRepo(this.allBioC, repo3) : null;
        this.requireConfirm &= 0xDFFFFFFF;
        SelectedRepos previousSettings = this.selectedRepos;
        SelectedRepos newSettings = new SelectedRepos(selectedRepos, selectedCRAN, previousSettings.getBioCVersion(), selectedBioC);
        for (RRepo repo4 : this.allRepos) {
            if (!(repo4 instanceof RVarRepo)) continue;
            ((RVarRepo)repo4).updateURL(newSettings);
        }
        this.selectedRepos = newSettings;
        this.savePrefs(newSettings);
        if (!newSettings.equals(previousSettings)) {
            this.requireLoad |= 0x1000000;
            Change event = new Change(this.rEnv);
            event.repos = 1;
            this.fireUpdate(event);
        }
    }

    @Override
    public RRepo getRepo(String repoId) {
        if (repoId.isEmpty()) {
            return null;
        }
        RRepo repo = this.selectedRepos.getRepo(repoId);
        if (repo == null) {
            repo = RPkgUtils.getRepoById(this.allRepos, repoId);
        }
        return repo;
    }

    private void savePrefs(SelectedRepos repos) {
        if (this.rEnv.get(IREnvConfiguration.class) == null) {
            return;
        }
        IScopeContext prefs = InstanceScope.INSTANCE;
        IEclipsePreferences globalNode = prefs.getNode("org.eclipse.statet.r.core/r.pkgmanager");
        IEclipsePreferences envNode = prefs.getNode(this.selectedReposPref.getQualifier());
        PreferenceUtils.setPrefValue((IEclipsePreferences)envNode, (Preference)this.selectedReposPref, (Object)repos.getRepos());
        PreferenceUtils.setPrefValue((IEclipsePreferences)envNode, (Preference)this.selectedCRANPref, (Object)repos.getCRANMirror());
        PreferenceUtils.setPrefValue((IEclipsePreferences)envNode, (Preference)this.bioCVersionPref, (Object)repos.getBioCVersion());
        PreferenceUtils.setPrefValue((IEclipsePreferences)envNode, (Preference)this.selectedBioCPref, (Object)repos.getBioCMirror());
        if (repos.getCRANMirror() != null) {
            PreferenceUtils.setPrefValue((IEclipsePreferences)globalNode, (Preference)LAST_CRAN_PREF, (Object)repos.getCRANMirror());
        }
        if (repos.getBioCMirror() != null) {
            PreferenceUtils.setPrefValue((IEclipsePreferences)globalNode, (Preference)LAST_BIOC_PREF, (Object)repos.getBioCMirror());
        }
        try {
            globalNode.flush();
            envNode.flush();
        }
        catch (BackingStoreException e) {
            RCorePlugin.logError("An error occurred when saving the R package manager preferences.", e);
        }
    }

    public ImList<RRepo> getAvailableCRANMirrors() {
        return this.allCRAN;
    }

    @Override
    public List<RRepo> getAvailableBioCMirrors() {
        return this.allBioC;
    }

    @Override
    public RuntimeRLibPaths getRLibPaths() {
        return this.rLibPaths;
    }

    private RuntimeRLibPathsLoader getRLibLoader() {
        if (this.rLibGroups != null) {
            return this.rLibGroups;
        }
        IREnvConfiguration rEnvConfig = (IREnvConfiguration)this.rEnv.get(IREnvConfiguration.class);
        if (rEnvConfig != null) {
            return new RuntimeRLibPathsLoader((REnvConfiguration)rEnvConfig);
        }
        return null;
    }

    public @Nullable IRPkgSet getDataset() {
        return this.datasetExt != null ? this.datasetExt : this.dataset;
    }

    @Override
    public IRPkgSet.Ext getExtRPkgSet() {
        return this.datasetExt;
    }

    @Override
    public List<? extends IRView> getRViews() {
        return this.rViews;
    }

    @Override
    public void apply(Tool process) {
        process.getQueue().add((ToolRunnable)new AbstractRToolRunnable("r/renv/rpkg.apply", "Perform Package Manager Operations"){

            protected void run(RToolService r, ProgressMonitor m) throws StatusException {
                RPkgManagerImpl.this.runApply((RService)r, m);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean beginRTaskSilent(RToolService r, ProgressMonitor m) {
        RPkgManagerImpl rPkgManagerImpl = this;
        synchronized (rPkgManagerImpl) {
            block4: {
                if (this.rProcess == null) break block4;
                return false;
            }
            this.rProcess = r.getTool();
            this.rTask = 1;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void beginRTask(RToolService r, ProgressMonitor m) throws StatusException {
        var3_3 = this;
        synchronized (var3_3) {
            while (true) lbl-1000:
            // 3 sources

            {
                if (this.rProcess == null) {
                    this.rProcess = r.getTool();
                    this.rTask = 2;
                    return;
                }
                if (this.rTask != 1) {
                    status = new ErrorStatus("org.eclipse.statet.r.core", NLS.bind((String)"Another package manager task for ''{0}'' is already running in ''{0}''", (Object)this.rEnv.getName(), (Object)this.rProcess.getLabel(0)));
                    throw new StatusException((Status)status);
                }
                m.beginSubTask("Waiting for package check...");
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    if (m.isCanceled()) ** break;
                    continue;
                    throw new StatusException(Status.CANCEL_STATUS);
                }
                break;
            }
            ** GOTO lbl-1000
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endRTask() {
        RPkgManagerImpl rPkgManagerImpl = this;
        synchronized (rPkgManagerImpl) {
            this.rProcess = null;
            this.rTask = 0;
            this.notifyAll();
        }
    }

    protected void runApply(RService r, ProgressMonitor m) throws StatusException {
        this.beginRTask((RToolService)r, m);
        try {
            SelectedRepos selectedRepos;
            this.getReadLock().lock();
            try {
                selectedRepos = this.selectedRepos;
            }
            finally {
                this.getReadLock().unlock();
            }
            if (this.getReposStatus(selectedRepos).getSeverity() != 4) {
                this.updateRequireLoad();
                this.rTaskEvent = new Change(this.rEnv);
                this.runApplyRepo(selectedRepos, r, m);
                this.runLoadPkgs(selectedRepos, r, m);
                this.fireUpdate(this.rTaskEvent);
            }
        }
        finally {
            this.rTaskEvent = null;
            this.endRTask();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private ISelectedRepos runLoadRepos(RService r, ProgressMonitor m) throws StatusException {
        try {
            String url;
            String bioCVersion = null;
            try {
                RObject data = r.evalData("as.character(rj:::renv.getBioCVersion())", m);
                bioCVersion = RDataUtils.checkSingleCharValue((RObject)data);
            }
            catch (StatusException e) {
                try {
                    RObject data = r.evalData("as.character(tools:::.BioC_version_associated_with_R_version)", m);
                    bioCVersion = RDataUtils.checkSingleCharValue((RObject)data);
                }
                catch (StatusException ignore) {
                    RCorePlugin.logError("Failed to get the version of BioC.", e);
                }
            }
            boolean loadRMirrors = (this.requireLoad & 0x30000000) != 0;
            boolean loadRRepos = (this.requireLoad & Integer.MIN_VALUE) != 0;
            List<RRepoMirror> rCRANMirrors = null;
            List<RRepoMirror> rBioCMirrors = null;
            String selectedCRAN = null;
            String selectedBioC = null;
            if (loadRMirrors) {
                m.beginSubTask("Fetching available mirrors...");
                String mirrorArgs = "all= FALSE, local.only= FALSE";
                rCRANMirrors = this.fetchMirrors("getCRANmirrors(all= FALSE, local.only= FALSE)", r, m);
                try {
                    rBioCMirrors = this.fetchMirrors("utils:::.getMirrors('https://bioconductor.org/BioC_mirrors.csv', file.path(R.home('doc'), 'BioC_mirrors.csv'), all= FALSE, local.only= FALSE)", r, m);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (rBioCMirrors == null || rBioCMirrors.isEmpty()) {
                    String[][] s = new String[][]{{"United States (Seattle)", "http://www.bioconductor.org", "us"}, {"United States (Rockville)", "http://watson.nci.nih.gov/bioc_mirror", "us"}, {"Germany (Dortmund)", "http://bioconductor.statistik.tu-dortmund.de", "de"}, {"China (Anhui)", "http://mirrors.ustc.edu.cn/bioc/", "cn"}, {"United Kingdom (Hinxton)", "http://mirrors.ebi.ac.uk/bioconductor/", "uk"}, {"Riken, Kobe (Japan)", "http://bioconductor.jp/", "jp"}, {"Australia (Sydney)", "http://mirror.aarnet.edu.au/pub/bioconductor/", "au"}, {"Brazil (Ribeir\u00e3o Preto)", "http://bioconductor.fmrp.usp.br/", "br"}};
                    rBioCMirrors = new ArrayList<RRepoMirror>(s.length);
                    int i = 0;
                    while (i < s.length) {
                        url = Util.checkURL(s[i][1]);
                        if (!url.isEmpty()) {
                            rBioCMirrors.add(new RRepoMirror("r-" + url, s[i][0], url, s[i][2]));
                        }
                        ++i;
                    }
                }
            }
            ArrayList<RRepo> rrepos = null;
            ArrayList<RRepo> selected = null;
            if (loadRRepos) {
                RStore ids;
                m.beginSubTask("Fetching available repositories...");
                RObject data = r.evalData("options('repos')[[1L]]", m);
                if (data.getRObjectType() != 1) {
                    RCharacterStore urls = (RCharacterStore)RDataUtils.checkRCharVector((RObject)data).getData();
                    ids = ((RVector)data).getNames();
                    int l = RDataUtils.checkIntLength((RStore)urls);
                    selected = new ArrayList(l);
                    int i = 0;
                    while (i < l) {
                        String url2;
                        String id = ids != null ? ids.getChar(i) : null;
                        RRepo repo = Util.createRepoFromR(id, null, url2 = urls.getChar(i));
                        if (repo != null) {
                            selected.add(repo);
                        }
                        ++i;
                    }
                } else {
                    selected = new ArrayList<RRepo>(4);
                }
                data = r.evalData("local({p <- file.path(Sys.getenv('HOME'), '.R', 'repositories')\nif (!file.exists(p)) p <- file.path(R.home('etc'), 'repositories')\nr <- utils::read.delim(p, header= TRUE, comment.char= '#', colClasses= c(rep.int('character', 3L), rep.int('logical', 4L)))\nr[c(names(r)[1L], 'URL', 'default')]\n})", m);
                RDataFrame df = RDataUtils.checkRDataFrame((RObject)data);
                ids = df.getRowNames();
                RCharacterStore labels = (RCharacterStore)RDataUtils.checkRCharVector((RObject)df.get(0)).getData();
                RCharacterStore urls = (RCharacterStore)RDataUtils.checkRCharVector((RObject)df.get("URL")).getData();
                RLogicalStore isDefault = selected.isEmpty() ? (RLogicalStore)RDataUtils.checkRLogiVector((RObject)df.get("default")).getData() : null;
                int l = RDataUtils.checkIntLength((RStore)labels);
                rrepos = new ArrayList<RRepo>(l + 4);
                int i = 0;
                while (i < l) {
                    String id = ids != null ? ids.getChar(i) : null;
                    String url3 = urls.getChar(i);
                    RRepo repo = Util.createRepoFromR(id, labels.getChar(i), url3);
                    if (repo != null) {
                        rrepos.add(repo);
                        if (isDefault != null && isDefault.getLogi(i)) {
                            selected.add(repo);
                        }
                    }
                    ++i;
                }
                int i2 = 0;
                while (i2 < selected.size()) {
                    int j;
                    RRepo repo = (RRepo)selected.get(i2);
                    RRepo rrepo = null;
                    if (!repo.getURL().isEmpty()) {
                        rrepo = RPkgUtils.getRepoByURL(rrepos, repo.getURL());
                    }
                    if (rrepo != null) {
                        selected.set(i2, rrepo);
                    } else if (!repo.getId().isEmpty() && (j = rrepos.indexOf(repo)) >= 0) {
                        rrepo = (RRepo)rrepos.get(j);
                        if (!RVarRepo.hasVars(rrepo.getURL())) {
                            rrepo.setURL(repo.getURL());
                        }
                        selected.set(i2, rrepo);
                    } else {
                        repo.setName(RRepo.hintName(repo));
                    }
                    ++i2;
                }
            }
            if (loadRMirrors) {
                RObject data;
                if (loadRRepos) {
                    RRepo repo = RPkgUtils.getRepoById(rrepos, "r-cran");
                    if (repo != null && !repo.getURL().isEmpty() && !RVarRepo.hasVars(repo.getURL())) {
                        selectedCRAN = repo.getURL();
                    }
                } else {
                    data = r.evalData("options('repos')[[1L]]['CRAN']", m);
                    if (data.getRObjectType() != 1 && !(url = Util.checkURL(RDataUtils.checkSingleChar((RObject)data))).isEmpty() && !RVarRepo.hasVars(url)) {
                        selectedCRAN = url;
                    }
                }
                if ((data = r.evalData("options('BioC_mirror')[[1L]]", m)).getRObjectType() != 1) {
                    selectedBioC = RDataUtils.checkSingleChar((RObject)data);
                }
            }
            this.getWriteLock().lock();
            try {
                this.bioCVersion = bioCVersion;
                if (loadRMirrors) {
                    this.requireLoad &= 0xCFFFFFFF;
                    this.rCRANMirrors = rCRANMirrors;
                    this.selectedCRANInR = selectedCRAN;
                    this.rBioCMirrors = rBioCMirrors;
                    this.selectedBioCInR = selectedBioC;
                    this.mirrorsStamp = this.rTaskEvent.stamp;
                    this.checkMirrors(this.rTaskEvent);
                }
                if (loadRRepos) {
                    this.requireLoad &= Integer.MAX_VALUE;
                    this.rRepos = rrepos;
                    this.selectedReposInR = selected;
                    this.checkRepos(this.rTaskEvent);
                }
                this.firstTime = false;
                if (this.getReposStatus(this.selectedRepos, this.selectedRepos, this.requireConfirm).getSeverity() == 0) {
                    SelectedRepos selectedRepos = this.selectedRepos;
                    return selectedRepos;
                }
                return null;
            }
            finally {
                this.getWriteLock().unlock();
            }
        }
        catch (Exception e) {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.r.core", 0, "An error occurred when loading data for package manager.", (Throwable)e));
        }
    }

    private List<RRepoMirror> fetchMirrors(String rExpr, RService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
        RObject data = r.evalData(String.valueOf(rExpr) + "[c('Name', 'URL', 'CountryCode')]", m);
        RDataFrame df = RDataUtils.checkRDataFrame((RObject)data);
        RCharacterStore names = (RCharacterStore)RDataUtils.checkRCharVector((RObject)df.get("Name")).getData();
        RCharacterStore urls = (RCharacterStore)RDataUtils.checkRCharVector((RObject)df.get("URL")).getData();
        RCharacterStore countryCodes = (RCharacterStore)RDataUtils.checkRCharVector((RObject)df.get("CountryCode")).getData();
        int l = RDataUtils.checkIntLength((RStore)names);
        ArrayList<RRepoMirror> mirrors = new ArrayList<RRepoMirror>(l);
        int i = 0;
        while (i < l) {
            String url = Util.checkURL(urls.getChar(i));
            if (!url.isEmpty()) {
                mirrors.add(new RRepoMirror("r-" + url, names.getChar(i), url, countryCodes.getChar(i)));
            }
            ++i;
        }
        return mirrors;
    }

    private RRepoMirror getRegionMirror(List<RRepoMirror> mirrors) {
        String countryCode = Locale.getDefault().getCountry().toLowerCase(Locale.ROOT);
        RRepoMirror http = null;
        for (RRepoMirror repo : mirrors) {
            if (!countryCode.equals(repo.getCountryCode())) continue;
            if (repo.getURL().startsWith("https:")) {
                return repo;
            }
            if (http != null) continue;
            http = repo;
        }
        return http;
    }

    private void runApplyRepo(ISelectedRepos repos, RService r, ProgressMonitor m) throws StatusException {
        m.beginSubTask("Setting repository configuration...");
        try {
            if (repos.getBioCMirror() != null) {
                FunctionCall call = r.createFunctionCall("options");
                call.addChar("BioC_mirror", repos.getBioCMirror().getURL());
                call.evalVoid(m);
            }
            List selectedRepos = (List)repos.getRepos();
            String[] ids = new String[selectedRepos.size()];
            String[] urls = new String[selectedRepos.size()];
            int i = 0;
            while (i < urls.length) {
                RRepo repo = (RRepo)selectedRepos.get(i);
                ids[i] = repo.getId();
                urls[i] = repo.getURL();
                ++i;
            }
            RVectorImpl data = new RVectorImpl((RStore)new RCharacter32Store(urls), "character", ids);
            FunctionCall call = r.createFunctionCall("options");
            call.add("repos", (RObject)data);
            call.evalVoid(m);
        }
        catch (StatusException e) {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.r.core", "An error occurred when setting repository configuration in R.", (Throwable)e));
        }
    }

    private void runLoadPkgs(ISelectedRepos repoSettings, RService r, ProgressMonitor m) throws StatusException {
        boolean loadRepoPkgs = (this.requireLoad & 0x1000000) != 0 && this.getReposStatus(repoSettings).getSeverity() == 0;
        boolean loadInstPkgs = (this.requireLoad & 0x8000000) != 0;
        RPkgCompilation<IRPkgData> available = null;
        if (loadRepoPkgs) {
            available = this.pkgScanner.loadAvailable(this.rEnv, repoSettings, r, m);
            loadInstPkgs = true;
        }
        if (loadInstPkgs) {
            this.checkInstalled(true, available, r, m);
        }
        if (loadRepoPkgs || loadInstPkgs) {
            this.getWriteLock().lock();
            try {
                this.setPkgs();
                if (loadRepoPkgs) {
                    this.requireLoad &= 0xFEFFFFFF;
                    this.pkgsStamp = this.rTaskEvent.stamp;
                    this.rTaskEvent.pkgs |= 0x20;
                }
                if (loadInstPkgs) {
                    this.requireLoad &= 0xF7FFFFFF;
                }
                if (this.datasetExt != null) {
                    this.checkRViews(this.datasetExt, r, m);
                }
            }
            finally {
                this.getWriteLock().unlock();
            }
        }
    }

    private void checkInstalled(boolean fullUpdate, @Nullable RPkgCompilation<IRPkgData> newAvailable, RService r, ProgressMonitor m) throws StatusException {
        RVector libs = null;
        boolean[] update = null;
        RuntimeRLibPathsLoader rLibLoader = this.getRLibLoader();
        try {
            libs = rLibLoader.loadLibStamps(r, m);
            int l = RDataUtils.checkIntLength((RStore)libs.getData());
            int idxLib = 0;
            while (idxLib < l) {
                int idx;
                String libPath = libs.getNames().getChar(idxLib);
                if (this.libs == null || (idx = (int)this.libs.getNames().indexOf(libPath)) < 0 || ((RNumericStore)this.libs.getData()).getNum(idx) != ((RNumericStore)libs.getData()).getNum(idxLib)) {
                    if (update == null) {
                        update = new boolean[l];
                    }
                    update[idxLib] = true;
                }
                ++idxLib;
            }
            this.libs = libs;
        }
        catch (StatusException | UnexpectedRDataException e) {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.r.core", "An error occurred when checking for changed R libraries.", e));
        }
        if (update != null || fullUpdate) {
            if (this.rTaskEvent == null) {
                this.rTaskEvent = new Change(this.rEnv);
            }
            if (this.rTaskEvent.oldPkgs == null) {
                this.rTaskEvent.oldPkgs = this.getDataset();
            }
            if (this.datasetExt != null || fullUpdate) {
                this.rLibPaths = rLibLoader.load(libs, 3, r, m);
                if (newAvailable == null) {
                    newAvailable = this.datasetExt != null ? this.datasetExt.getAvailable() : new BasicRPkgCompilation(0);
                }
                FullRPkgSet newPkgs = new FullRPkgSet(this.rEnv, (RLibPaths)this.rLibPaths, (RPkgCompilation<IRPkgData>)newAvailable);
                this.pkgScanner.updateInstFull(this.rLibPaths, update, newPkgs, this.rTaskEvent, r, m);
                this.rTaskEvent.newPkgs = newPkgs;
            } else {
                this.rLibPaths = rLibLoader.load(libs, 0, r, m);
                this.rTaskEvent.newPkgs = new RPkgSet(this.rEnv, (RLibPaths)this.rLibPaths, this.pkgScanner.loadInstalled(this.rLibPaths, update, this.rTaskEvent, r, m));
            }
            if (this.rTaskEvent.installedPkgs != null && this.rTaskEvent.installedPkgs.names.isEmpty()) {
                this.rTaskEvent.installedPkgs = null;
            }
            if (!fullUpdate) {
                this.setPkgs();
            }
            if (this.rTaskEvent.installedPkgs != null && this.db != null) {
                this.db.updatePkgs(this.rTaskEvent);
            }
            if (!fullUpdate && this.datasetExt != null) {
                this.checkRViews(this.datasetExt, r, m);
            }
        }
    }

    private void setPkgs() {
        Change event = this.rTaskEvent;
        if (event.newPkgs instanceof FullRPkgSet) {
            this.datasetExt = (FullRPkgSet)event.newPkgs;
            this.dataset = null;
        } else if (event.newPkgs instanceof RPkgSet) {
            this.datasetExt = null;
            this.dataset = (RPkgSet)event.newPkgs;
        }
        if (event.installedPkgs != null) {
            event.pkgs |= 1;
        }
    }

    private void checkRViews(FullRPkgSet pkgs, RService r, ProgressMonitor m) {
        RPkgInfoAndData pkg = (RPkgInfoAndData)pkgs.getInstalled().getFirst("ctv");
        if (pkg == null || pkg.getVersion().equals((Object)this.rViewsVersion)) {
            return;
        }
        List<RView> rViews = RViewTasks.loadRViews(r, m);
        if (rViews != null) {
            this.rViews = rViews;
            this.rViewsVersion = pkg.getVersion();
            this.rTaskEvent.views = 1;
        }
    }

    @Override
    public IRPkgData addToCache(IFileStore store, IProgressMonitor monitor) throws CoreException {
        try {
            RPkg pkg = RPkgUtils.checkPkgFileName((String)store.getName());
            RPkgType type = RPkgUtils.checkPkgType((String)store.getName(), (RPlatform)this.rPlatform);
            this.cache.add(pkg.getName(), type, store, monitor);
            return new RPkgData(pkg.getName(), RNumVersion.NONE, "special-ws-cache-" + type.name().toLowerCase(Locale.ROOT));
        }
        catch (StatusException e) {
            throw StatusUtils.convert((StatusException)e);
        }
    }

    @Override
    public void perform(Tool rTool, final List<? extends RPkgAction> actions) {
        if (actions.isEmpty()) {
            return;
        }
        String label = actions.get(0).getAction() == 1 ? "Uninstall R Packages" : "Install/Update R Packages";
        final RPkgOperator op = new RPkgOperator(this);
        rTool.getQueue().add((ToolRunnable)new AbstractStatetRRunnable("r/renv/pkgs.inst", label){

            @Override
            protected void run(IRConsoleService r, ProgressMonitor m) throws StatusException {
                RPkgManagerImpl.this.beginRTask(r, m);
                try {
                    try {
                        2.checkNewCommand(r, m);
                        r.briefAboutToChange();
                        op.runActions(actions, r, m);
                    }
                    catch (StatusException | UnexpectedRDataException e) {
                        throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.r.core", "An error occurred when installing and updating R packages.", e));
                    }
                }
                finally {
                    RPkgManagerImpl.this.endRTask();
                    r.briefChanged(16);
                }
            }
        });
    }

    @Override
    public void loadPkgs(Tool rTool, final List<? extends IRPkgInfoAndData> pkgs, final boolean expliciteLocation) {
        final RPkgOperator op = new RPkgOperator(this);
        rTool.getQueue().add((ToolRunnable)new AbstractStatetRRunnable("r/renv/pkgs.load", "Load R Packages"){

            @Override
            protected void run(IRConsoleService r, ProgressMonitor m) throws StatusException {
                3.checkNewCommand(r, m);
                op.loadPkgs(pkgs, expliciteLocation, r, m);
            }
        });
    }
}

