/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.nico.impl;

import com.jcraft.jsch.ChannelDirectTCPIP;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.security.SecureRandom;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.base.core.StatetCore;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.status.eplatform.EStatusUtils;
import org.eclipse.statet.rj.server.FxCallback;

public class RjsUtil {
    public static Session getSession(Map<String, Object> loginData, IProgressMonitor monitor) throws CoreException {
        String username = (String)loginData.get("username");
        String sshHost = (String)loginData.get("ssh.host");
        Integer sshPort = (Integer)loginData.get("ssh.port");
        return StatetCore.getSshSessionManager().getSshSession(username, sshHost, sshPort != null ? sshPort : 22, monitor);
    }

    public static Session getSession(Map<String, Object> loginData, ProgressMonitor m) throws StatusException {
        String username = (String)loginData.get("username");
        String sshHost = (String)loginData.get("ssh.host");
        Integer sshPort = (Integer)loginData.get("ssh.port");
        try {
            return StatetCore.getSshSessionManager().getSshSession(username, sshHost, sshPort != null ? sshPort : 22, EStatusUtils.convert((ProgressMonitor)m));
        }
        catch (CoreException e) {
            throw EStatusUtils.convert((CoreException)e);
        }
    }

    public static RMIClientSocketFactory createRMIOverSshClientSocketFactory(final Session session) {
        return new RMIClientSocketFactory(){

            @Override
            public Socket createSocket(String host, int port) throws IOException {
                try {
                    ChannelDirectTCPIP tcpipChannel = (ChannelDirectTCPIP)session.openChannel("direct-tcpip");
                    tcpipChannel.setHost(host);
                    tcpipChannel.setPort(port);
                    RMIOverSshClientSocket socket = new RMIOverSshClientSocket(tcpipChannel);
                    socket.connect(InetSocketAddress.createUnresolved(host, port));
                    tcpipChannel.connect();
                    return socket;
                }
                catch (JSchException e) {
                    IOException ioException = new IOException();
                    ioException.initCause(e);
                    throw ioException;
                }
            }
        };
    }

    public static void startRemoteServerOverSsh(Session session, String command, Hashtable<String, String> envp, IProgressMonitor monitor) throws CoreException {
        ByteArrayOutputStream output;
        Throwable error;
        int status;
        block17: {
            ChannelExec execChannel = null;
            status = -11111111;
            error = null;
            output = new ByteArrayOutputStream();
            try {
                try {
                    execChannel = (ChannelExec)session.openChannel("exec");
                    execChannel.setCommand(command);
                    if (envp != null) {
                        execChannel.setEnv(envp);
                    }
                    execChannel.setInputStream(null);
                    execChannel.setOutputStream((OutputStream)output, false);
                    execChannel.setErrStream((OutputStream)output, false);
                    execChannel.connect();
                    while (!execChannel.isClosed()) {
                        if (monitor.isCanceled()) {
                            execChannel.disconnect();
                            throw new CoreException(Status.CANCEL_STATUS);
                        }
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    status = execChannel.getExitStatus();
                }
                catch (JSchException e) {
                    error = e;
                    status = -11111114;
                    if (execChannel != null) {
                        execChannel.disconnect();
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (execChannel != null) {
                    execChannel.disconnect();
                }
                throw throwable;
            }
            if (execChannel != null) {
                execChannel.disconnect();
            }
        }
        if (status != 0 && error == null) {
            try {
                error = new RemoteException("Exit status: " + status + "\nMessage:\n" + output.toString("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (error != null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.console.core", "Failed to start remote R server over SSH.", error));
        }
    }

    public static void handleFxCallback(Session session, FxCallback callback, ProgressMonitor m) throws StatusException {
        Throwable error;
        int status;
        block14: {
            byte[] clientKey = new byte[1024];
            new SecureRandom().nextBytes(clientKey);
            String filename = callback.getFilename();
            byte[] content = callback.createContent(clientKey);
            ChannelExec execChannel = null;
            status = -11111111;
            error = null;
            try {
                try {
                    execChannel = (ChannelExec)session.openChannel("exec");
                    execChannel.setCommand("cat >> " + filename);
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(content);
                    execChannel.setInputStream((InputStream)inputStream, false);
                    execChannel.setOutputStream(null);
                    execChannel.setErrStream(null);
                    execChannel.connect();
                    while (!execChannel.isClosed()) {
                        if (m.isCanceled()) {
                            execChannel.disconnect();
                            throw new StatusException(org.eclipse.statet.jcommons.status.Status.CANCEL_STATUS);
                        }
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    status = execChannel.getExitStatus();
                }
                catch (JSchException e) {
                    error = e;
                    status = -11111114;
                    if (execChannel != null) {
                        execChannel.disconnect();
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (execChannel != null) {
                    execChannel.disconnect();
                }
                throw throwable;
            }
            if (execChannel != null) {
                execChannel.disconnect();
            }
        }
        if (status != 0 && error == null) {
            error = new RemoteException("Exit code: " + status);
        }
        if (error != null) {
            throw new StatusException((org.eclipse.statet.jcommons.status.Status)new ErrorStatus("org.eclipse.statet.r.console.core", "Failed to authenticate over SSH connection.", error));
        }
    }

    public static String getVersionString(int[] version) {
        if (version == null) {
            return "no version information";
        }
        if (version.length >= 3) {
            StringBuilder sb = new StringBuilder();
            sb.append(version[0]);
            sb.append('.');
            sb.append(version[1] >= 0 ? Integer.toString(version[1]) : "x");
            sb.append('.');
            sb.append(version[2] >= 0 ? Integer.toString(version[2]) : "x");
            return sb.toString();
        }
        return "invalid version information";
    }

    private static class RMIOverSshClientSocket
    extends Socket {
        public RMIOverSshClientSocket(ChannelDirectTCPIP channel) throws SocketException, IOException {
            super(new RMIOverSshClientSocketImpl(channel));
        }
    }

    private static class RMIOverSshClientSocketImpl
    extends SocketImpl {
        private final ChannelDirectTCPIP channel;
        private final ChannelInputStream inputStream;
        private final OutputStream outputStream;

        public RMIOverSshClientSocketImpl(ChannelDirectTCPIP channel) throws IOException {
            this.channel = channel;
            this.inputStream = new ChannelInputStream();
            channel.setOutputStream((OutputStream)new PipedOutputStream(this.inputStream));
            this.outputStream = channel.getOutputStream();
            this.localport = 0;
        }

        @Override
        protected void create(boolean stream) throws IOException {
            if (!stream) {
                throw new IOException("Not supported");
            }
        }

        @Override
        protected void connect(String host, int port) throws IOException {
            this.connect(InetSocketAddress.createUnresolved(host, port), 0);
        }

        @Override
        protected void connect(InetAddress address, int port) throws IOException {
            this.connect(new InetSocketAddress(address, port), 0);
        }

        @Override
        protected void connect(SocketAddress address, int timeout) throws IOException {
            InetSocketAddress inetAddress = (InetSocketAddress)address;
            if (this.localport != 0) {
                throw new IOException("Not supported: reconnect to " + address.toString());
            }
            this.address = inetAddress.getAddress();
            this.port = inetAddress.getPort();
            this.localport = -1;
        }

        @Override
        protected void bind(InetAddress host, int port) throws IOException {
            throw new IOException("Not supported");
        }

        @Override
        protected void listen(int backlog) throws IOException {
            throw new IOException("Not supported");
        }

        @Override
        protected void accept(SocketImpl s) throws IOException {
            throw new IOException("Not supported");
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.inputStream;
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return this.outputStream;
        }

        @Override
        protected int available() throws IOException {
            return this.inputStream.available();
        }

        @Override
        protected void close() throws IOException {
            this.localport = -1;
            this.channel.disconnect();
        }

        @Override
        protected void shutdownInput() throws IOException {
            this.inputStream.close();
        }

        @Override
        protected void shutdownOutput() throws IOException {
            this.outputStream.close();
        }

        @Override
        protected void sendUrgentData(int data) throws IOException {
            throw new IOException("Not supported");
        }

        @Override
        public void setOption(int optID, Object value) throws SocketException {
            switch (optID) {
                case 1: {
                    if (!((Boolean)value).booleanValue()) break;
                    return;
                }
                case 8: {
                    if (((Boolean)value).booleanValue()) break;
                    return;
                }
                case 4102: {
                    return;
                }
                case 4097: 
                case 4098: {
                    return;
                }
            }
            throw new SocketException("Not supported: option= " + optID + " with value= " + value);
        }

        @Override
        public Object getOption(int optID) throws SocketException {
            switch (optID) {
                case 1: {
                    return Boolean.TRUE;
                }
                case 8: {
                    return Boolean.FALSE;
                }
                case 4102: {
                    return 0;
                }
                case 4097: {
                    return 1024;
                }
                case 4098: {
                    return this.inputStream.getBufferSize();
                }
            }
            throw new SocketException("Not supported: option= " + optID);
        }

        private static class ChannelInputStream
        extends PipedInputStream {
            public ChannelInputStream() {
                this.buffer = new byte[32768];
            }

            public int getBufferSize() {
                return this.buffer.length;
            }
        }
    }
}

