/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.ui.console;

import java.util.EnumSet;
import java.util.List;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.core.util.PreferenceUtils;
import org.eclipse.statet.ecommons.preferences.ui.RGBPref;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.nico.core.runtime.SubmitType;
import org.eclipse.statet.nico.core.runtime.ToolController;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.core.runtime.ToolStreamProxy;
import org.eclipse.statet.nico.ui.NicoUIPreferences;
import org.eclipse.statet.nico.ui.console.NIConsole;
import org.eclipse.statet.nico.ui.console.NIConsoleOutputStream;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

@NonNullByDefault
public class NIConsoleColorAdapter {
    private static final List<String> STREAM_IDS = ImCollections.newList((Object[])new String[]{"org.eclipse.statet.nico.ui.InfoStream", "org.eclipse.debug.ui.ID_STANDARD_INPUT_STREAM", "org.eclipse.debug.ui.ID_STANDARD_OUTPUT_STREAM", "org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM", "org.eclipse.statet.nico.ui.SystemOutputStream", "org.eclipse.statet.nico.ui.InfoStream-OtherTasks", "org.eclipse.debug.ui.ID_STANDARD_INPUT_STREAM-OtherTasks", "org.eclipse.debug.ui.ID_STANDARD_OUTPUT_STREAM-OtherTasks", "org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM-OtherTasks"});
    private @Nullable NIConsole console;
    private final PreferenceAccess prefAccess = PreferenceUtils.getInstancePrefs();

    public List<String> getStreamIds() {
        return STREAM_IDS;
    }

    void connect(ToolProcess process, NIConsole console) {
        this.console = console;
        ToolController controller = process.getController();
        if (controller != null) {
            ToolStreamProxy proxy = controller.getStreams();
            PreferenceAccess prefs = PreferenceUtils.getInstancePrefs();
            EnumSet includeSet = (EnumSet)prefs.getPreferenceValue(NicoUIPreferences.OUTPUT_FILTER_SUBMITTYPES_INCLUDE_PREF);
            EnumSet<SubmitType> allTypes = EnumSet.allOf(SubmitType.class);
            EnumSet<SubmitType> otherTypes = EnumSet.of(SubmitType.OTHER);
            EnumSet<SubmitType> defaultTypes = EnumSet.complementOf(otherTypes);
            console.connect(proxy.getInfoStreamMonitor(), "org.eclipse.statet.nico.ui.InfoStream", defaultTypes);
            console.connect(proxy.getInfoStreamMonitor(), "org.eclipse.statet.nico.ui.InfoStream-OtherTasks", otherTypes);
            console.connect(proxy.getInputStreamMonitor(), "org.eclipse.debug.ui.ID_STANDARD_INPUT_STREAM", defaultTypes);
            console.connect(proxy.getOutputStreamMonitor(), "org.eclipse.debug.ui.ID_STANDARD_OUTPUT_STREAM", defaultTypes);
            console.connect(proxy.getErrorStreamMonitor(), "org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM", defaultTypes);
            if (includeSet.contains(SubmitType.OTHER)) {
                console.connect(proxy.getInputStreamMonitor(), "org.eclipse.debug.ui.ID_STANDARD_INPUT_STREAM-OtherTasks", otherTypes);
                console.connect(proxy.getOutputStreamMonitor(), "org.eclipse.debug.ui.ID_STANDARD_OUTPUT_STREAM-OtherTasks", otherTypes);
                console.connect(proxy.getErrorStreamMonitor(), "org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM-OtherTasks", otherTypes);
            }
            console.connect(proxy.getSystemOutputMonitor(), "org.eclipse.statet.nico.ui.SystemOutputStream", includeSet.contains(SubmitType.OTHER) ? allTypes : defaultTypes);
            this.updateSettings();
        }
    }

    void updateSettings() {
        NIConsole console = this.console;
        if (console == null) {
            return;
        }
        UIAccess.getDisplay().syncExec(() -> {
            for (String streamId : STREAM_IDS) {
                NIConsoleOutputStream stream = console.getStream(streamId);
                if (stream == null) continue;
                stream.setColor(this.getColor(NIConsoleColorAdapter.getForegroundColorPref(streamId)));
                stream.setBackgroundColor(this.getColor(NIConsoleColorAdapter.getBackgroundColorPref(streamId)));
                stream.setFontStyle(this.getFontStyle(streamId));
            }
        });
    }

    public void disconnect() {
        this.console = null;
    }

    private @Nullable Color getColor(@Nullable Preference<@Nullable RGB> preference) {
        RGB rgb;
        if (preference != null && (rgb = (RGB)this.prefAccess.getPreferenceValue(preference)) != null) {
            return new Color(rgb);
        }
        return null;
    }

    private int getFontStyle(String streamId) {
        int style;
        String rootKey = NIConsoleColorAdapter.getPrefRootKey(streamId);
        if (rootKey == null) {
            return 0;
        }
        int n = style = (Boolean)this.prefAccess.getPreferenceValue((Preference)new Preference.BooleanPref("org.eclipse.statet.nico.ui/console/output", String.valueOf(rootKey) + ".bold")) != false ? 1 : 0;
        if (((Boolean)this.prefAccess.getPreferenceValue((Preference)new Preference.BooleanPref("org.eclipse.statet.nico.ui/console/output", String.valueOf(rootKey) + ".italic"))).booleanValue()) {
            style |= 2;
        }
        return style;
    }

    public static @Nullable Preference<@Nullable RGB> getForegroundColorPref(String streamId) {
        String rootKey = NIConsoleColorAdapter.getPrefRootKey(streamId);
        if (rootKey != null) {
            return new RGBPref("org.eclipse.statet.nico.ui/console/output", String.valueOf(rootKey) + ".color");
        }
        return null;
    }

    public static @Nullable Preference<@Nullable RGB> getBackgroundColorPref(String streamId) {
        if (streamId.endsWith("-OtherTasks")) {
            return NicoUIPreferences.OUTPUT_OTHER_TASKS_BACKGROUND_COLOR_PREF;
        }
        return null;
    }

    private static @Nullable String getPrefRootKey(String streamId) {
        if (streamId == "org.eclipse.statet.nico.ui.InfoStream" || streamId == "org.eclipse.statet.nico.ui.InfoStream-OtherTasks") {
            return "InfoStream";
        }
        if (streamId == "org.eclipse.debug.ui.ID_STANDARD_INPUT_STREAM" || streamId == "org.eclipse.debug.ui.ID_STANDARD_INPUT_STREAM-OtherTasks") {
            return "StdInputStream";
        }
        if (streamId == "org.eclipse.debug.ui.ID_STANDARD_OUTPUT_STREAM" || streamId == "org.eclipse.debug.ui.ID_STANDARD_OUTPUT_STREAM-OtherTasks") {
            return "StdOutputStream";
        }
        if (streamId == "org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM" || streamId == "org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM-OtherTasks") {
            return "StdErrorStream";
        }
        if (streamId == "org.eclipse.statet.nico.ui.SystemOutputStream") {
            return "SystemOutputStream";
        }
        return null;
    }
}

