/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ecommons.ui;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.statet.ecommons.ui.swt.ColorUtils;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class AccessibleArrowImage
extends CompositeImageDescriptor {
    public static final int DEFAULT_SIZE = 5;
    private final int fDirection;
    private final RGB fForegroundColor;
    private final RGB fBackgroundColor;
    private final int fSize;

    public AccessibleArrowImage(int direction, int size, RGB foregroundColor, RGB backgroundColor) {
        switch (direction) {
            case 128: 
            case 1024: 
            case 16384: 
            case 131072: {
                break;
            }
            default: {
                throw new IllegalArgumentException("direction: " + direction);
            }
        }
        if (foregroundColor == null) {
            throw new NullPointerException("foregroundColor");
        }
        if (backgroundColor == null) {
            throw new NullPointerException("backgroundColor");
        }
        this.fDirection = direction;
        this.fForegroundColor = foregroundColor;
        this.fBackgroundColor = backgroundColor;
        this.fSize = size == -1 ? 5 : size;
    }

    protected void drawCompositeImage(int width, int height) {
        Display display = Display.getCurrent();
        Image image = this.fDirection == 16384 || this.fDirection == 131072 ? new Image((Device)display, this.fSize, this.fSize * 2 - 1) : new Image((Device)display, this.fSize * 2 - 1, this.fSize);
        ImageData imageData = image.getImageData();
        int foreground = imageData.palette.getPixel(ColorUtils.blend(this.fForegroundColor, this.fBackgroundColor, 0.8f));
        int aliasing = imageData.palette.getPixel(ColorUtils.blend(this.fForegroundColor, this.fBackgroundColor, 0.6f));
        int size1 = this.fSize - 1;
        int xOffset = 0;
        int yOffset = 0;
        switch (this.fDirection) {
            case 128: {
                int i = 0;
                while (i <= size1) {
                    int last = size1 * 2 - i;
                    imageData.setPixel(i, size1 - i, aliasing);
                    imageData.setAlpha(i, size1 - i, 255);
                    imageData.setPixel(last, size1 - i, aliasing);
                    imageData.setAlpha(last, size1 - i, 255);
                    int j = i + 1;
                    while (j < last) {
                        imageData.setPixel(j, size1 - i, foreground);
                        imageData.setAlpha(j, size1 - i, 255);
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case 1024: {
                int i = 0;
                while (i <= size1) {
                    int last = size1 * 2 - i;
                    imageData.setPixel(i, i, aliasing);
                    imageData.setAlpha(i, i, 255);
                    imageData.setPixel(last, i, aliasing);
                    imageData.setAlpha(last, i, 255);
                    int j = i + 1;
                    while (j < last) {
                        imageData.setPixel(j, i, foreground);
                        imageData.setAlpha(j, i, 255);
                        ++j;
                    }
                    ++i;
                }
                yOffset = 1;
                break;
            }
            case 16384: {
                int i = 0;
                while (i <= size1) {
                    int last = size1 * 2 - i;
                    imageData.setPixel(size1 - i, i, aliasing);
                    imageData.setAlpha(size1 - i, i, 255);
                    imageData.setPixel(size1 - i, last, aliasing);
                    imageData.setAlpha(size1 - i, last, 255);
                    int j = i + 1;
                    while (j < last) {
                        imageData.setPixel(size1 - i, j, foreground);
                        imageData.setAlpha(size1 - i, j, 255);
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case 131072: {
                int i = 0;
                while (i <= size1) {
                    int last = size1 * 2 - i;
                    imageData.setPixel(i, i, aliasing);
                    imageData.setAlpha(i, i, 255);
                    imageData.setPixel(i, last, aliasing);
                    imageData.setAlpha(i, last, 255);
                    int j = i + 1;
                    while (j < last) {
                        imageData.setPixel(i, j, foreground);
                        imageData.setAlpha(i, j, 255);
                        ++j;
                    }
                    ++i;
                }
                xOffset = 1;
            }
        }
        this.drawImage(imageData, (width - imageData.width) / 2 + xOffset, (height - imageData.height) / 2 + yOffset);
        image.dispose();
    }

    protected Point getSize() {
        int corr = this.fSize % 2 == 0 ? -1 : 0;
        switch (this.fDirection) {
            case 128: 
            case 1024: {
                return new Point(this.fSize * 3 + corr, this.fSize * 2);
            }
            case 16384: 
            case 131072: {
                return new Point(this.fSize * 2, this.fSize * 3 + corr);
            }
        }
        throw new IllegalStateException();
    }

    public int hashCode() {
        return this.fDirection * 7 + this.fSize * 3460 + this.fForegroundColor.hashCode() * 343629 + this.fBackgroundColor.hashCode() * 987972;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AccessibleArrowImage other = (AccessibleArrowImage)((Object)obj);
        return this.fDirection == other.fDirection && this.fSize == other.fSize && this.fForegroundColor.equals((Object)other.fForegroundColor) && this.fBackgroundColor.equals((Object)other.fBackgroundColor);
    }
}

