/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.style;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.statet.ecommons.waltable.config.CellConfigAttributes;
import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.style.CellStyleAttributes;
import org.eclipse.statet.ecommons.waltable.style.CellStyleProxy;
import org.eclipse.statet.ecommons.waltable.style.DisplayMode;
import org.eclipse.statet.ecommons.waltable.style.HorizontalAlignment;
import org.eclipse.statet.ecommons.waltable.style.IStyle;
import org.eclipse.statet.ecommons.waltable.style.VerticalAlignment;
import org.eclipse.statet.ecommons.waltable.swt.SWTUtil;
import org.eclipse.swt.graphics.Color;

public class CellStyleUtil {
    public static IStyle getCellStyle(ILayerCell cell, IConfigRegistry configRegistry) {
        return new CellStyleProxy(configRegistry, cell.getDisplayMode(), cell.getConfigLabels().getLabels());
    }

    public static int getHorizontalAlignmentSWT(IStyle cellStyle, int swtDefault) {
        HorizontalAlignment horizontalAlignment = cellStyle.getAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT);
        return horizontalAlignment != null ? SWTUtil.toSWT(horizontalAlignment) : swtDefault;
    }

    public static long getHorizontalAlignmentPadding(IStyle cellStyle, LRectangle lRectangle, long contentWidth) {
        HorizontalAlignment horizontalAlignment = cellStyle.getAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT);
        return CellStyleUtil.getHorizontalAlignmentPadding(horizontalAlignment, lRectangle.width, contentWidth);
    }

    public static long getHorizontalAlignmentPadding(HorizontalAlignment horizontalAlignment, long width, long contentWidth) {
        long padding;
        if (horizontalAlignment == null) {
            horizontalAlignment = HorizontalAlignment.CENTER;
        }
        switch (horizontalAlignment) {
            case CENTER: {
                padding = (width - contentWidth) / 2L;
                break;
            }
            case RIGHT: {
                padding = width - contentWidth;
                break;
            }
            default: {
                padding = 0L;
            }
        }
        if (padding < 0L) {
            padding = 0L;
        }
        return padding;
    }

    public static long getVerticalAlignmentPadding(IStyle cellStyle, LRectangle lRectangle, long contentHeight) {
        VerticalAlignment verticalAlignment = cellStyle.getAttributeValue(CellStyleAttributes.VERTICAL_ALIGNMENT);
        return CellStyleUtil.getVerticalAlignmentPadding(verticalAlignment, lRectangle.height, contentHeight);
    }

    public static long getVerticalAlignmentPadding(VerticalAlignment verticalAlignment, long height, long contentHeight) {
        if (verticalAlignment == null) {
            verticalAlignment = VerticalAlignment.MIDDLE;
        }
        long padding = 0L;
        switch (verticalAlignment) {
            case MIDDLE: {
                padding = (height - contentHeight) / 2L;
                break;
            }
            case BOTTOM: {
                padding = height - contentHeight;
            }
        }
        if (padding < 0L) {
            padding = 0L;
        }
        return padding;
    }

    public static List<Color> getAllBackgroundColors(ILayerCell cell, IConfigRegistry configRegistry, DisplayMode displayMode) {
        ArrayList<Color> colors = new ArrayList<Color>();
        for (String configLabel : cell.getConfigLabels().getLabels()) {
            Color color;
            IStyle cellStyle = configRegistry.getSpecificConfigAttribute(CellConfigAttributes.CELL_STYLE, displayMode, configLabel);
            if (cellStyle == null || (color = cellStyle.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR)) == null) continue;
            colors.add(color);
        }
        return colors;
    }
}

