/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.sort.config;

import org.eclipse.statet.ecommons.waltable.config.CellConfigAttributes;
import org.eclipse.statet.ecommons.waltable.config.DefaultComparator;
import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.config.IConfiguration;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.painter.cell.ICellPainter;
import org.eclipse.statet.ecommons.waltable.painter.cell.decorator.BeveledBorderDecorator;
import org.eclipse.statet.ecommons.waltable.sort.SortConfigAttributes;
import org.eclipse.statet.ecommons.waltable.sort.action.SortColumnAction;
import org.eclipse.statet.ecommons.waltable.sort.painter.SortableHeaderTextPainter;
import org.eclipse.statet.ecommons.waltable.style.DisplayMode;
import org.eclipse.statet.ecommons.waltable.ui.binding.UiBindingRegistry;
import org.eclipse.statet.ecommons.waltable.ui.matcher.MouseEventMatcher;
import org.eclipse.swt.SWT;

public class DefaultSortConfiguration
implements IConfiguration {
    public static final String SORT_DOWN_CONFIG_TYPE = "SORT_DOWN";
    public static final String SORT_UP_CONFIG_TYPE = "SORT_UP";
    public static final String SORT_SEQ_CONFIG_TYPE = "SORT_SEQ_";
    private final ICellPainter cellPainter;

    public DefaultSortConfiguration() {
        this(new BeveledBorderDecorator(new SortableHeaderTextPainter()));
    }

    public DefaultSortConfiguration(ICellPainter cellPainter) {
        this.cellPainter = cellPainter;
    }

    @Override
    public void configureLayer(ILayer layer) {
    }

    @Override
    public void configureRegistry(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(SortConfigAttributes.SORT_COMPARATOR, new DefaultComparator());
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, this.cellPainter, DisplayMode.NORMAL, SORT_DOWN_CONFIG_TYPE);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, this.cellPainter, DisplayMode.NORMAL, SORT_UP_CONFIG_TYPE);
    }

    @Override
    public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
        uiBindingRegistry.registerSingleClickBinding(new MouseEventMatcher(65536, "COLUMN_HEADER".toString(), 1), new SortColumnAction(false));
        uiBindingRegistry.registerSingleClickBinding(new MouseEventMatcher(0x10000 | SWT.MOD2, "COLUMN_HEADER".toString(), 1), new SortColumnAction(true));
    }
}

