/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.collections;

import java.util.Arrays;
import java.util.Spliterators;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.eclipse.statet.jcommons.collections.IntList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class IntArrayList
implements IntList {
    private static final int[] EMPTY_ARRAY = new int[0];
    private int[] array;
    private int size;

    public IntArrayList() {
        this.array = EMPTY_ARRAY;
    }

    public IntArrayList(int initialCapacity) {
        this.array = new int[initialCapacity];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int indexOf(int element) {
        int[] array = this.array;
        int size = this.size;
        int i = 0;
        while (i < size) {
            if (array[i] == element) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(int element) {
        int[] array = this.array;
        int i = this.size - 1;
        while (i >= 0) {
            if (array[i] == element) {
                return i;
            }
            --i;
        }
        return -1;
    }

    @Override
    public boolean contains(int element) {
        return this.indexOf(element) >= 0;
    }

    @Override
    public int getAt(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index= " + index);
        }
        return this.array[index];
    }

    protected final void ensureCapacity(int min) {
        if (min > this.array.length) {
            int newCapacity;
            if (this.array == EMPTY_ARRAY) {
                min = 8;
            }
            if ((newCapacity = Math.max(this.array.length + (this.array.length >> 1), min)) < 0) {
                newCapacity = Integer.MAX_VALUE;
            }
            int[] newArray = new int[newCapacity];
            System.arraycopy(this.array, 0, newArray, 0, this.size);
            this.array = newArray;
        }
    }

    @Override
    public boolean add(int element) {
        this.ensureCapacity(this.size + 1);
        this.array[this.size++] = element;
        return true;
    }

    @Override
    public void addAt(int index, int element) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("index= " + index);
        }
        this.ensureCapacity(this.size + 1);
        if (index < this.size) {
            System.arraycopy(this.array, index, this.array, index + 1, this.size - index);
        }
        this.array[index] = element;
        ++this.size;
    }

    @Override
    public int setAt(int index, int element) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index= " + index);
        }
        int oldElement = this.array[index];
        this.array[index] = element;
        return oldElement;
    }

    private void doRemoveElementBefore(int index) {
        if (index != this.size) {
            System.arraycopy(this.array, index, this.array, index - 1, this.size - index);
        }
    }

    @Override
    public boolean remove(int element) {
        int index = this.indexOf(element);
        if (index >= 0) {
            this.doRemoveElementBefore(index + 1);
            --this.size;
            return true;
        }
        return false;
    }

    @Override
    public int removeAt(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index= " + index);
        }
        int oldElement = this.array[index];
        this.doRemoveElementBefore(index + 1);
        --this.size;
        return oldElement;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public IntStream stream() {
        return StreamSupport.intStream(Spliterators.spliterator(this.array, 16), false);
    }

    @Override
    public int[] toArray() {
        return Arrays.copyOf(this.array, this.size);
    }
}

