/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.redocs.r.core.model;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.string.CacheStringFactory;
import org.eclipse.statet.jcommons.string.StringFactory;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;
import org.eclipse.statet.jcommons.text.core.TextLineInformation;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.jcommons.text.core.input.StringParserInput;
import org.eclipse.statet.jcommons.text.core.input.TextParserInput;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.EmbeddingAstNode;
import org.eclipse.statet.ltk.core.SourceContent;
import org.eclipse.statet.ltk.issues.core.ProblemRequestor;
import org.eclipse.statet.ltk.model.core.build.EmbeddingForeignReconcileTask;
import org.eclipse.statet.ltk.model.core.build.SourceUnitModelContainer;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.r.core.model.RCompositeSourceElement;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.model.RLangSourceElement;
import org.eclipse.statet.r.core.model.RModel;
import org.eclipse.statet.r.core.model.RModelManager;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.core.model.RSourceUnitModelInfo;
import org.eclipse.statet.r.core.model.build.RProblemReporter;
import org.eclipse.statet.r.core.rsource.RSourceConfig;
import org.eclipse.statet.r.core.rsource.ast.FCall;
import org.eclipse.statet.r.core.rsource.ast.NodeType;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.rsource.ast.RParser;
import org.eclipse.statet.r.core.rsource.ast.SourceComponent;
import org.eclipse.statet.redocs.r.core.model.RChunkNode;
import org.eclipse.statet.redocs.r.core.model.RedocsRChunkElement;

@NonNullByDefault
public class RChunkReconciler<TSourceUnit extends RSourceUnit, TModelInfo extends SourceUnitModelInfo, TModelContainer extends SourceUnitModelContainer<TSourceUnit, TModelInfo>> {
    private final String name;
    private final RModelManager rManager;
    private final Matcher raChunkStartLineMatcher;
    private final @Nullable Matcher raChunkRefLineMatcher;
    private final Matcher raChunkEndLineMatcher;
    private final RParser raParser = new RParser(RSourceConfig.DEFAULT_CONFIG, 4, (StringFactory)new CacheStringFactory(32));
    private final StringParserInput raInput = new StringParserInput(4096);
    protected final RProblemReporter rpReporter;

    public RChunkReconciler(String name, Pattern chunkStartLinePattern, Pattern chunkRefLinePattern, Pattern chunkEndLinePattern) {
        this.name = name;
        this.rManager = RModel.getRModelManager();
        this.raChunkStartLineMatcher = chunkStartLinePattern.matcher("");
        this.raChunkEndLineMatcher = chunkEndLinePattern.matcher("");
        this.raChunkRefLineMatcher = chunkRefLinePattern != null ? chunkRefLinePattern.matcher("") : null;
        this.rpReporter = new RProblemReporter();
    }

    public String getName() {
        return this.name;
    }

    public RModelManager getRModelManager() {
        return this.rManager;
    }

    public void reconcileAst(TModelContainer adapter, SourceContent sourceContent, List<? extends EmbeddingAstNode> list, RSourceConfig rSourceConfig, IProgressMonitor monitor) {
        if (sourceContent.getStartOffset() != 0) {
            throw new UnsupportedOperationException();
        }
        String source = sourceContent.getString();
        TextLineInformation lines = sourceContent.getStringLines();
        this.raChunkStartLineMatcher.reset(source);
        if (this.raChunkRefLineMatcher != null) {
            this.raChunkRefLineMatcher.reset(source);
        }
        this.raChunkEndLineMatcher.reset(source);
        this.raInput.reset(source);
        for (EmbeddingAstNode embeddingAstNode : list) {
            Region startRegion;
            if (embeddingAstNode.getForeignTypeId() != "R") continue;
            RChunkNode rChunk = new RChunkNode((AstNode)embeddingAstNode);
            rChunk.startOffset = embeddingAstNode.getStartOffset();
            rChunk.endOffset = embeddingAstNode.getEndOffset();
            embeddingAstNode.setForeignNode((AstNode)rChunk);
            ArrayList<Region> rCode = new ArrayList<Region>(4);
            switch (embeddingAstNode.getEmbedDescr() & 0xF) {
                case 2: {
                    startRegion = null;
                    rCode.add(new Region(embeddingAstNode.getStartOffset(), embeddingAstNode.getLength()));
                    break;
                }
                case 1: {
                    int lineOffset = rChunk.startOffset;
                    int line = lines.getLineOfOffset(rChunk.startOffset);
                    int lineEndOffset = lines.getEndOffset(line);
                    this.raChunkStartLineMatcher.region(lineOffset, lineEndOffset);
                    if (!this.raChunkStartLineMatcher.matches()) {
                        throw new IllegalStateException("R chunk does not start with start line.");
                    }
                    int start = this.raChunkStartLineMatcher.start(1);
                    int end = this.raChunkStartLineMatcher.end(1);
                    startRegion = new Region(start, end - start);
                    int rCodeStartOffset = lineEndOffset;
                    if (lineEndOffset >= rChunk.endOffset) break;
                    do {
                        lineOffset = lineEndOffset;
                        lineEndOffset = lines.getEndOffset(++line);
                        if (this.raChunkRefLineMatcher == null) continue;
                        this.raChunkRefLineMatcher.region(lineOffset, lineEndOffset);
                        if (!this.raChunkRefLineMatcher.matches()) continue;
                        if (rCodeStartOffset < lineOffset) {
                            rCode.add(new Region(rCodeStartOffset, lineOffset - rCodeStartOffset));
                        }
                        rCodeStartOffset = lineEndOffset;
                    } while (lineEndOffset < rChunk.endOffset);
                    if (rChunk.endOffset != lineEndOffset) {
                        throw new IllegalStateException("R chunk does not end at line end.");
                    }
                    this.raChunkEndLineMatcher.region(lineOffset, lineEndOffset);
                    if (this.raChunkEndLineMatcher.matches()) {
                        if (rCodeStartOffset < lineOffset) {
                            rCode.add(new Region(rCodeStartOffset, lineOffset - rCodeStartOffset));
                        }
                        rCodeStartOffset = lineEndOffset;
                        break;
                    }
                    if (rCodeStartOffset >= lineOffset) break;
                    rCode.add(new Region(rCodeStartOffset, lineEndOffset - rCodeStartOffset));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("embedType= " + embeddingAstNode.getEmbedDescr());
                }
            }
            this.raParser.setRSourceConfig(rSourceConfig);
            if (startRegion != null) {
                rChunk.weaveArgs = this.raParser.scanFCallArgs((TextParserInput)this.raInput.init(startRegion.getOffset(), startRegion.getOffset() + startRegion.getLength()), true);
            }
            Object[] rCodeNodes = new SourceComponent[rCode.size()];
            int j = 0;
            while (j < rCodeNodes.length) {
                IRegion region = (IRegion)rCode.get(j);
                rCodeNodes[j] = this.raParser.scanSourceRange((TextParserInput)this.raInput.init(region.getOffset(), region.getOffset() + region.getLength()), (AstNode)rChunk, true);
                ++j;
            }
            rChunk.rSources = ImCollections.newList((Object[])rCodeNodes);
        }
    }

    public @Nullable RSourceUnitModelInfo reconcileModel(TModelContainer adapter, SourceContent content, TModelInfo mainModel, List<? extends EmbeddingForeignReconcileTask<?, ?>> list, int level, IProgressMonitor monitor) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        int chunkCount = 0;
        ArrayList<RedocsRChunkElement> chunkElements = new ArrayList<RedocsRChunkElement>();
        ArrayList<SourceComponent> inlineNodes = new ArrayList<SourceComponent>();
        for (EmbeddingForeignReconcileTask<?, ?> item : list) {
            EmbeddingAstNode embeddingNode;
            RChunkNode rChunk;
            if (item.getForeignTypeId() != "R" || (rChunk = (RChunkNode)(embeddingNode = item.getAstNode()).getForeignNode()) == null) continue;
            ImList<SourceComponent> rSources = rChunk.getRCodeChildren();
            switch (embeddingNode.getEmbedDescr() & 0xF) {
                case 2: {
                    if (rSources.size() != 1) break;
                    inlineNodes.add((SourceComponent)rSources.get(0));
                    break;
                }
                case 1: {
                    ++chunkCount;
                    RElementName name = null;
                    RAstNode nameRegion = null;
                    FCall.Arg labelArgNode = this.getLabelArgNode(rChunk.getWeaveArgsChild());
                    if (labelArgNode != null && labelArgNode.hasValue()) {
                        RAstNode labelNode = labelArgNode.getValueChild();
                        String label = labelArgNode.getValueChild().getNodeType() == NodeType.SYMBOL ? labelNode.getText() : content.getString(labelNode.getStartOffset(), labelNode.getEndOffset());
                        name = RElementName.create((int)16, (String)label);
                        nameRegion = labelNode;
                    }
                    if (name == null) {
                        name = RElementName.create((int)16, (String)("#" + Integer.toString(chunkCount)));
                        nameRegion = new BasicTextRegion(embeddingNode.getStartOffset() + 2);
                    }
                    RedocsRChunkElement element = new RedocsRChunkElement((SourceStructElement<?, ?>)item.getEmbeddingElement(), rChunk, name, (TextRegion)nameRegion);
                    item.setEmbeddedElement((SourceStructElement)element);
                    chunkElements.add(element);
                }
            }
        }
        if (chunkElements.isEmpty() && inlineNodes.isEmpty()) {
            return null;
        }
        RSourceUnitModelInfo modelInfo = this.getRModelManager().reconcile((RSourceUnit)adapter.getSourceUnit(), mainModel, chunkElements, inlineNodes, level, monitor);
        mainModel.addAttachment((Object)modelInfo);
        return modelInfo;
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable FCall.Arg getLabelArgNode(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable FCall.Args weaveArgs) {
        if (weaveArgs == null || !weaveArgs.hasChildren()) {
            return null;
        }
        int i = 0;
        while (i < weaveArgs.getChildCount()) {
            FCall.Arg arg = weaveArgs.getChild(i);
            if (arg.hasName() ? arg.getNameChild().getNodeType() == NodeType.SYMBOL && "label".equals(arg.getNameChild().getText()) : i == 0) {
                return arg;
            }
            ++i;
        }
        return null;
    }

    public void reportEmbeddedProblems(TModelContainer adapter, SourceContent content, TModelInfo mainModel, ProblemRequestor problemRequestor, int level, IProgressMonitor monitor) {
        RSourceUnitModelInfo rModel = RModel.getRModelInfo(mainModel);
        if (rModel == null) {
            return;
        }
        RSourceUnit su = (RSourceUnit)adapter.getSourceUnit();
        RLangSourceElement element = rModel.getSourceElement();
        if (element instanceof RCompositeSourceElement) {
            List elements = ((RCompositeSourceElement)element).getCompositeElements();
            for (RLangSourceElement rChunk : elements) {
                AstNode rChunkNode = (AstNode)rChunk.getAdapter(AstNode.class);
                if (rChunkNode == null) continue;
                this.rpReporter.run(su, content, rChunkNode, problemRequestor);
            }
        }
    }
}

