/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.dialogs;

import java.util.Collection;
import java.util.Set;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.ui.dialogs.ExtStatusDialog;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

@NonNullByDefault
public abstract class AbstractCheckboxSelectionDialog<T>
extends ExtStatusDialog {
    private final WritableSet<T> checkedValue;
    private CheckboxTableViewer viewer;

    public AbstractCheckboxSelectionDialog(Shell shell, int options, Collection<T> checkedElements) {
        super(shell, options);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.checkedValue = checkedElements != null ? new WritableSet() : new WritableSet(checkedElements, null);
    }

    protected CheckboxTableViewer getCheckBoxTableViewer() {
        return this.viewer;
    }

    protected Composite createCheckboxComposite(Composite parent, String message) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid(3));
        if (message != null) {
            Label label = new Label(composite, 0);
            label.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
            label.setText(message);
        }
        Table table = new Table(composite, 2084);
        GridData gd = new GridData(4, 4, true, true, 3, 1);
        gd.heightHint = 250;
        gd.widthHint = 300;
        table.setLayoutData((Object)gd);
        this.viewer = new CheckboxTableViewer(table);
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                AbstractCheckboxSelectionDialog.this.updateCheckedStatus();
            }
        });
        this.configureViewer(this.viewer);
        Button button = new Button(composite, 8);
        gd = new GridData(4, 0x1000000, false, false);
        gd.widthHint = LayoutUtils.hintWidth(button);
        button.setLayoutData((Object)gd);
        button.setText("Select All");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractCheckboxSelectionDialog.this.getCheckBoxTableViewer().setAllChecked(true);
                AbstractCheckboxSelectionDialog.this.updateCheckedStatus();
            }
        });
        button = new Button(composite, 8);
        gd = new GridData(4, 0x1000000, false, false);
        gd.widthHint = LayoutUtils.hintWidth(button);
        button.setLayoutData((Object)gd);
        button.setText("Deselect All");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractCheckboxSelectionDialog.this.getCheckBoxTableViewer().setAllChecked(false);
                AbstractCheckboxSelectionDialog.this.updateCheckedStatus();
            }
        });
        return composite;
    }

    protected abstract void configureViewer(CheckboxTableViewer var1);

    @Override
    protected void addBindings(DataBindingSupport db) {
        db.getContext().bindSet(ViewerProperties.checkedElements(null).observe((Object)this.viewer), this.checkedValue);
    }

    public Set<T> getCheckedElements() {
        return this.checkedValue;
    }

    protected void updateCheckedStatus() {
        this.getButton(0).setEnabled(this.isValid());
    }

    protected boolean isValid() {
        return this.getCheckBoxTableViewer().getCheckedElements().length > 0;
    }
}

