/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.rhelp;

import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.statet.ecommons.preferences.PreferencesUtil;
import org.eclipse.statet.ecommons.preferences.SettingsChangeNotifier;
import org.eclipse.statet.ecommons.preferences.core.util.PreferenceUtils;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.r.ui.rhelp.RHelpPreferences;
import org.eclipse.statet.internal.r.ui.rhelp.RHelpRCodeScanner;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.rhelp.core.http.HttpForwardHandler;
import org.eclipse.statet.rhelp.core.http.RHelpHttpServlet;
import org.eclipse.statet.rhelp.core.http.jetty.JettyForwardHandler;
import org.eclipse.statet.rhelp.core.http.jetty.JettyRHelpUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;

@NonNullByDefault
public class RHelpUIServlet
extends RHelpHttpServlet
implements IPropertyChangeListener,
SettingsChangeNotifier.ChangeListener {
    private static final long serialVersionUID = 1L;
    static final String STYLE_PARAM = "style";
    static final String HOVER_STYLE = "hover";
    private static final String[] DEFAULT_MATCH_COLORS = new String[]{".SMATCH-A { background: #ceccf7; }\n", ".SMATCH-B { background: #ffffcf; }\n", ".SMATCH-C { background: aquamarine; }\n", ".SMATCH-D { background: palegreen; }\n", ".SMATCH-E { background: coral; }\n", ".SMATCH-F { background: wheat; }\n", ".SMATCH-G { background: khaki; }\n", ".SMATCH-H { background: lime; }\n", ".SMATCH-I { background: deepskyblue; }\n", ".SMATCH-J { background: plum; }\n"};
    private volatile @Nullable String cssStyle;
    private RHelpRCodeScanner rCodeScanner;

    static Color getDocBackgroundColor() {
        return (Color)ObjectUtils.nonNullAssert((Object)JFaceResources.getColorRegistry().get("org.eclipse.statet.workbench.themes.DocViewBackgroundColor"));
    }

    static Color getDocForegroundColor() {
        return (Color)ObjectUtils.nonNullAssert((Object)JFaceResources.getColorRegistry().get("org.eclipse.statet.workbench.themes.DocViewColor"));
    }

    private static void appendCssColor(StringBuilder sb, RGB color) {
        sb.append('#');
        String s = Integer.toHexString(color.red);
        if (s.length() == 1) {
            sb.append('0');
        }
        sb.append(s);
        s = Integer.toHexString(color.green);
        if (s.length() == 1) {
            sb.append('0');
        }
        sb.append(s);
        s = Integer.toHexString(color.blue);
        if (s.length() == 1) {
            sb.append('0');
        }
        sb.append(s);
    }

    private static void appendELinkColors(StringBuilder sb, RGB foregroundColor) {
        RGB hyperlinkColor = (RGB)ObjectUtils.nonNullAssert((Object)JFaceResources.getColorRegistry().getRGB("HYPERLINK_COLOR"));
        RGB hyperlinkActiveColor = (RGB)ObjectUtils.nonNullAssert((Object)JFaceResources.getColorRegistry().getRGB("ACTIVE_HYPERLINK_COLOR"));
        sb.append("a { color: ");
        RHelpUIServlet.appendCssColor(sb, hyperlinkColor);
        sb.append("; }\n");
        sb.append("a:hover, a:active, a:focus { color: ");
        RHelpUIServlet.appendCssColor(sb, hyperlinkActiveColor);
        sb.append("; }\n");
        sb.append("a:visited { color: ");
        RHelpUIServlet.appendCssColor(sb, new RGB(hyperlinkColor.red + (hyperlinkColor.red <= 127 ? 64 : -64), (hyperlinkColor.green + foregroundColor.green) / 2, (hyperlinkColor.blue + (hyperlinkColor.blue > 32 ? -32 : 32) + foregroundColor.blue) / 2));
        sb.append("; }\n");
    }

    private static void appendMatchColors(StringBuilder sb) {
        int i = 0;
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)EditorsPlugin.getDefault().getPreferenceStore(), (String)"searchResultIndicationColor");
        if (rgb != null) {
            sb.append(".SMATCH-A { background: ");
            RHelpUIServlet.appendCssColor(sb, rgb);
            sb.append("; }\n");
            ++i;
        }
        while (i < DEFAULT_MATCH_COLORS.length) {
            sb.append(DEFAULT_MATCH_COLORS[i++]);
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.init(RCore.getRHelpManager(), JettyRHelpUtils.newResourceHandler((ServletContext)config.getServletContext()), (HttpForwardHandler)new JettyForwardHandler());
        this.rCodeScanner = new RHelpRCodeScanner(RUIPlugin.getInstance().getEditorPreferenceStore());
        EditorsUI.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        JFaceResources.getColorRegistry().addListener((IPropertyChangeListener)this);
        PreferencesUtil.getSettingsChangeNotifier().addChangeListener((SettingsChangeNotifier.ChangeListener)this);
        this.updateStyles();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("org.eclipse.statet.workbench.themes.DocViewFont") || event.getProperty().equals("org.eclipse.statet.workbench.themes.DocViewBackgroundColor") || event.getProperty().equals("org.eclipse.statet.workbench.themes.DocViewColor") || event.getProperty().equals("org.eclipse.jface.dialogfont") || event.getProperty().equals("HYPERLINK_COLOR") || event.getProperty().equals("ACTIVE_HYPERLINK_COLOR") || event.getProperty().equals("searchResultIndicationColor")) {
            this.updateStyles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void settingsChanged(Set<String> groupIds) {
        if (groupIds.contains("r.editor/textstyles") || groupIds.contains("r.editor/identifiergroups")) {
            HashMap<String, Object> options = new HashMap<String, Object>();
            RHelpRCodeScanner rHelpRCodeScanner = this.rCodeScanner;
            synchronized (rHelpRCodeScanner) {
                this.rCodeScanner.handleSettingsChanged(groupIds, options);
            }
        }
    }

    public void destroy() {
        super.destroy();
        IPreferenceStore preferenceStore = EditorsUI.getPreferenceStore();
        if (preferenceStore != null) {
            preferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        JFaceResources.getColorRegistry().removeListener((IPropertyChangeListener)this);
        PreferencesUtil.getSettingsChangeNotifier().removeChangeListener((SettingsChangeNotifier.ChangeListener)this);
    }

    protected boolean getShowInternal() {
        return (Boolean)PreferenceUtils.getInstancePrefs().getPreferenceValue(RHelpPreferences.SHOW_INTERNAL_ENABLED_PREF);
    }

    protected boolean canOpenFile(String ext) {
        return true;
    }

    protected void doOpenFile(Path file) {
        try {
            final IFileStore fileStore = EFS.getLocalFileSystem().getStore(file.toUri());
            UIAccess.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage page = UIAccess.getActiveWorkbenchPage((boolean)true);
                    try {
                        IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                    }
                    catch (PartInitException partInitException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateStyles() {
        final StringBuilder sb = new StringBuilder(1024);
        UIAccess.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                RHelpUIServlet.this.collectCss(sb);
            }
        });
        sb.append(".header { display: none; }");
        this.cssStyle = sb.toString();
    }

    protected void collectCss(StringBuilder sb) {
    }

    protected void customizeCss(PrintWriter writer) {
        writer.print(this.cssStyle);
    }

    protected void customizePageHtmlHeader(HttpServletRequest req, PrintWriter writer) {
        this.customizeHtmlHeader(req, writer, true);
    }

    protected void customizeIndexHtmlHeader(HttpServletRequest req, PrintWriter writer) {
        this.customizeHtmlHeader(req, writer, false);
    }

    protected void customizeHtmlHeader(HttpServletRequest req, PrintWriter writer, boolean page) {
        writer.println("<script type=\"text/javascript\">/* <![CDATA[ */");
        writer.println("function keyNavHandler(event) {");
        writer.println("if (!event) event= window.event;");
        writer.println("if (event.which) { key= event.which } else if (event.keyCode) { key= event.keyCode };");
        writer.println("if (!event.ctrlKey && !event.altKey) { var anchor= 0;");
        if (page) {
            writer.println("if (key == 68) anchor= \"#description\"; else if (key == 85) anchor= \"#usage\"; else if (key == 65) anchor= \"#arguments\"; else if (key == 73) anchor= \"#details\"; else if (key == 86) anchor= \"#value\"; else if (key == 79) anchor= \"#authors\"; else if (key == 82) anchor= \"#references\"; else if (key == 69) anchor= \"#examples\"; else if (key == 83) anchor= \"#seealso\";");
        } else {
            writer.println("if (key >= 65 && key <= 90) anchor= \"#idx\"+String.fromCharCode(key+32);");
        }
        writer.println("if (anchor) { window.location.hash= anchor; event.cancelBubble= true; return false; }");
        writer.println("} return true; }");
        writer.println("document.onkeydown= keyNavHandler;");
        writer.println("/* ]]> */</script>");
        if (HOVER_STYLE.equals(req.getParameter(STYLE_PARAM))) {
            writer.println("<style type=\"text/css\">body { overflow: hidden; }</style>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void printRCode(PrintWriter writer, String html) {
        RHelpRCodeScanner rHelpRCodeScanner = this.rCodeScanner;
        synchronized (rHelpRCodeScanner) {
            IToken token;
            this.rCodeScanner.setHtml(html);
            writer.write("<span style=\"");
            writer.write(this.rCodeScanner.getDefaultStyle());
            writer.write("\">");
            int currentIdx = 0;
            while (!(token = this.rCodeScanner.nextToken()).isEOF()) {
                String data = (String)token.getData();
                if (data == null) continue;
                int tokenIdx = this.rCodeScanner.getTokenOffset();
                if (tokenIdx > currentIdx) {
                    writer.write(html, currentIdx, tokenIdx - currentIdx);
                }
                writer.write("<span style=\"");
                writer.write(data);
                writer.write("\">");
                writer.write(html, tokenIdx, this.rCodeScanner.getTokenLength());
                writer.write("</span>");
                currentIdx = tokenIdx + this.rCodeScanner.getTokenLength();
            }
            writer.write(html, currentIdx, html.length() - currentIdx);
            writer.write("</span>");
        }
    }

    public static class Browse
    extends RHelpUIServlet {
        private static final long serialVersionUID = 1L;

        @Override
        protected void collectCss(StringBuilder sb) {
            RGB docBackgroundColor = (RGB)ObjectUtils.nonNullAssert((Object)JFaceResources.getColorRegistry().getRGB("org.eclipse.statet.workbench.themes.DocViewBackgroundColor"));
            RGB docForegroundColor = (RGB)ObjectUtils.nonNullAssert((Object)JFaceResources.getColorRegistry().getRGB("org.eclipse.statet.workbench.themes.DocViewColor"));
            RGB borderColor = Display.getCurrent().getSystemColor(18).getRGB();
            FontDescriptor docFontDescr = JFaceResources.getFontDescriptor((String)"org.eclipse.statet.workbench.themes.DocViewFont");
            FontData fontData = docFontDescr.getFontData()[0];
            sb.append("body { font-family: '");
            sb.append(fontData.getName());
            sb.append("'; font-size:");
            sb.append(fontData.getHeight());
            sb.append("pt; color:");
            RHelpUIServlet.appendCssColor(sb, docForegroundColor);
            sb.append("; background:");
            RHelpUIServlet.appendCssColor(sb, docBackgroundColor);
            sb.append("; }\n");
            RHelpUIServlet.appendELinkColors(sb, docForegroundColor);
            sb.append("div.toc a, div.toc a:visited { color: ");
            RHelpUIServlet.appendCssColor(sb, docForegroundColor);
            sb.append("; }\n");
            sb.append("@media screen {\n");
            sb.append("body { margin: ");
            sb.append(LayoutUtils.defaultVSpacing());
            sb.append("px ");
            sb.append(LayoutUtils.defaultHSpacing());
            sb.append("px; }\n");
            sb.append("div.toc { display: inline; float: right; border: 1px solid ");
            RHelpUIServlet.appendCssColor(sb, borderColor);
            sb.append("; }\n");
            sb.append("span.mnemonic, div.toc a.mnemonic { text-decoration: underline; }\n");
            sb.append("hr { border: 0; height: 1px; background: ");
            RHelpUIServlet.appendCssColor(sb, borderColor);
            sb.append("; }\n");
            sb.append("}\n");
            RHelpUIServlet.appendMatchColors(sb);
            super.collectCss(sb);
        }
    }

    public static class Info
    extends RHelpUIServlet {
        private static final long serialVersionUID = 1L;

        @Override
        protected void collectCss(StringBuilder sb) {
            Display display = Display.getCurrent();
            RGB docBackgroundColor = (RGB)ObjectUtils.nonNullAssert((Object)JFaceResources.getColorRegistry().getRGB("org.eclipse.statet.workbench.themes.DocViewBackgroundColor"));
            RGB docForegroundColor = (RGB)ObjectUtils.nonNullAssert((Object)JFaceResources.getColorRegistry().getRGB("org.eclipse.statet.workbench.themes.DocViewColor"));
            int vIndent = Math.max(1, LayoutUtils.defaultVSpacing() / 4);
            int hIndent = Math.max(3, LayoutUtils.defaultHSpacing() / 2);
            FontDescriptor docFontDescr = JFaceResources.getDialogFontDescriptor();
            FontData fontData = docFontDescr.getFontData()[0];
            sb.append("body { font-family: '");
            sb.append(fontData.getName());
            sb.append("'; font-size: ");
            sb.append(fontData.getHeight());
            sb.append("pt; color: ");
            RHelpUIServlet.appendCssColor(sb, docForegroundColor);
            sb.append("; background: ");
            RHelpUIServlet.appendCssColor(sb, docBackgroundColor);
            sb.append("; margin: 0 ");
            sb.append(hIndent);
            sb.append("px ");
            sb.append(vIndent);
            sb.append("px; }\n");
            RHelpUIServlet.appendELinkColors(sb, docForegroundColor);
            sb.append("h2, h3#description { display: none; }\n");
            sb.append("h3 { font-size: 90%; margin-bottom: 0.4em; }\n");
            sb.append("p, pre { margin-top: 0.4em; margin-bottom: 0.4em; }\n");
            sb.append("hr { visibility: hidden; }\n");
            super.collectCss(sb);
        }
    }
}

