/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.DelegatingDropAdapter;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.statet.ecommons.ui.util.PluginTransferDropAdapter;
import org.eclipse.statet.ltk.refactoring.core.CommonRefactoringFactory;
import org.eclipse.statet.ltk.ui.util.ViewerSelectionTransferDropAdapter;
import org.eclipse.swt.dnd.DropTargetListener;

public class ViewerDropSupport {
    private final StructuredViewer viewer;
    private final DelegatingDropAdapter delegatingAdapter;
    private final ViewerSelectionTransferDropAdapter reorgDropListener;
    private boolean initialized;

    public ViewerDropSupport(StructuredViewer viewer, IAdaptable part, CommonRefactoringFactory refactoring) {
        this.viewer = viewer;
        this.delegatingAdapter = new DelegatingDropAdapter();
        this.reorgDropListener = new ViewerSelectionTransferDropAdapter(this.viewer, part, refactoring);
        this.reorgDropListener.setFeedbackEnabled(true);
        this.delegatingAdapter.addDropTargetListener((TransferDropTargetListener)this.reorgDropListener);
        this.delegatingAdapter.addDropTargetListener((TransferDropTargetListener)new PluginTransferDropAdapter(this.viewer));
        this.initialized = false;
    }

    public void addDropTargetListener(TransferDropTargetListener listener) {
        assert (!this.initialized);
        this.delegatingAdapter.addDropTargetListener(listener);
    }

    public void init() {
        Assert.isLegal((!this.initialized ? 1 : 0) != 0);
        this.viewer.addDropSupport(23, this.delegatingAdapter.getTransfers(), (DropTargetListener)this.delegatingAdapter);
        this.initialized = true;
    }

    public void setFeedbackEnabled(boolean enabled) {
        this.reorgDropListener.setFeedbackEnabled(enabled);
    }
}

