/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Position;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.issues.core.Problem;
import org.eclipse.statet.ltk.issues.core.ProblemRequestor;
import org.eclipse.statet.ltk.ui.sourceediting.SourceProblemAnnotation;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

@NonNullByDefault
public abstract class SourceAnnotationModel
extends ResourceMarkerAnnotationModel {
    private final AtomicInteger reportingCounter = new AtomicInteger();
    private final List<SourceProblemAnnotation> problemAnnotations = new ArrayList<SourceProblemAnnotation>();

    public SourceAnnotationModel(IResource resource) {
        super(resource);
    }

    protected abstract boolean isHandlingTemporaryProblems();

    public final ProblemRequestor createProblemRequestor() {
        this.reportingCounter.incrementAndGet();
        return this.doCreateProblemRequestor();
    }

    protected ProblemRequestor doCreateProblemRequestor() {
        return new SourceAnnotationProblemRequestor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearProblems(@Nullable String category) {
        Object object = this.getLockObject();
        synchronized (object) {
            if (this.problemAnnotations.size() > 0) {
                if (category == null) {
                    this.removeAnnotations(this.problemAnnotations, true, true);
                    this.problemAnnotations.clear();
                } else {
                    Iterator<SourceProblemAnnotation> iter = this.problemAnnotations.iterator();
                    ArrayList<SourceProblemAnnotation> toRemove = null;
                    while (iter.hasNext()) {
                        SourceProblemAnnotation annotation = iter.next();
                        if (annotation.getProblem().getCategoryId() != category) continue;
                        iter.remove();
                        if (toRemove == null) {
                            toRemove = new ArrayList<SourceProblemAnnotation>();
                        }
                        toRemove.add(annotation);
                    }
                    if (toRemove != null) {
                        this.removeAnnotations(toRemove, true, true);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportProblems(List<Problem> reportedProblems) {
        boolean reportedProblemsChanged = false;
        Object object = this.getLockObject();
        synchronized (object) {
            if (this.reportingCounter.decrementAndGet() != 0) {
                return;
            }
            if (this.problemAnnotations.size() > 0) {
                reportedProblemsChanged = true;
                this.removeAnnotations(this.problemAnnotations, false, true);
                this.problemAnnotations.clear();
            }
            if (reportedProblems != null && reportedProblems.size() > 0) {
                for (Problem problem : reportedProblems) {
                    Position position = this.createPosition(problem);
                    if (position == null) continue;
                    try {
                        SourceProblemAnnotation annotation = this.createAnnotation(problem);
                        if (annotation == null) continue;
                        this.addAnnotation(annotation, position, false);
                        this.problemAnnotations.add(annotation);
                        reportedProblemsChanged = true;
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        }
        if (reportedProblemsChanged) {
            this.fireModelChanged();
        }
    }

    protected Position createPosition(Problem problem) {
        int start = problem.getSourceStartOffset();
        int end = problem.getSourceEndOffset();
        if (start < 0 && end < 0) assert (start >= 0 && end >= 0);
        return new Position(start, end - start);
    }

    protected @Nullable SourceProblemAnnotation createAnnotation(Problem problem) {
        return null;
    }

    protected class SourceAnnotationProblemRequestor
    implements ProblemRequestor {
        protected final List<Problem> reportedProblems = new ArrayList<Problem>();
        protected final boolean handleTemporaryProblems;
        private int state = 1;

        public SourceAnnotationProblemRequestor() {
            this.handleTemporaryProblems = SourceAnnotationModel.this.isHandlingTemporaryProblems();
        }

        public void acceptProblems(Problem problem) {
            if (this.handleTemporaryProblems) {
                this.reportedProblems.add(problem);
            }
        }

        public void acceptProblems(String modelTypeId, List<Problem> problems) {
            if (this.handleTemporaryProblems) {
                this.reportedProblems.addAll(problems);
            }
        }

        public void finish() {
            if (this.state < 0) {
                throw new IllegalStateException("Already finished");
            }
            this.state = -1;
            SourceAnnotationModel.this.reportProblems(this.reportedProblems);
        }
    }
}

