/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.base.ui.markuphelp;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.docmlet.base.ui.markuphelp.MarkupHelpContent;
import org.eclipse.statet.docmlet.base.ui.markuphelp.MarkupHelpContextProvider;
import org.eclipse.statet.docmlet.base.ui.markuphelp.MarkupHelpView;
import org.eclipse.statet.ecommons.ui.actions.HandlerCollection;
import org.eclipse.statet.ecommons.ui.actions.SimpleContributionItem;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.docmlet.base.ui.DocmlBaseUIPlugin;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.statushandlers.StatusManager;

public class DocmletMarkupHelpView
extends ViewPart
implements MarkupHelpView {
    private Browser browser;
    private IPartListener2 partListener;
    private String lastHtml;

    private static void appendCssColor(StringBuilder sb, RGB color) {
        sb.append('#');
        String s = Integer.toHexString(color.red);
        if (s.length() == 1) {
            sb.append('0');
        }
        sb.append(s);
        s = Integer.toHexString(color.green);
        if (s.length() == 1) {
            sb.append('0');
        }
        sb.append(s);
        s = Integer.toHexString(color.blue);
        if (s.length() == 1) {
            sb.append('0');
        }
        sb.append(s);
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)LayoutUtils.newSashGrid());
        this.browser = new Browser(parent, 0);
        this.browser.setLayoutData((Object)new GridData(4, 4, true, true));
        Display display = this.browser.getDisplay();
        this.browser.setForeground(display.getSystemColor(28));
        this.browser.setBackground(display.getSystemColor(29));
        this.browser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent event) {
                event.browser = DocmletMarkupHelpView.this.browser;
            }
        });
        this.browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                if (event.location != null && !event.location.startsWith("about:")) {
                    DocmletMarkupHelpView.this.openExternal(event.location);
                    event.doit = false;
                }
            }

            public void changed(LocationEvent event) {
            }
        });
        IViewSite site = this.getViewSite();
        this.initActions((IServiceLocator)site, null);
        this.contributeToActionBars((IServiceLocator)site, site.getActionBars(), null);
        this.initLinking();
    }

    private void initLinking() {
        this.partListener = new IPartListener2(){

            public void partVisible(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partActivated(IWorkbenchPartReference partRef) {
                IWorkbenchPart part = partRef.getPart(false);
                if (part instanceof IEditorPart) {
                    DocmletMarkupHelpView.this.activated((IEditorPart)part);
                }
            }
        };
        this.getSite().getPage().addPartListener(this.partListener);
        UIAccess.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DocmletMarkupHelpView.this.activated(DocmletMarkupHelpView.this.getSite().getPage().getActiveEditor());
            }
        });
    }

    protected void initActions(IServiceLocator serviceLocator, HandlerCollection handlers) {
    }

    protected void contributeToActionBars(IServiceLocator serviceLocator, IActionBars actionBars, HandlerCollection handlers) {
        IMenuManager menuManager = actionBars.getMenuManager();
        List<MarkupHelpContent> topics = DocmlBaseUIPlugin.getInstance().getMarkupHelpManager().getTopicList();
        for (MarkupHelpContent topic : topics) {
            menuManager.add((IContributionItem)new SimpleContributionItem(topic.getTitle(), null, topic){
                final String topicId;
                {
                    this.topicId = markupHelpContent.getId();
                }

                protected void execute(Event event) throws ExecutionException {
                    DocmletMarkupHelpView.this.show(this.topicId);
                }
            });
        }
    }

    public void dispose() {
        if (this.partListener != null) {
            this.getSite().getPage().removePartListener(this.partListener);
            this.partListener = null;
        }
        super.dispose();
    }

    private void activated(IEditorPart editor) {
        MarkupHelpContextProvider contextProvider = (MarkupHelpContextProvider)editor.getAdapter(MarkupHelpContextProvider.class);
        if (contextProvider != null) {
            this.show(contextProvider.getHelpContentId());
        }
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    @Override
    public void show(String id) {
        MarkupHelpContent content = DocmlBaseUIPlugin.getInstance().getMarkupHelpManager().getContent(id);
        if (content != null) {
            this.setContent(content);
        }
    }

    private void setContent(MarkupHelpContent content) {
        String html;
        try {
            html = content.getContent();
        }
        catch (IOException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.docmlet.base.ui", 0, NLS.bind((String)"An error occurred while loading markup help content {0}).", (Object)content), (Throwable)e));
            DocmlBaseUIPlugin.getInstance().getMarkupHelpManager().disable(content.getId());
            return;
        }
        html = this.style(html);
        if (!html.equals(this.lastHtml)) {
            this.lastHtml = html;
            this.browser.setText(html);
        }
    }

    private String style(String html) {
        StringBuilder sb = new StringBuilder(html.length() + 200);
        int idx = html.indexOf("</head>");
        sb.append(html, 0, idx);
        sb.append("<style type=\"text/css\">\n");
        this.collectCss(sb);
        sb.append("</style>");
        sb.append(html, idx, html.length());
        return sb.toString();
    }

    private void collectCss(StringBuilder sb) {
        RGB foregroundColor = JFaceResources.getColorRegistry().getRGB("org.eclipse.statet.workbench.themes.DocViewColor");
        RGB docBackgroundColor = JFaceResources.getColorRegistry().getRGB("org.eclipse.statet.workbench.themes.DocViewBackgroundColor");
        FontDescriptor docFontDescr = JFaceResources.getFontDescriptor((String)"org.eclipse.statet.workbench.themes.DocViewFont");
        FontData fontData = docFontDescr.getFontData()[0];
        sb.append("body { font-family: '");
        sb.append(fontData.getName());
        sb.append("'; font-size: ");
        sb.append(fontData.getHeight());
        sb.append("pt; color: ");
        DocmletMarkupHelpView.appendCssColor(sb, foregroundColor);
        sb.append("; background: ");
        DocmletMarkupHelpView.appendCssColor(sb, docBackgroundColor);
        sb.append("; }\n");
        sb.append("body { margin: ");
        sb.append(LayoutUtils.defaultVSpacing());
        sb.append("px ");
        sb.append(LayoutUtils.defaultHSpacing());
        sb.append("px; }\n");
        sb.append("table, tr, th, td { font-size: ");
        sb.append(fontData.getHeight());
        sb.append("pt; }\n");
        sb.append("h4 { margin-bottom: 0.66em; }");
        sb.append("pre { margin-top: 0.66em; margin-bottom: 0.66em; }");
    }

    private void openExternal(String location) {
        IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
        try {
            IWebBrowser externalBrowser = browserSupport.createBrowser(14, "org.eclipse.statet.docmlet.base.MarkupHelp", null, null);
            URL url = new URL(location);
            externalBrowser.openURL(url);
        }
        catch (Exception e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.docmlet.base.ui", 0, "An error occurred while opening the page in an external browser.", (Throwable)e));
        }
    }
}

